/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2msg.controller.initdb;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import sanproject.sn2msg.SN2MsgLogger;
import sanproject.sn2msg.controller.SN2MsgCtrlException;
import sanproject.sn2msg.controller.SN2MsgCtrlMacro;
import sanproject.sn2msg.controller.initdb.SN2MsgCtrlInitdbBehavior;
import sanproject.sn2msg.controller.initdb.SN2MsgCtrlInitdbIcon;
import sanproject.sn2msg.controller.initdb.SN2MsgCtrlInitdbMacro;
import sanproject.sn2msg.controller.initdb.SN2MsgCtrlInitdbMeasure;
import sanproject.sn2msg.controller.initdb.SN2MsgCtrlInitdbMessage;
import sanproject.sn2msg.model.SN2MsgMdlMain;
import sanproject.sn2msg.model.data.SN2MsgMdlAllData;
import sanproject.sn2msg.model.data.SN2MsgMdlMsgData;
import sanproject.sn2msg.model.data.SN2MsgMdlMsgIdxData;

public class SN2MsgCtrlInitdbMain
implements SN2MsgCtrlMacro,
SN2MsgCtrlInitdbMacro {
    String m_StrPath = "";
    String m_StrDbName = "";

    public SN2MsgCtrlInitdbMain(String strPath, String strDbName) throws SN2MsgCtrlException {
        if (strPath != null && strDbName != null) {
            if (!this.isValidCsvPath(strPath)) {
                SN2MsgCtrlException ctrlExp = new SN2MsgCtrlException("Invalid file path:" + strPath);
                ctrlExp.setIErrorCode(4);
                SN2MsgLogger.getLogger().severe("Invalid file path:" + strPath);
                throw ctrlExp;
            }
        } else {
            SN2MsgCtrlException ctrlExp = new SN2MsgCtrlException("Invalid parameter");
            ctrlExp.setIErrorCode(3);
            SN2MsgLogger.getLogger().severe("Invalid parameter");
            throw ctrlExp;
        }
        this.m_StrPath = strPath;
        this.m_StrDbName = strDbName;
    }

    public boolean isValidCsvPath(String strPath) {
        boolean bRet = true;
        try {
            File tmpFile = new File(strPath);
            bRet = tmpFile.exists();
            if (!bRet) {
                SN2MsgLogger.getLogger().warning("Invalid file path:" + strPath);
            }
        }
        catch (Exception jvExp) {
            jvExp.printStackTrace();
            SN2MsgLogger.getLogger().warning(jvExp.toString());
            bRet = false;
        }
        return bRet;
    }

    boolean isAnnotationMsg(String strCode) {
        boolean bRet = false;
        String[] strSplitCode = strCode.split("/");
        if (3 == strSplitCode.length) {
            String strChkCode = String.valueOf(strSplitCode[0]) + strSplitCode[1];
            int iChk = 0;
            while (iChk < STR_JA_ANNOTATION.length) {
                if (strChkCode.equals(STR_JA_ANNOTATION[iChk])) {
                    bRet = true;
                    break;
                }
                ++iChk;
            }
        }
        return bRet;
    }

    public void initDB() throws SN2MsgCtrlException {
        SN2MsgCtrlException ctrlExp = null;
        SN2MsgMdlMain model = SN2MsgMdlMain.getInstance();
        if (model.initAllTables(this.m_StrDbName)) {
            try {
                ArrayList<SN2MsgMdlAllData> alSetMsg = new ArrayList<SN2MsgMdlAllData>();
                SN2MsgCtrlInitdbMessage initMsg = new SN2MsgCtrlInitdbMessage(this.m_StrPath);
                HashMap hashMsg = initMsg.getMessageData();
                ArrayList<String> alMsgId = initMsg.getAlMsgList();
                SN2MsgLogger.getLogger().info("Number of CSV Message count:" + alMsgId.size());
                SN2MsgCtrlInitdbMeasure initMsr = new SN2MsgCtrlInitdbMeasure(this.m_StrPath);
                HashMap hashMsr = initMsr.getMessageData();
                SN2MsgCtrlInitdbIcon initIcn = new SN2MsgCtrlInitdbIcon(this.m_StrPath);
                HashMap hashIcn = initIcn.getMessageData();
                SN2MsgCtrlInitdbBehavior initBhv = new SN2MsgCtrlInitdbBehavior(this.m_StrPath);
                HashMap hashBhv = initBhv.getMessageData();
                int iIdx = 0;
                while (iIdx < alMsgId.size()) {
                    String strIdx = alMsgId.get(iIdx);
                    SN2MsgMdlAllData addRecord = new SN2MsgMdlAllData();
                    SN2MsgMdlMsgIdxData msgIdxTmp = new SN2MsgMdlMsgIdxData();
                    msgIdxTmp.setStrMsgId(strIdx);
                    msgIdxTmp.setBitDisregardOem((short)0);
                    msgIdxTmp.setBRsv(false);
                    if (this.isAnnotationMsg(strIdx)) {
                        msgIdxTmp.setAnnotation((short)1);
                    } else {
                        msgIdxTmp.setAnnotation((short)0);
                    }
                    addRecord.setMsgIdx(msgIdxTmp);
                    SN2MsgMdlMsgData msgTmp = (SN2MsgMdlMsgData)hashMsg.get(strIdx);
                    if (msgTmp == null) {
                        SN2MsgLogger.getLogger().warning("Message string has failed:" + strIdx);
                        msgTmp = new SN2MsgMdlMsgData();
                        msgTmp.setStrMsgId(strIdx);
                    }
                    addRecord.setMessage(msgTmp);
                    SN2MsgMdlMsgData msrTmp = (SN2MsgMdlMsgData)hashMsr.get(strIdx);
                    if (msrTmp == null) {
                        SN2MsgLogger.getLogger().warning("Measure string has failed:" + strIdx);
                        msrTmp = new SN2MsgMdlMsgData();
                        msrTmp.setStrMsgId(strIdx);
                    }
                    addRecord.setMeasure(msrTmp);
                    SN2MsgMdlMsgData icnTmp = (SN2MsgMdlMsgData)hashIcn.get(strIdx);
                    if (icnTmp == null) {
                        SN2MsgLogger.getLogger().warning("Icon string has failed:" + strIdx);
                        icnTmp = new SN2MsgMdlMsgData();
                        icnTmp.setStrMsgId(strIdx);
                    }
                    addRecord.setIcon(icnTmp);
                    SN2MsgMdlMsgData bhvTmp = (SN2MsgMdlMsgData)hashBhv.get(strIdx);
                    if (bhvTmp == null) {
                        SN2MsgLogger.getLogger().warning("Behavior string has failed:" + strIdx);
                        bhvTmp = new SN2MsgMdlMsgData();
                        bhvTmp.setStrMsgId(strIdx);
                    }
                    addRecord.setBehavior(bhvTmp);
                    alSetMsg.add(addRecord);
                    if (100 == alSetMsg.size()) {
                        model.makeRecords(this.m_StrDbName, alSetMsg);
                        alSetMsg.clear();
                    }
                    ++iIdx;
                }
                if (alSetMsg.size() != 0) {
                    model.makeRecords(this.m_StrDbName, alSetMsg);
                    alSetMsg.clear();
                }
            }
            catch (SN2MsgCtrlException ctrExp) {
                SN2MsgLogger.getLogger().severe("Error reason:" + ctrExp.getIErrorCode());
                SN2MsgLogger.getLogger().severe(ctrExp.getMessage());
                ctrlExp = ctrExp;
            }
            catch (Exception jvExp) {
                jvExp.printStackTrace();
                SN2MsgLogger.getLogger().severe(jvExp.getMessage());
                ctrlExp = new SN2MsgCtrlException(jvExp.getMessage());
                ctrlExp.setIErrorCode(-1);
            }
        } else {
            SN2MsgLogger.getLogger().warning("DB initialize failed.DB:" + this.m_StrDbName);
            ctrlExp = new SN2MsgCtrlException("DB initialize failed.DB:" + this.m_StrDbName);
            ctrlExp.setIErrorCode(5);
        }
        if (ctrlExp != null) {
            throw ctrlExp;
        }
    }
}

