/*
 * Decompiled with CFR 0.152.
 */
package sample.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.math.NumberUtils;
import sample.data.MsgIndexComparator;

public class MsgIndex {
    private int buicode;
    private int errorcode;
    private int filetype;
    private int internalid;
    private int bunrui;
    private String buicodeStr;
    private String errorcodeStr;
    private String filetypeStr;
    private String internalidStr;
    private String bunruiStr;

    public static void main(String[] args) throws IOException {
        ArrayList<MsgIndex> mis = new ArrayList<MsgIndex>();
        List lines = FileUtils.readLines(new File("MsgIndex_in.txt"));
        for (String l : lines) {
            String[] cs = l.split("\t");
            MsgIndex mi = new MsgIndex(cs[0], cs[1], cs[2], cs[3], cs[4]);
            mis.add(mi);
        }
        Collections.sort(mis, new MsgIndexComparator());
        FileUtils.writeLines(new File("MsgIndex_out.txt"), mis);
    }

    public MsgIndex(String buicodeStr, String errorcodeStr, String filetypeStr, String internalidStr, String bunruiStr) {
        this.buicode = NumberUtils.toInt(buicodeStr, -1);
        this.errorcode = NumberUtils.toInt(errorcodeStr, -1);
        this.filetype = NumberUtils.toInt(filetypeStr, -1);
        this.internalid = NumberUtils.toInt(internalidStr, -1);
        this.bunrui = NumberUtils.toInt(bunruiStr, -1);
        this.buicodeStr = buicodeStr;
        this.errorcodeStr = errorcodeStr;
        this.filetypeStr = filetypeStr;
        this.internalidStr = internalidStr;
        this.bunruiStr = bunruiStr;
    }

    public int getBuicode() {
        return this.buicode;
    }

    public void setBuicode(int buicode) {
        this.buicode = buicode;
    }

    public int getErrorcode() {
        return this.errorcode;
    }

    public void setErrorcode(int errorcode) {
        this.errorcode = errorcode;
    }

    public int getFiletype() {
        return this.filetype;
    }

    public void setFiletype(int filetype) {
        this.filetype = filetype;
    }

    public int getInternalid() {
        return this.internalid;
    }

    public void setInternalid(int internalid) {
        this.internalid = internalid;
    }

    public int getBunrui() {
        return this.bunrui;
    }

    public void setBunrui(int bunrui) {
        this.bunrui = bunrui;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buicode);
        sb.append("\t");
        sb.append(this.errorcodeStr);
        sb.append("\t");
        sb.append(this.filetypeStr);
        sb.append("\t");
        sb.append(this.internalidStr);
        sb.append("\t");
        sb.append(this.bunruiStr);
        return sb.toString();
    }
}

