/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.data.RJMdDataLDEV;
import sanproject.getmondat.data.RJMdDataPG;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdUnitEntry;
import sanproject.getmondat.group.RJMdUnitSerialStream;
import sanproject.serverux.arg.monitor.ArgLDEVAbility;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.LDEVMonitorLDEVAbility;
import sanproject.serverux.data.MonitorInfoCollection;

public class RJMdGroupLDEV
extends RJMdGroupData {
    private static final String groupID = "LDEV";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "LDEV_dat";
    private static final String groupInfo = "LDEV data";
    public static final int LIMIT_PARAMS_LDEV = 128;
    private HashMap unitStreams = null;
    private static final String UN_LDEV_IOPS = "LDEV_IOPS";
    private static final String UN_LDEV_TransRate = "LDEV_TransRate";
    private static final String UN_LDEV_Read_TransRate = "LDEV_Read_TransRate";
    private static final String UN_LDEV_Write_TransRate = "LDEV_Write_TransRate";
    private static final String UN_LDEV_Read_IOPS = "LDEV_Read_IOPS";
    private static final String UN_LDEV_Write_IOPS = "LDEV_Write_IOPS";
    private static final String UN_LDEV_Read_Hit = "LDEV_Read_Hit";
    private static final String UN_LDEV_Write_Hit = "LDEV_Write_Hit";
    private static final String UN_LDEV_BackTrans = "LDEV_BackTrans";
    private static final String UN_LDEV_Seq_Read_IOPS = "LDEV_Seq_Read_IOPS";
    private static final String UN_LDEV_Rnd_Read_IOPS = "LDEV_Rnd_Read_IOPS";
    private static final String UN_LDEV_Seq_Write_IOPS = "LDEV_Seq_Write_IOPS";
    private static final String UN_LDEV_Rnd_Write_IOPS = "LDEV_Rnd_Write_IOPS";
    private static final String UN_LDEV_Seq_Read_Hit = "LDEV_Seq_Read_Hit";
    private static final String UN_LDEV_Rnd_Read_Hit = "LDEV_Rnd_Read_Hit";
    private static final String UN_LDEV_Seq_Write_Hit = "LDEV_Seq_Write_Hit";
    private static final String UN_LDEV_Rnd_Write_Hit = "LDEV_Rnd_Write_Hit";
    private static final String UN_LDEV_C2D_Trans = "LDEV_C2D_Trans";
    private static final String UN_LDEV_D2CS_Trans = "LDEV_D2CS_Trans";
    private static final String UN_LDEV_D2CR_Trans = "LDEV_D2CR_Trans";
    private static final String UN_LDEV_Response = "LDEV_Response";
    private static final String UN_LDEV_Read_Response = "LDEV_Read_Response";
    private static final String UN_LDEV_Write_Response = "LDEV_Write_Response";
    private String[] unitNames = unitNames_raid;
    private static final String[] unitNames_raid = new String[]{"LDEV_IOPS", "LDEV_TransRate", "LDEV_Read_TransRate", "LDEV_Write_TransRate", "LDEV_Read_IOPS", "LDEV_Write_IOPS", "LDEV_Read_Hit", "LDEV_Write_Hit", "LDEV_BackTrans", "LDEV_Seq_Read_IOPS", "LDEV_Rnd_Read_IOPS", "LDEV_Seq_Write_IOPS", "LDEV_Rnd_Write_IOPS", "LDEV_Seq_Read_Hit", "LDEV_Rnd_Read_Hit", "LDEV_Seq_Write_Hit", "LDEV_Rnd_Write_Hit", "LDEV_C2D_Trans", "LDEV_D2CS_Trans", "LDEV_D2CR_Trans", "LDEV_Response", "LDEV_Read_Response", "LDEV_Write_Response"};
    private static final String[] unitNames_hm = new String[]{"LDEV_IOPS", "LDEV_TransRate", "LDEV_Read_TransRate", "LDEV_Write_TransRate", "LDEV_Read_IOPS", "LDEV_Write_IOPS", "LDEV_Read_Hit", "LDEV_Write_Hit", "LDEV_BackTrans", "LDEV_Seq_Read_IOPS", "LDEV_Rnd_Read_IOPS", "LDEV_Seq_Write_IOPS", "LDEV_Rnd_Write_IOPS", "LDEV_Seq_Read_Hit", "LDEV_Rnd_Read_Hit", "LDEV_Seq_Write_Hit", "LDEV_Rnd_Write_Hit", "LDEV_C2D_Trans", "LDEV_D2CS_Trans", "LDEV_D2CR_Trans", "LDEV_Response", "LDEV_Read_Response", "LDEV_Write_Response"};

    public RJMdGroupLDEV(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
    }

    public void init() throws IOException {
        this.unitNames = this.controller.isHM() ? unitNames_hm : unitNames_raid;
        String string = this.parameter.getDirectory();
        File file = new File(string);
        File file2 = new File(file.getAbsolutePath(), groupName);
        this.unitStreams = new HashMap();
        for (int i = 0; i < this.unitNames.length; ++i) {
            RJMdUnitSerialStream rJMdUnitSerialStream = new RJMdUnitSerialStream(this.unitNames[i], file2);
            rJMdUnitSerialStream.setCompress(this.parameter.isCompless());
            this.unitStreams.put(this.unitNames[i], rJMdUnitSerialStream);
        }
    }

    protected boolean isGroupExists() {
        String string = this.parameter.getDirectory();
        File file = new File(string, groupName);
        boolean bl = file.exists() && file.isDirectory();
        return bl;
    }

    public void deleteGroup() {
        for (int i = 0; i < this.unitNames.length; ++i) {
            this.stream(this.unitNames[i]).deleteAll();
        }
        String string = this.parameter.getDirectory();
        File file = new File(string, groupName);
        this.stream(this.unitNames[0]).deletePath(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup() throws RJMdRmiException, IOException {
        try {
            this.createGroupLDEV();
        }
        finally {
            for (int i = 0; i < this.unitNames.length; ++i) {
                this.stream(this.unitNames[i]).closeEntry();
                this.stream(this.unitNames[i]).close();
            }
        }
    }

    private void createGroupLDEV() throws RJMdRmiException, IOException {
        this.putInfomation("INF006", this.getGroupInfo());
        String string = this.parameter.getDirectory();
        File file = new File(string, groupName);
        if (!file.exists()) {
            file.mkdirs();
        }
        RJMdTimeRange rJMdTimeRange = this.parameter.getShortRange();
        CollectParam collectParam = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
        ArrayList arrayList = this.controller.getPG();
        this.controller.createLdevCache(arrayList);
        this.initProgress(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPG rJMdDataPG = (RJMdDataPG)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPG)) continue;
            ArrayList arrayList2 = this.controller.getPGToLDEV(rJMdDataPG.getFB4(), rJMdDataPG.getPG(), 1);
            Iterator iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                RJMdDataLDEV rJMdDataLDEV = (RJMdDataLDEV)iterator2.next();
                if (collectParam.size() >= 128) {
                    this.collect(this.unitStreams, collectParam);
                    this.addProgress(collectParam.size());
                    collectParam = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
                }
                collectParam.add(rJMdDataPG, rJMdDataLDEV);
            }
        }
        this.collect(this.unitStreams, collectParam);
        this.addProgress(collectParam.size());
        this.closeProgress();
        this.putInfomation("INF007", this.getGroupInfo());
    }

    private void initProgress(ArrayList arrayList) throws RJMdRmiException {
        int n = 0;
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPG rJMdDataPG = (RJMdDataPG)iterator.next();
            ArrayList arrayList2 = this.controller.getPGToLDEV(rJMdDataPG.getFB4(), rJMdDataPG.getPG(), 1);
            n2 += arrayList2.size();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPG)) continue;
            n += arrayList2.size();
        }
        super.initProgress(n, n2);
    }

    public void collect(HashMap hashMap, CollectParam collectParam) throws RJMdRmiException, IOException {
        if (collectParam.size() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)collectParam.getArgument());
            for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                LDEVMonitorLDEVAbility lDEVMonitorLDEVAbility = (LDEVMonitorLDEVAbility)monitorInfoCollection.get(i);
                String string = this.toHexString(lDEVMonitorLDEVAbility.getLdkc(), 2) + ":" + this.toHexString(lDEVMonitorLDEVAbility.getCu(), 2) + ":" + this.toHexString(lDEVMonitorLDEVAbility.getLdev(), 2);
                RJMdDataPG rJMdDataPG = collectParam.getPG(lDEVMonitorLDEVAbility.getLdkc(), lDEVMonitorLDEVAbility.getCu(), lDEVMonitorLDEVAbility.getLdev());
                String string2 = rJMdDataPG.toString();
                if (rJMdDataPG.isAOUVVol() || rJMdDataPG.isQSVVol() || rJMdDataPG.isALUVVol()) continue;
                if (rJMdDataPG.isExternal()) {
                    string = string + " " + '#';
                } else if (rJMdDataPG.isQSVVol()) {
                    string = string + " " + 'V';
                } else if (rJMdDataPG.isAOUVVol()) {
                    string = string + " " + 'X';
                } else if (rJMdDataPG.isExternal_MF()) {
                    string = string + " " + 'M';
                }
                for (int j = 0; j < this.unitNames.length; ++j) {
                    String string3 = this.stream(this.unitNames[j]).getName() + "_" + string2;
                    RJMdUnitEntry rJMdUnitEntry = this.stream(this.unitNames[j]).getCurrentEntry();
                    if (rJMdUnitEntry != null && rJMdUnitEntry.getName().equals(string3)) continue;
                    if (rJMdUnitEntry != null) {
                        this.stream(this.unitNames[j]).closeEntry();
                    }
                    this.stream(this.unitNames[j]).createEntry(string3, this.getTimeRange());
                }
                this.stream(UN_LDEV_IOPS).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getIOPerSec()));
                this.stream(UN_LDEV_TransRate).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getTransRate()));
                this.stream(UN_LDEV_Read_TransRate).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getReadTransRate()));
                this.stream(UN_LDEV_Write_TransRate).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getWriteTransRate()));
                this.stream(UN_LDEV_Read_IOPS).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getReadIOPerSec()));
                this.stream(UN_LDEV_Write_IOPS).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getWriteIOPerSec()));
                this.stream(UN_LDEV_Read_Hit).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getReadHit()));
                this.stream(UN_LDEV_Write_Hit).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getWriteHit()));
                this.stream(UN_LDEV_BackTrans).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getDataTransCtoD()));
                this.stream(UN_LDEV_Seq_Read_IOPS).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getReadSeq()));
                this.stream(UN_LDEV_Rnd_Read_IOPS).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getReadRnd()));
                this.stream(UN_LDEV_Seq_Write_IOPS).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getWriteSeq()));
                this.stream(UN_LDEV_Rnd_Write_IOPS).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getWriteRnd()));
                this.stream(UN_LDEV_Seq_Read_Hit).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getReadHitSeq()));
                this.stream(UN_LDEV_Rnd_Read_Hit).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getReadHitRnd()));
                this.stream(UN_LDEV_Seq_Write_Hit).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getWriteHitSeq()));
                this.stream(UN_LDEV_Rnd_Write_Hit).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getWriteHitRnd()));
                this.stream(UN_LDEV_C2D_Trans).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getBackTransCtoD()));
                this.stream(UN_LDEV_D2CS_Trans).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getBackTransDtoCSeq()));
                this.stream(UN_LDEV_D2CR_Trans).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getBackTransDtoCRnd()));
                this.stream(UN_LDEV_Response).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getResponseTime()));
                this.stream(UN_LDEV_Read_Response).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getReadResponseTime()));
                this.stream(UN_LDEV_Write_Response).write(new RJMdColumn(string, lDEVMonitorLDEVAbility.getWriteResponseTime()));
            }
        }
    }

    private RJMdUnitSerialStream stream(String string) {
        return (RJMdUnitSerialStream)this.unitStreams.get(string);
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo() {
        return groupInfo;
    }

    public RJMdTimeRange getTimeRange() {
        return this.parameter.getShortRange();
    }

    public void analyzeOperand(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        char c = rJMdCmdParser.getKind();
        String string = rJMdCmdParser.getToken();
        if ((string.equals("internal") || string.equals("virtual")) && !string.equals(this.getGroupID())) {
            while ((rJMdRange = this.analyzeVolumeTypeRange(rJMdCmdParser)) != null) {
                RJMdDataControl.trace("\tVolumeType =  " + rJMdRange);
                this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
                if (rJMdCmdParser.getKind() == ' ') {
                    rJMdCmdParser.nextToken();
                    continue;
                }
                break;
            }
        } else {
            while ((rJMdRange = this.analyzePGrpRange(rJMdCmdParser, 19)) != null) {
                RJMdDataControl.trace("\tPG =  " + rJMdRange);
                this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
                if (rJMdCmdParser.getKind() == ' ') {
                    rJMdCmdParser.nextToken();
                    continue;
                }
                break;
            }
        }
    }

    class CollectParam {
        private ArgLDEVAbility argument = null;
        private ArrayList fb4pgs = new ArrayList();
        private ArrayList ldevParms = new ArrayList();

        CollectParam(Date date, Date date2) {
            this.argument = new ArgLDEVAbility(1, date, date2);
        }

        public void add(RJMdDataPG rJMdDataPG, RJMdDataLDEV rJMdDataLDEV) {
            this.fb4pgs.add(rJMdDataPG);
            this.ldevParms.add(rJMdDataLDEV);
            this.argument.addLDEV(rJMdDataLDEV.getLDKC(), rJMdDataLDEV.getCU(), rJMdDataLDEV.getLDEV());
        }

        public int size() {
            return this.argument.size();
        }

        public RJMdDataPG getPG(int n) {
            return (RJMdDataPG)this.fb4pgs.get(n);
        }

        public RJMdDataPG getPG(int n, int n2, int n3) {
            RJMdDataPG rJMdDataPG = null;
            Iterator iterator = this.ldevParms.iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                RJMdDataLDEV rJMdDataLDEV = (RJMdDataLDEV)iterator.next();
                if (rJMdDataLDEV.getLDKC() == n && rJMdDataLDEV.getCU() == n2 && rJMdDataLDEV.getLDEV() == n3) {
                    rJMdDataPG = this.getPG(n4);
                    break;
                }
                ++n4;
            }
            return rJMdDataPG;
        }

        public ArgLDEVAbility getArgument() {
            return this.argument;
        }
    }
}

