/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataCU;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.data.RJMdDataLDEV;
import sanproject.getmondat.data.RJMdDataPG;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdUnitEntry;
import sanproject.getmondat.group.RJMdUnitSerialStream;
import sanproject.serverux.arg.monitor.ArgLDEVAbility;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.LDEVMonitorLDEVAbility;
import sanproject.serverux.data.MonitorInfoCollection;
import sanproject.serverux.dataimpl.DKCgetPGLDEVNumber;

public class RJMdGroupLDEVEachOfCU
extends RJMdGroupData {
    private static final String groupID = "LDEVEachOfCU";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "LDEVEachOfCU_dat";
    private static final String groupInfo = "LDEVEachOfCU data";
    public static final int LIMIT_PARAMS_LDEV = 128;
    private HashMap unitStreams = null;
    public static final String INTERNAL = "internal";
    public static final String VIRTUAL = "virtual";
    private static final String UN_LDEV_IOPS = "LDEV_IOPS";
    private static final String UN_LDEV_TransRate = "LDEV_TransRate";
    private static final String UN_LDEV_Read_TransRate = "LDEV_Read_TransRate";
    private static final String UN_LDEV_Write_TransRate = "LDEV_Write_TransRate";
    private static final String UN_LDEV_Read_IOPS = "LDEV_Read_IOPS";
    private static final String UN_LDEV_Write_IOPS = "LDEV_Write_IOPS";
    private static final String UN_LDEV_Read_Hit = "LDEV_Read_Hit";
    private static final String UN_LDEV_Write_Hit = "LDEV_Write_Hit";
    private static final String UN_LDEV_BackTrans = "LDEV_BackTrans";
    private static final String UN_LDEV_Seq_Read_IOPS = "LDEV_Seq_Read_IOPS";
    private static final String UN_LDEV_Rnd_Read_IOPS = "LDEV_Rnd_Read_IOPS";
    private static final String UN_LDEV_Seq_Write_IOPS = "LDEV_Seq_Write_IOPS";
    private static final String UN_LDEV_Rnd_Write_IOPS = "LDEV_Rnd_Write_IOPS";
    private static final String UN_LDEV_Seq_Read_Hit = "LDEV_Seq_Read_Hit";
    private static final String UN_LDEV_Rnd_Read_Hit = "LDEV_Rnd_Read_Hit";
    private static final String UN_LDEV_Seq_Write_Hit = "LDEV_Seq_Write_Hit";
    private static final String UN_LDEV_Rnd_Write_Hit = "LDEV_Rnd_Write_Hit";
    private static final String UN_LDEV_C2D_Trans = "LDEV_C2D_Trans";
    private static final String UN_LDEV_D2CS_Trans = "LDEV_D2CS_Trans";
    private static final String UN_LDEV_D2CR_Trans = "LDEV_D2CR_Trans";
    private static final String UN_LDEV_Response = "LDEV_Response";
    private static final String UN_LDEV_Read_Response = "LDEV_Read_Response";
    private static final String UN_LDEV_Write_Response = "LDEV_Write_Response";
    private String[] unitNames = unitNames_raid;
    private static final String[] unitNames_raid = new String[]{"LDEV_IOPS", "LDEV_TransRate", "LDEV_Read_TransRate", "LDEV_Write_TransRate", "LDEV_Read_IOPS", "LDEV_Write_IOPS", "LDEV_Read_Hit", "LDEV_Write_Hit", "LDEV_BackTrans", "LDEV_Seq_Read_IOPS", "LDEV_Rnd_Read_IOPS", "LDEV_Seq_Write_IOPS", "LDEV_Rnd_Write_IOPS", "LDEV_Seq_Read_Hit", "LDEV_Rnd_Read_Hit", "LDEV_Seq_Write_Hit", "LDEV_Rnd_Write_Hit", "LDEV_C2D_Trans", "LDEV_D2CS_Trans", "LDEV_D2CR_Trans", "LDEV_Response", "LDEV_Read_Response", "LDEV_Write_Response"};
    private static final String[] unitNames_hm = new String[]{"LDEV_IOPS", "LDEV_TransRate", "LDEV_Read_TransRate", "LDEV_Write_TransRate", "LDEV_Read_IOPS", "LDEV_Write_IOPS", "LDEV_Read_Hit", "LDEV_Write_Hit", "LDEV_BackTrans", "LDEV_Seq_Read_IOPS", "LDEV_Rnd_Read_IOPS", "LDEV_Seq_Write_IOPS", "LDEV_Rnd_Write_IOPS", "LDEV_Seq_Read_Hit", "LDEV_Rnd_Read_Hit", "LDEV_Seq_Write_Hit", "LDEV_Rnd_Write_Hit", "LDEV_C2D_Trans", "LDEV_D2CS_Trans", "LDEV_D2CR_Trans", "LDEV_Response", "LDEV_Read_Response", "LDEV_Write_Response"};

    public RJMdGroupLDEVEachOfCU(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
    }

    public void init() throws IOException {
        this.unitNames = this.controller.isHM() ? unitNames_hm : unitNames_raid;
        String string = this.parameter.getDirectory();
        File file = new File(string);
        File file2 = new File(file.getAbsolutePath(), groupName);
        this.unitStreams = new HashMap();
        for (int i = 0; i < this.unitNames.length; ++i) {
            RJMdUnitSerialStream rJMdUnitSerialStream = new RJMdUnitSerialStream(this.unitNames[i], file2);
            rJMdUnitSerialStream.setCompress(this.parameter.isCompless());
            this.unitStreams.put(this.unitNames[i], rJMdUnitSerialStream);
        }
    }

    protected boolean isGroupExists() {
        String string = this.parameter.getDirectory();
        File file = new File(string, groupName);
        boolean bl = file.exists() && file.isDirectory();
        return bl;
    }

    public void deleteGroup() {
        for (int i = 0; i < this.unitNames.length; ++i) {
            this.stream(this.unitNames[i]).deleteAll();
        }
        String string = this.parameter.getDirectory();
        File file = new File(string, groupName);
        this.stream(this.unitNames[0]).deletePath(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup() throws RJMdRmiException, IOException {
        try {
            this.createGroupLDEVEachOfCU();
        }
        finally {
            for (int i = 0; i < this.unitNames.length; ++i) {
                this.stream(this.unitNames[i]).closeEntry();
                this.stream(this.unitNames[i]).close();
            }
        }
    }

    private void createGroupLDEVEachOfCU() throws RJMdRmiException, IOException {
        String string = null;
        this.putInfomation("INF006", this.getGroupInfo());
        String string2 = this.parameter.getDirectory();
        File file = new File(string2, groupName);
        if (!file.exists()) {
            file.mkdirs();
        }
        RJMdTimeRange rJMdTimeRange = this.parameter.getShortRange();
        CollectParam collectParam = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
        ArrayList arrayList = this.controller.getPG();
        this.controller.createPgChache(arrayList);
        ArrayList arrayList2 = this.controller.getCU();
        this.initProgress(arrayList2);
        Iterator iterator = arrayList2.iterator();
        ArrayList arrayList3 = this.parameter.getGroupRange(this.getGroupID());
        if (arrayList3 != null) {
            string = this.getVolumeType(arrayList3);
        }
        while (iterator.hasNext()) {
            ArrayList arrayList4;
            RJMdDataCU rJMdDataCU = (RJMdDataCU)iterator.next();
            if (string != null) {
                arrayList4 = this.getVolumeTypeTarget(rJMdDataCU, string);
                collectParam = this.createCollectParam(collectParam, arrayList4, rJMdTimeRange);
                continue;
            }
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataCU)) continue;
            arrayList4 = this.controller.getCUToLDEVbyEachOfCU(rJMdDataCU.getLDKC(), rJMdDataCU.getCU());
            collectParam = this.createCollectParam(collectParam, arrayList4, rJMdTimeRange);
        }
        this.collect(this.unitStreams, collectParam);
        this.addProgress(collectParam.size());
        this.closeProgress();
        this.putInfomation("INF007", this.getGroupInfo());
    }

    private CollectParam createCollectParam(CollectParam collectParam, ArrayList arrayList, RJMdTimeRange rJMdTimeRange) throws RJMdRmiException, IOException {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataLDEV rJMdDataLDEV = (RJMdDataLDEV)iterator.next();
            if (collectParam.size() >= 128) {
                this.collect(this.unitStreams, collectParam);
                this.addProgress(collectParam.size());
                collectParam = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
            }
            collectParam.add(rJMdDataLDEV);
        }
        return collectParam;
    }

    private void initProgress(ArrayList arrayList) throws RJMdRmiException {
        int n = 0;
        int n2 = 0;
        String string = null;
        Iterator iterator = arrayList.iterator();
        ArrayList arrayList2 = this.parameter.getGroupRange(this.getGroupID());
        if (arrayList2 != null) {
            string = this.getVolumeType(arrayList2);
        }
        while (iterator.hasNext()) {
            RJMdDataCU rJMdDataCU = (RJMdDataCU)iterator.next();
            ArrayList arrayList3 = this.controller.getCUToLDEVbyEachOfCU(rJMdDataCU.getLDKC(), rJMdDataCU.getCU());
            n2 += arrayList3.size();
            if (string != null) {
                ArrayList arrayList4 = this.getVolumeTypeTarget(arrayList3, string);
                n += arrayList4.size();
                continue;
            }
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataCU)) continue;
            n += arrayList3.size();
        }
        super.initProgress(n, n2);
    }

    private ArrayList getVolumeTypeTarget(RJMdDataCU rJMdDataCU, String string) throws RJMdRmiException {
        ArrayList arrayList = this.controller.getCUToLDEVbyEachOfCU(rJMdDataCU.getLDKC(), rJMdDataCU.getCU());
        return this.getVolumeTypeTarget(arrayList, string);
    }

    private ArrayList getVolumeTypeTarget(ArrayList arrayList, String string) {
        ArrayList<RJMdDataLDEV> arrayList2;
        block3: {
            Iterator iterator;
            block2: {
                arrayList2 = new ArrayList<RJMdDataLDEV>();
                iterator = arrayList.iterator();
                if (!string.equals(INTERNAL)) break block2;
                while (iterator.hasNext()) {
                    RJMdDataLDEV rJMdDataLDEV = (RJMdDataLDEV)iterator.next();
                    if (!rJMdDataLDEV.isNormal()) continue;
                    arrayList2.add(rJMdDataLDEV);
                }
                break block3;
            }
            if (!string.equals(VIRTUAL)) break block3;
            while (iterator.hasNext()) {
                RJMdDataLDEV rJMdDataLDEV = (RJMdDataLDEV)iterator.next();
                if (rJMdDataLDEV.isNormal()) continue;
                arrayList2.add(rJMdDataLDEV);
            }
        }
        return arrayList2;
    }

    public void collect(HashMap hashMap, CollectParam collectParam) throws RJMdRmiException, IOException {
        if (collectParam.size() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)collectParam.getArgument());
            for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                LDEVMonitorLDEVAbility lDEVMonitorLDEVAbility = (LDEVMonitorLDEVAbility)monitorInfoCollection.get(i);
                RJMdDataLDEV rJMdDataLDEV = (RJMdDataLDEV)collectParam.ldevParms.get(i);
                DKCgetPGLDEVNumber dKCgetPGLDEVNumber = this.controller.getLDEVToPG(lDEVMonitorLDEVAbility.getLdkc(), lDEVMonitorLDEVAbility.getCu(), lDEVMonitorLDEVAbility.getLdev());
                String string = this.toHexString(lDEVMonitorLDEVAbility.getLdkc(), 2) + ":" + this.toHexString(lDEVMonitorLDEVAbility.getCu(), 2) + ":" + this.toHexString(lDEVMonitorLDEVAbility.getLdev(), 2);
                String string2 = "-";
                if (dKCgetPGLDEVNumber != null) {
                    string2 = this.getColumnName(dKCgetPGLDEVNumber.iFB4, dKCgetPGLDEVNumber.iPG, rJMdDataLDEV, string);
                } else {
                    RJMdDataControl.trace("LdevEachOfCu command detected configration unmatch.");
                }
                for (int j = 0; j < this.unitNames.length; ++j) {
                    String string3 = this.stream(this.unitNames[j]).getName() + this.toHexString(lDEVMonitorLDEVAbility.getCu(), 2);
                    RJMdUnitEntry rJMdUnitEntry = this.stream(this.unitNames[j]).getCurrentEntry();
                    if (rJMdUnitEntry != null && rJMdUnitEntry.getName().equals(string3)) continue;
                    if (rJMdUnitEntry != null) {
                        this.stream(this.unitNames[j]).closeEntry();
                    }
                    this.stream(this.unitNames[j]).createEntry(string3, this.getTimeRange());
                }
                this.stream(UN_LDEV_IOPS).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getIOPerSec()));
                this.stream(UN_LDEV_TransRate).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getTransRate()));
                this.stream(UN_LDEV_Read_TransRate).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getReadTransRate()));
                this.stream(UN_LDEV_Write_TransRate).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getWriteTransRate()));
                this.stream(UN_LDEV_Read_IOPS).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getReadIOPerSec()));
                this.stream(UN_LDEV_Write_IOPS).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getWriteIOPerSec()));
                this.stream(UN_LDEV_Read_Hit).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getReadHit()));
                this.stream(UN_LDEV_Write_Hit).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getWriteHit()));
                this.stream(UN_LDEV_BackTrans).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getDataTransCtoD()));
                this.stream(UN_LDEV_Seq_Read_IOPS).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getReadSeq()));
                this.stream(UN_LDEV_Rnd_Read_IOPS).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getReadRnd()));
                this.stream(UN_LDEV_Seq_Write_IOPS).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getWriteSeq()));
                this.stream(UN_LDEV_Rnd_Write_IOPS).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getWriteRnd()));
                this.stream(UN_LDEV_Seq_Read_Hit).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getReadHitSeq()));
                this.stream(UN_LDEV_Rnd_Read_Hit).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getReadHitRnd()));
                this.stream(UN_LDEV_Seq_Write_Hit).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getWriteHitSeq()));
                this.stream(UN_LDEV_Rnd_Write_Hit).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getWriteHitRnd()));
                this.stream(UN_LDEV_C2D_Trans).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getBackTransCtoD()));
                this.stream(UN_LDEV_D2CS_Trans).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getBackTransDtoCSeq()));
                this.stream(UN_LDEV_D2CR_Trans).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getBackTransDtoCRnd()));
                this.stream(UN_LDEV_Response).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getResponseTime()));
                this.stream(UN_LDEV_Read_Response).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getReadResponseTime()));
                this.stream(UN_LDEV_Write_Response).write(new RJMdColumn(string2, lDEVMonitorLDEVAbility.getWriteResponseTime()));
            }
        }
    }

    private String getColumnName(int n, int n2, RJMdDataLDEV rJMdDataLDEV, String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (rJMdDataLDEV.isExternal()) {
            string2 = String.valueOf('E');
            string3 = String.valueOf('#');
            n -= 100;
        } else if (rJMdDataLDEV.isAouVol()) {
            string2 = String.valueOf('X');
            string3 = String.valueOf('X');
            n = (n - 16485) * 2048 + n2;
            n2 = 1;
        } else if (rJMdDataLDEV.isAluVol()) {
            string2 = String.valueOf('A');
            string3 = String.valueOf('A');
            n = (n - 97) * 64 + n2;
            n2 = 1;
        } else if (rJMdDataLDEV.isVirtualVol()) {
            string2 = String.valueOf('V');
            string3 = String.valueOf('V');
            n = (n - 65) * 2048 + n2;
            n2 = 1;
        } else if (rJMdDataLDEV.isExternalMF()) {
            string2 = String.valueOf('M');
            string3 = String.valueOf('M');
            n -= 16640;
        }
        string4 = rJMdDataLDEV.isAouVol() || rJMdDataLDEV.isAluVol() || rJMdDataLDEV.isVirtualVol() ? string + string3 : string + string3 + "(" + string2 + String.valueOf(n) + "-" + String.valueOf(n2) + ")";
        return string4;
    }

    private RJMdUnitSerialStream stream(String string) {
        return (RJMdUnitSerialStream)this.unitStreams.get(string);
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo() {
        return groupInfo;
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public RJMdTimeRange getTimeRange() {
        return this.parameter.getShortRange();
    }

    public void analyzeOperand(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        char c = rJMdCmdParser.getKind();
        String string = rJMdCmdParser.getToken();
        if ((string.equals(INTERNAL) || string.equals(VIRTUAL)) && !string.equals(this.getGroupID())) {
            while ((rJMdRange = this.analyzeVolumeTypeRange(rJMdCmdParser)) != null) {
                RJMdDataControl.trace("\tVolumeType =  " + rJMdRange);
                this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
                if (rJMdCmdParser.getKind() == ' ') {
                    rJMdCmdParser.nextToken();
                    continue;
                }
                break;
            }
        } else {
            while ((rJMdRange = this.analyzeCURange(rJMdCmdParser)) != null) {
                RJMdDataControl.trace("\tCU =  " + rJMdRange);
                this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
                if (rJMdCmdParser.getKind() == ' ') {
                    rJMdCmdParser.nextToken();
                    continue;
                }
                break;
            }
        }
    }

    public String getVolumeType(ArrayList arrayList) {
        RJMdRange rJMdRange;
        Iterator iterator;
        String string = null;
        if (arrayList != null && arrayList.size() > 0 && (iterator = arrayList.iterator()).hasNext() && (rJMdRange = (RJMdRange)iterator.next()).getFromValue() instanceof RJMdDataPG) {
            RJMdDataPG rJMdDataPG = (RJMdDataPG)rJMdRange.getFromValue();
            RJMdDataPG rJMdDataPG2 = (RJMdDataPG)rJMdRange.getToValue();
            string = rJMdDataPG.getFB4() == 1 && rJMdDataPG2.getFB4() == 16 && rJMdDataPG.getPG() == 1 && rJMdDataPG2.getPG() == 32 ? INTERNAL : VIRTUAL;
        }
        return string;
    }

    class CollectParam {
        private ArgLDEVAbility argument = null;
        private ArrayList ldevParms = new ArrayList();

        CollectParam(Date date, Date date2) {
            this.argument = new ArgLDEVAbility(1, date, date2);
        }

        public void add(RJMdDataLDEV rJMdDataLDEV) {
            this.ldevParms.add(rJMdDataLDEV);
            this.argument.addLDEV(rJMdDataLDEV.getLDKC(), rJMdDataLDEV.getCU(), rJMdDataLDEV.getLDEV());
        }

        public int size() {
            return this.argument.size();
        }

        public ArgLDEVAbility getArgument() {
            return this.argument;
        }
    }
}

