/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import sanproject.common.Robj_interface_RJiLUPathIndex;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdContainer;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.data.RJMdDataHostGroup;
import sanproject.getmondat.data.RJMdDataLU;
import sanproject.getmondat.data.RJMdDataPort;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdUnitEntry;
import sanproject.getmondat.group.RJMdUnitParallelStream;
import sanproject.serverux.arg.monitor.ArgHURLU;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.HURgetUsageLUInf;
import sanproject.serverux.data.MonitorInfoCollection;
import sanproject.serverux.dataimpl.RJiLUPathIndex;

public class RJMdGroupURLU
extends RJMdGroupData {
    private static final String groupID = "URLU";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "URLU_dat";
    private static final String groupInfo = "URLU data";
    private RJMdUnitParallelStream stream = null;
    public static final int LIMIT_PARAMS_URLU = 512;
    public static final int KIND_TARGET = 1;
    private static final String EN_URLU_Read_Record = "URLU_Read_Record";
    private static final String EN_URLU_Read_Hit = "URLU_Read_Hit";
    private static final String EN_URLU_Write_Record = "URLU_Write_Record";
    private static final String EN_URLU_Write_Hit = "URLU_Write_Hit";
    private static final String EN_URLU_Read_Transfer = "URLU_Read_Transfer";
    private static final String EN_URLU_Write_Transfer = "URLU_Write_Transfer";
    private static final String EN_URLU_Initial_Copy_Hit = "URLU_Initial_Copy_Hit";
    private static final String EN_URLU_Initial_Copy_Transfer = "URLU_Initial_Copy_Transfer";
    private static final String[] entryNames = new String[]{"URLU_Read_Record", "URLU_Read_Hit", "URLU_Write_Record", "URLU_Write_Hit", "URLU_Read_Transfer", "URLU_Write_Transfer", "URLU_Initial_Copy_Hit", "URLU_Initial_Copy_Transfer"};

    public RJMdGroupURLU(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
        this.allowPSA = false;
    }

    public void init() throws IOException {
        String string = this.parameter.getDirectory();
        File file = new File(string);
        this.stream = new RJMdUnitParallelStream(groupName, file);
        this.stream.setCompress(this.parameter.isCompless());
    }

    protected boolean isGroupExists() {
        boolean bl = this.stream.exists();
        return bl;
    }

    public void deleteGroup() {
        this.stream.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup() throws RJMdRmiException, IOException {
        try {
            this.createGroupURLU();
        }
        finally {
            this.stream.close();
        }
    }

    private void createGroupURLU() throws RJMdRmiException, IOException {
        Object object;
        this.putInfomation("INF006", this.getGroupInfo());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < entryNames.length; ++i) {
            object = this.stream.createEntry(entryNames[i], this.getTimeRange());
            hashMap.put(entryNames[i], object);
        }
        RJMdTimeRange rJMdTimeRange = this.parameter.getShortRange();
        object = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
        ArrayList arrayList = this.controller.getPort(1);
        this.initProgress(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPort rJMdDataPort = (RJMdDataPort)iterator.next();
            int n = rJMdDataPort.getPortID();
            ArrayList arrayList2 = this.controller.getPortToHostGroup(n);
            Iterator iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                RJMdDataHostGroup rJMdDataHostGroup = (RJMdDataHostGroup)iterator2.next();
                RJMdContainer rJMdContainer = new RJMdContainer(rJMdDataPort, rJMdDataHostGroup);
                if (!this.parameter.containsRange(this.getGroupID(), rJMdContainer)) continue;
                int n2 = rJMdDataHostGroup.getHostGroupID();
                ArrayList arrayList3 = this.controller.getHostGroupToLU(n, n2);
                Iterator iterator3 = arrayList3.iterator();
                while (iterator3.hasNext()) {
                    RJMdDataLU rJMdDataLU = (RJMdDataLU)iterator3.next();
                    if (((CollectParam)object).size() >= 512) {
                        this.collect(hashMap, (CollectParam)object);
                        this.addProgress(((CollectParam)object).size());
                        object = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
                    }
                    ((CollectParam)object).add(rJMdDataPort, rJMdDataHostGroup, rJMdDataLU);
                }
            }
        }
        this.collect(hashMap, (CollectParam)object);
        this.closeProgress();
        this.putInfomation("INF007", this.getGroupInfo());
    }

    private void initProgress(ArrayList arrayList) throws RJMdRmiException {
        int n = 0;
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPort rJMdDataPort = (RJMdDataPort)iterator.next();
            int n3 = rJMdDataPort.getPortID();
            ArrayList arrayList2 = this.controller.getPortToHostGroup(n3);
            Iterator iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                RJMdDataHostGroup rJMdDataHostGroup = (RJMdDataHostGroup)iterator2.next();
                int n4 = rJMdDataHostGroup.getHostGroupID();
                ArrayList arrayList3 = this.controller.getHostGroupToLU(n3, n4);
                n2 += arrayList3.size();
                RJMdContainer rJMdContainer = new RJMdContainer(rJMdDataPort, rJMdDataHostGroup);
                if (!this.parameter.containsRange(this.getGroupID(), rJMdContainer)) continue;
                n += arrayList3.size();
            }
        }
        super.initProgress(n, n2);
    }

    public void collect(HashMap hashMap, CollectParam collectParam) throws RJMdRmiException, IOException {
        if (collectParam.size() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)collectParam.getArgument());
            for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                HURgetUsageLUInf hURgetUsageLUInf = (HURgetUsageLUInf)monitorInfoCollection.get(i);
                String string = collectParam.toColumnName(hURgetUsageLUInf.getPortID(), hURgetUsageLUInf.getHostgroupID(), hURgetUsageLUInf.getLUN());
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URLU_Read_Record), new RJMdColumn(string, hURgetUsageLUInf.getreadRecord()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URLU_Read_Hit), new RJMdColumn(string, hURgetUsageLUInf.getreadHit()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URLU_Write_Record), new RJMdColumn(string, hURgetUsageLUInf.getwriteRecord()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URLU_Write_Hit), new RJMdColumn(string, hURgetUsageLUInf.getwriteHit()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URLU_Read_Transfer), new RJMdColumn(string, hURgetUsageLUInf.getreadTransfer()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URLU_Write_Transfer), new RJMdColumn(string, hURgetUsageLUInf.getwriteTransfer()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URLU_Initial_Copy_Hit), new RJMdColumn(string, hURgetUsageLUInf.getinitHit()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URLU_Initial_Copy_Transfer), new RJMdColumn(string, hURgetUsageLUInf.getinitTransfer()));
            }
        }
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo() {
        return groupInfo;
    }

    public RJMdTimeRange getTimeRange() {
        return this.parameter.getShortRange();
    }

    public void analyzeOperand(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        char c = rJMdCmdParser.getKind();
        while ((rJMdRange = this.analyzePortHgRange(rJMdCmdParser)) != null) {
            RJMdDataControl.trace("\tPort.HostGroup =  " + rJMdRange);
            this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
            if (rJMdCmdParser.getKind() != ' ') break;
            rJMdCmdParser.nextToken();
        }
    }

    class CollectParam {
        private ArrayList lunList = new ArrayList();
        private HashMap columnNames = new HashMap();
        private Date fromTime;
        private Date toTime;

        CollectParam(Date date, Date date2) {
            this.fromTime = date;
            this.toTime = date2;
        }

        public void add(RJMdDataPort rJMdDataPort, RJMdDataHostGroup rJMdDataHostGroup, RJMdDataLU rJMdDataLU) {
            String string = this.toKeyString(rJMdDataPort.getPortID(), rJMdDataHostGroup.getHostGroupID());
            this.columnNames.put(string, RJMdGroupURLU.this.toPortHgString(rJMdDataPort, rJMdDataHostGroup));
            RJiLUPathIndex rJiLUPathIndex = new RJiLUPathIndex();
            rJiLUPathIndex.setSPort((short)rJMdDataPort.getPortID());
            rJiLUPathIndex.setSHostGroup((short)rJMdDataHostGroup.getHostGroupID());
            rJiLUPathIndex.setSLUN((short)rJMdDataLU.getLU());
            this.lunList.add(rJiLUPathIndex);
        }

        public int size() {
            return this.lunList.size();
        }

        private String toColumnName(int n, int n2, int n3) {
            String string = (String)this.columnNames.get(this.toKeyString(n, n2));
            String string2 = RJMdGroupURLU.this.toPortLunString(string, n3);
            return string2;
        }

        private String toKeyString(int n, int n2) {
            String string = String.valueOf(n) + "." + String.valueOf(n2);
            return string;
        }

        public ArgHURLU getArgument() {
            RJiLUPathIndex[] rJiLUPathIndexArray = this.lunList.toArray(new RJiLUPathIndex[0]);
            ArgHURLU argHURLU = new ArgHURLU(this.fromTime, this.toTime, (Robj_interface_RJiLUPathIndex[])rJiLUPathIndexArray);
            return argHURLU;
        }
    }
}

