/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com;

import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.Icon;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcPGElement;
import sanproject.client.com.RJcTreePanel;

public class RJcLdevElement
extends RJcElement
implements Serializable {
    private static final DecimalFormat cylFormat = new DecimalFormat("#,##0");
    private static final DecimalFormat gbFormat = new DecimalFormat("#0.00");
    protected int cu = -1;
    protected int ldev = -1;
    private String emulationType = null;
    private Long capacity = null;
    private Long lbacount = null;
    private int volFlg = 0;
    private RJcPGElement pg = null;
    private Integer clprNo = null;
    private String clprName = null;
    protected boolean external = false;
    private int slprNo = 0;

    public RJcLdevElement(int n, int n2) {
        this(n, n2, null);
    }

    public RJcLdevElement(int n, int n2, RJcTreePanel rJcTreePanel) {
        super(null, rJcTreePanel);
        this.cu = n;
        this.ldev = n2;
        this.setName(RJcLdevElement.toHexString(n, 2) + ":" + RJcLdevElement.toHexString(n2, 2));
    }

    public Icon getIcon(boolean bl) {
        Icon icon = null;
        return icon;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof RJcLdevElement && this.cu == ((RJcLdevElement)object).getCU() && this.ldev == ((RJcLdevElement)object).getLDev()) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        int n = this.cu << 8 | this.ldev;
        return n;
    }

    public int compareTo(Object object) {
        int n = 0;
        if (object instanceof RJcLdevElement && (n = this.cu - ((RJcLdevElement)object).getCU()) == 0) {
            n = this.ldev - ((RJcLdevElement)object).getLDev();
        }
        return n;
    }

    public int getCU() {
        return this.cu;
    }

    public int getCUIndex() {
        return this.getCU();
    }

    public int getLDev() {
        return this.ldev;
    }

    public int getLDevIndex() {
        return this.getLDev();
    }

    public String getEmulationType() {
        return this.emulationType;
    }

    public Long getCapacity() {
        return this.capacity;
    }

    public Long getLBACount() {
        return this.lbacount;
    }

    public int getVolumeFlg() {
        return this.volFlg;
    }

    public String toCapacityString() {
        String string = null;
        switch (this.volFlg) {
            case 1: 
            case 2: {
                string = cylFormat.format(this.capacity) + " " + RJcGuide.text("UNIT_CYL");
                break;
            }
            case 3: {
                string = RJComUty.ktoGSlong(this.capacity) + " " + RJcGuide.text("UNIT_GB");
                break;
            }
        }
        return string;
    }

    public boolean isExternal() {
        return this.external;
    }

    public RJcPGElement getPG() {
        return this.pg;
    }

    public Integer getClprNo() {
        return this.clprNo;
    }

    public String getClprName() {
        return this.clprName;
    }

    public int getSlprNo() {
        return this.slprNo;
    }
}

