/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import sanproject.client.com.RJcMenuAction;

public class RJcPopupMenu
extends JPopupMenu {
    private HashMap groupMap = null;
    private HashMap chgEnableList = null;
    private HashMap chgVisibleList = null;

    public RJcPopupMenu(String[] stringArray, ActionListener actionListener) {
        for (int i = 0; i < stringArray.length; ++i) {
            RJcMenuAction rJcMenuAction = new RJcMenuAction(stringArray[i]);
            rJcMenuAction.setActionListener(actionListener);
            this.addItem(rJcMenuAction);
        }
    }

    public RJcPopupMenu(RJcMenuAction[] rJcMenuActionArray) {
        this(rJcMenuActionArray, null);
    }

    public RJcPopupMenu(RJcMenuAction[] rJcMenuActionArray, ActionListener actionListener) {
        for (int i = 0; i < rJcMenuActionArray.length; ++i) {
            RJcMenuAction rJcMenuAction = rJcMenuActionArray[i];
            rJcMenuAction.setActionListener(actionListener);
            this.addItem(rJcMenuAction);
        }
    }

    protected void addItem(RJcMenuAction rJcMenuAction) {
        JComponent jComponent = this.createItem(rJcMenuAction);
        this.add(jComponent);
    }

    protected JComponent createItem(RJcMenuAction rJcMenuAction) {
        JComponent jComponent = null;
        RJcMenuAction[] rJcMenuActionArray = rJcMenuAction.getSubItems();
        if (rJcMenuActionArray == null) {
            if (rJcMenuAction.getType() == 1) {
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(rJcMenuAction);
                jRadioButtonMenuItem.addItemListener(rJcMenuAction);
                this.setButtonGroup(rJcMenuAction.getGroupID(), jRadioButtonMenuItem);
                jComponent = jRadioButtonMenuItem;
            } else if (rJcMenuAction.getType() == 2) {
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(rJcMenuAction);
                jCheckBoxMenuItem.addItemListener(rJcMenuAction);
                this.setButtonGroup(rJcMenuAction.getGroupID(), jCheckBoxMenuItem);
                jComponent = jCheckBoxMenuItem;
            } else {
                jComponent = rJcMenuAction.getType() == 0 ? new JMenuItem(rJcMenuAction) : new Lap_Separator(rJcMenuAction);
            }
        } else {
            jComponent = new JMenu(rJcMenuAction);
            for (int i = 0; i < rJcMenuActionArray.length; ++i) {
                RJcMenuAction rJcMenuAction2 = rJcMenuActionArray[i];
                JComponent jComponent2 = this.createItem(rJcMenuAction2);
                jComponent.add(jComponent2);
            }
        }
        return jComponent;
    }

    private void setButtonGroup(String string, AbstractButton abstractButton) {
        if (string != null) {
            ButtonGroup buttonGroup;
            if (this.groupMap == null) {
                this.groupMap = new HashMap(4);
            }
            if ((buttonGroup = (ButtonGroup)this.groupMap.get(string)) == null) {
                buttonGroup = new ButtonGroup();
                this.groupMap.put(string, buttonGroup);
            }
            buttonGroup.add(abstractButton);
        }
    }

    public void setSelected(String string, boolean bl) {
        JComponent jComponent = this.getMenuItem(string);
        if (jComponent != null && jComponent instanceof JMenuItem) {
            ((JMenuItem)jComponent).setSelected(bl);
        }
    }

    public void setEnabled(String string, boolean bl) {
        JComponent jComponent = this.getMenuItem(string);
        if (jComponent != null) {
            jComponent.setEnabled(bl);
        }
    }

    public void setVisible(String string, boolean bl) {
        JComponent jComponent = this.getMenuItem(string);
        if (jComponent != null) {
            jComponent.setVisible(bl);
        }
    }

    public JComponent getMenuItem(String string) {
        MenuElement[] menuElementArray = super.getSubElements();
        JComponent jComponent = this.getMenuItem(menuElementArray, string);
        return jComponent;
    }

    private JComponent getMenuItem(MenuElement[] menuElementArray, String string) {
        JComponent jComponent = null;
        for (int i = 0; i < menuElementArray.length; ++i) {
            String string2;
            MenuElement menuElement = menuElementArray[i];
            if (menuElement instanceof JMenuItem && (string2 = ((JMenuItem)menuElement).getActionCommand()) != null && string2.equals(string)) {
                jComponent = (JMenuItem)menuElement;
                break;
            }
            if (menuElement instanceof Lap_Separator && (string2 = ((Lap_Separator)menuElement).getActionCommand()) != null && string2.equals(string)) {
                jComponent = (Lap_Separator)menuElement;
                break;
            }
            if ((menuElement instanceof JMenu || menuElement instanceof JPopupMenu) && (jComponent = this.getMenuItem(menuElement.getSubElements(), string)) != null) break;
        }
        return jComponent;
    }

    public void show(Component component, int n, int n2) {
        if (this.visibleMenuCount() > 0) {
            super.show(component, n, n2);
        }
    }

    protected void firePopupMenuWillBecomeInvisible() {
        super.firePopupMenuWillBecomeInvisible();
        this.restoreMenuStatus();
    }

    public int visibleMenuCount() {
        MenuElement[] menuElementArray = super.getSubElements();
        return this.visibleMenuCount(menuElementArray);
    }

    public int visibleMenuCount(MenuElement[] menuElementArray) {
        int n = 0;
        this.chgEnableList = new HashMap();
        this.chgVisibleList = new HashMap();
        int n2 = 0;
        int n3 = 0;
        if (menuElementArray != null) {
            boolean bl;
            for (int i = 0; i < menuElementArray.length; ++i) {
                JMenu jMenu;
                JPopupMenu jPopupMenu;
                MenuElement[] menuElementArray2;
                if (menuElementArray[i] instanceof Lap_Separator) {
                    bl = ((Lap_Separator)menuElementArray[i]).isVisible();
                    if (!bl) continue;
                    if (n == 0) {
                        this.chgVisibleList.put(menuElementArray[i], new Boolean(bl));
                        ((Lap_Separator)menuElementArray[i]).setVisible(false);
                        continue;
                    }
                    if (n2 == n3 && n2 < menuElementArray.length) {
                        if (!(menuElementArray[n2] instanceof Lap_Separator)) continue;
                        this.chgVisibleList.put(menuElementArray[i], new Boolean(bl));
                        ((Lap_Separator)menuElementArray[i]).setVisible(false);
                        continue;
                    }
                    n2 = i;
                    n3 = i;
                    ++n;
                    continue;
                }
                if (!(menuElementArray[i] instanceof JMenuItem)) continue;
                if (((JMenuItem)menuElementArray[i]).isVisible()) {
                    n2 = i;
                    ++n;
                }
                if (!(menuElementArray[i] instanceof JMenu) || this.visibleMenuCount(menuElementArray2 = (jPopupMenu = (JPopupMenu)(jMenu = (JMenu)menuElementArray[i]).getSubElements()[0]).getSubElements()) > 0) continue;
                this.chgEnableList.put(menuElementArray[i], new Boolean(jMenu.isEnabled()));
                jMenu.setEnabled(false);
            }
            if (n2 == n3 && n2 < menuElementArray.length && menuElementArray[n2] instanceof Lap_Separator) {
                Lap_Separator lap_Separator = (Lap_Separator)menuElementArray[n2];
                if (this.chgVisibleList.get(lap_Separator) == null) {
                    bl = ((Lap_Separator)menuElementArray[n2]).isVisible();
                    this.chgVisibleList.put(menuElementArray[n2], new Boolean(bl));
                }
                lap_Separator.setVisible(false);
                --n;
            }
        }
        return n;
    }

    private void restoreMenuStatus() {
        boolean bl;
        Object k;
        Iterator iterator;
        if (this.chgVisibleList != null) {
            iterator = this.chgVisibleList.keySet().iterator();
            while (iterator.hasNext()) {
                k = iterator.next();
                bl = (Boolean)this.chgVisibleList.get(k);
                ((JComponent)k).setVisible(bl);
            }
            this.chgVisibleList = null;
        }
        if (this.chgEnableList != null) {
            iterator = this.chgEnableList.keySet().iterator();
            while (iterator.hasNext()) {
                k = iterator.next();
                bl = (Boolean)this.chgEnableList.get(k);
                ((JComponent)k).setEnabled(bl);
            }
            this.chgEnableList = null;
        }
    }

    public MenuElement[] getSubElements() {
        MenuElement[] menuElementArray = super.getSubElements();
        ArrayList<MenuElement> arrayList = new ArrayList<MenuElement>();
        for (int i = 0; i < menuElementArray.length; ++i) {
            if (menuElementArray[i] instanceof Lap_Separator) continue;
            arrayList.add(menuElementArray[i]);
        }
        MenuElement[] menuElementArray2 = arrayList.toArray(new MenuElement[0]);
        return menuElementArray2;
    }

    private class Lap_Separator
    extends JPopupMenu.Separator
    implements MenuElement {
        String name;

        public Lap_Separator() {
            this(null);
        }

        public Lap_Separator(RJcMenuAction rJcMenuAction) {
            this.name = (String)rJcMenuAction.getValue("ActionCommandKey");
        }

        public String getActionCommand() {
            return this.name;
        }

        public MenuElement[] getSubElements() {
            MenuElement[] menuElementArray = new MenuElement[]{};
            return menuElementArray;
        }

        public Component getComponent() {
            return this;
        }

        public void menuSelectionChanged(boolean bl) {
        }

        public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        }

        public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        }
    }
}

