/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.devicehealth;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComCellDat;
import sanproject.client.com.RJComDialog;
import sanproject.client.com.RJComEETableModel;
import sanproject.client.com.RJComTableSorterEx;
import sanproject.client.com.RJComTblCRenderer;
import sanproject.client.com.RJcCushionPanel;
import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcTabPanel;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataMsg;
import sanproject.client.data.RJDataWndInf;
import sanproject.client.devicehealth.RJDevHealthGetData;
import sanproject.client.devicehealth.RJDevHealthHistory;
import sanproject.client.devicehealth.RJDevHealthInf;
import sanproject.client.devicehealth.RJDevHealthInfoDialog;
import sanproject.client.status.BaseMenuItem;
import sanproject.client.status.DataControlFontModel;
import sanproject.client.status.FontManager;

public class RJDevHealthPanel
extends RJcTabPanel
implements ActionListener {
    RJDevHealthInf m_DeviceHealthInf;
    RJDevHealthGetData guid;
    static final int STAT_HIST_ITEM_NUM = 4;
    static final int SORT_STRING = 0;
    static final int SORT_INTEGER = 1;
    static final int ARRANGE_LEFT = 0;
    static final int ARRANGE_CENTER = 16;
    static final int ARRANGE_RIGHT = 32;
    static final int INTEGER_SIZE = 32;
    JTable m_StatHisList = new JTable();
    RJComTblCRenderer m_Tcellr = new RJComTblCRenderer();
    Integer m_DmyClrNo = new Integer(0);
    private static final int DRIVE_NUM_LEN = 2;
    private static final int CDEV_BIT_B = 8;
    private static final int CDEV_BIT_E = 11;
    private static final int RDEV_BIT_B = 0;
    private static final int RDEV_BIT_E = 7;
    private ArrayList selectedColumnArrayList;
    private ArrayList simDataArrayList;
    private int cnt;
    private JLabel mainTableRowsCountLabel;
    private static ArrayList selectedRowsArrayList;
    private static ArrayList selectedRefCodesArrayList;
    private static final int COLUMN_COUNT = 4;
    static /* synthetic */ Class class$java$awt$Frame;

    public RJDevHealthPanel() {
        try {
            this.InitFont();
            this.m_DeviceHealthInf = new RJDevHealthInf();
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initInstance();
    }

    void jbInit() throws Exception {
        RJDataControl rJDataControl = this.getDataCtl();
        this.guid = new RJDevHealthGetData(rJDataControl, 0);
        FontManager fontManager = FontManager.getInstance();
        Font font = fontManager.getViewLabelFont();
        this.mainTableRowsCountLabel = new JLabel();
        this.mainTableRowsCountLabel.setFont(font);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.mouseReleased(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() && SwingUtilities.isRightMouseButton(mouseEvent)) {
                    Point point = mouseEvent.getPoint();
                    int n = RJDevHealthPanel.this.m_StatHisList.getRowCount();
                    int n2 = RJDevHealthPanel.this.m_StatHisList.rowAtPoint(point);
                    if (n != -1 && n > n2) {
                        RJDevHealthPanel.this.requestFocus();
                        int n3 = RJDevHealthPanel.this.m_StatHisList.columnAtPoint(point);
                        boolean bl = RJDevHealthPanel.this.m_StatHisList.isCellSelected(n2, n3);
                        if (n2 != -1 && !bl) {
                            RJDevHealthPanel.this.m_StatHisList.setRowSelectionInterval(n2, n2);
                            RJDevHealthPanel.this.m_StatHisList.setColumnSelectionInterval(n3, n3);
                        }
                    }
                    RJDevHealthPanel.this.onHistoryTableClicked(mouseEvent);
                }
            }
        };
        Color color = this.guid.TBL_SEL_BG.getColor();
        Color color2 = this.guid.TBL_SEL_FG.getColor();
        this.m_StatHisList.setCellSelectionEnabled(false);
        this.m_StatHisList.setColumnSelectionAllowed(false);
        this.m_StatHisList.setRowSelectionAllowed(true);
        this.m_StatHisList.setSelectionBackground(color);
        this.m_StatHisList.setSelectionForeground(color2);
        this.m_StatHisList.setFont(font);
        this.m_StatHisList.addMouseListener(mouseAdapter);
        JTableHeader jTableHeader = this.m_StatHisList.getTableHeader();
        Dimension dimension = jTableHeader.getPreferredSize();
        dimension.height = 16;
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setPreferredSize(dimension);
        jTableHeader.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                RJDevHealthPanel.this.tblHeaderClicked(mouseEvent);
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = jMenuItem.getText();
        RJDataControl rJDataControl = this.getDataCtl();
        RJDataWndInf rJDataWndInf = RJDevHealthGetData.menuDetailGuidance;
        String string2 = rJDataWndInf.getGuidance();
        if (!string.equals(string2)) {
            throw new IllegalStateException(" \u5bfe\u5fdc\u30e1\u30cb\u30e5\u30fc\u304c\u5b58\u5728\u3057\u3066\u3044\u307e\u305b\u3093 ");
        }
        RJDevHealthPanel rJDevHealthPanel = this;
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = RJDevHealthPanel.class$("java.awt.Frame")) : class$java$awt$Frame, rJDevHealthPanel);
        this.historyDetail();
        RJDevHealthInfoDialog rJDevHealthInfoDialog = new RJDevHealthInfoDialog(frame, true);
        rJDevHealthInfoDialog.setGuidance(new RJDevHealthGetData(rJDataControl, 0));
        rJDevHealthInfoDialog.setResizable(false);
        rJDevHealthInfoDialog.setupCenterOfComponent(null);
        rJDevHealthInfoDialog.errorHistoryDetail(selectedRowsArrayList, selectedRefCodesArrayList);
    }

    private void onHistoryTableClicked(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        RJDataControl rJDataControl = this.getDataCtl();
        RJDataWndInf rJDataWndInf = RJDevHealthGetData.menuDetailGuidance;
        String string = rJDataWndInf.getGuidance();
        BaseMenuItem baseMenuItem = new BaseMenuItem(string);
        baseMenuItem.addActionListener(this);
        jPopupMenu.add(baseMenuItem);
        Component component = mouseEvent.getComponent();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        jPopupMenu.show(component, n, n2);
    }

    public void historyDetail() {
        int[] nArray = this.m_StatHisList.getSelectedRows();
        int n = nArray.length;
        System.out.println("    $####[SIM]  selectedRows   = " + n);
        if (n > 0) {
            ArrayList arrayList = this.m_DeviceHealthInf.m_DeviceHealthList;
            ArrayList arrayList2 = (ArrayList)arrayList.get(0);
            selectedRowsArrayList = new ArrayList();
            selectedRefCodesArrayList = new ArrayList();
            for (int i = 0; i < nArray.length; ++i) {
                Object object;
                Object object2;
                RJDevHealthHistory rJDevHealthHistory = (RJDevHealthHistory)arrayList2.get(nArray[i]);
                this.selectedColumnArrayList = new ArrayList();
                for (int j = 0; j < 4; ++j) {
                    object2 = this.m_StatHisList.getValueAt(nArray[i], j);
                    object = (RJComCellDat)object2;
                    String string = "  " + (String)((RJComCellDat)object).getUserObject();
                    this.selectedColumnArrayList.add(string);
                }
                selectedRowsArrayList.add(this.selectedColumnArrayList);
                Object object3 = this.m_StatHisList.getValueAt(nArray[i], 0);
                object2 = (RJComCellDat)object3;
                object = (String)((RJComCellDat)object2).getUserObject();
                this.simDataArrayList = new ArrayList();
                this.simDetail((String)object);
                selectedRefCodesArrayList.add(this.simDataArrayList);
            }
        }
    }

    public void simDetail(String string) {
        String[] stringArray = this.getDetail(string);
        this.simDataArrayList.add(stringArray[0]);
        this.simDataArrayList.add(stringArray[1]);
        this.simDataArrayList.add(stringArray[2]);
    }

    private String[] getDetail(String string) {
        String[] stringArray;
        String string2 = string.substring(0, 4);
        System.out.println("    $####[SIM]  refCodeKeyList = " + string2);
        RJDataControl rJDataControl = this.getDataCtl();
        RJDataWndInf rJDataWndInf = RJDevHealthGetData.simSectionGuidance;
        String string3 = rJDataWndInf.getGuidance();
        RJDataWndInf rJDataWndInf2 = RJDevHealthGetData.simDetailGuidance;
        String string4 = rJDataWndInf2.getGuidance();
        RJDataWndInf rJDataWndInf3 = RJDevHealthGetData.simLocationGuidance;
        String string5 = rJDataWndInf3.getGuidance();
        String string6 = string3 + string2;
        String string7 = string4 + string2;
        String string8 = string5 + string2;
        RJDataWndInf rJDataWndInf4 = RJDevHealthGetData.simHistoryGuidance;
        String string9 = rJDataWndInf4.getGuidance();
        RJDataWndInf rJDataWndInf5 = RJCom.getWinInf(rJDataControl, string9, string6);
        RJDataWndInf rJDataWndInf6 = RJCom.getWinInf(rJDataControl, string9, string7);
        RJDataWndInf rJDataWndInf7 = RJCom.getWinInf(rJDataControl, string9, string8);
        String string10 = null;
        String string11 = null;
        String string12 = null;
        if (rJDataWndInf5 == null && rJDataWndInf6 == null) {
            rJDataWndInf5 = this.maskRefCode(rJDataControl, string6);
            rJDataWndInf6 = this.maskRefCode(rJDataControl, string7);
        }
        if (rJDataWndInf5 != null && rJDataWndInf6 != null) {
            string10 = "  " + rJDataWndInf5.getGuidance();
            string11 = "  " + rJDataWndInf6.getGuidance();
        } else {
            stringArray = RJDevHealthGetData.lblNoErrorSectionGuidance;
            String string13 = stringArray.getGuidance();
            string10 = "  " + string13;
            RJDataWndInf rJDataWndInf8 = RJDevHealthGetData.lblNoErrorDetailGuidance;
            String string14 = rJDataWndInf8.getGuidance();
            string11 = "  " + string14;
        }
        if (rJDataWndInf7 == null) {
            rJDataWndInf7 = this.maskRefCode(rJDataControl, string8);
        }
        if (rJDataWndInf7 != null) {
            string12 = "  " + this.getLocation(rJDataWndInf7.getGuidance(), string);
        } else {
            stringArray = RJDevHealthGetData.lblNoErrorLocationGuidance;
            string12 = stringArray.getGuidance();
        }
        stringArray = new String[]{string10, string11, string12};
        return stringArray;
    }

    private RJDataWndInf maskRefCode(RJDataControl rJDataControl, String string) {
        RJDataWndInf rJDataWndInf = RJDevHealthGetData.maskXGuidance;
        String string2 = "";
        RJDataWndInf rJDataWndInf2 = null;
        RJDataWndInf rJDataWndInf3 = RJDevHealthGetData.simHistoryGuidance;
        String string3 = rJDataWndInf3.getGuidance();
        for (int i = 1; i <= 2; ++i) {
            string2 = string2.concat(rJDataWndInf.getGuidance());
            String string4 = string.substring(0, string.length() - i);
            String string5 = string4.concat(string2);
            RJDataWndInf rJDataWndInf4 = RJCom.getWinInf(rJDataControl, string3, string5);
            rJDataWndInf2 = rJDataWndInf4;
            if (rJDataWndInf2 != null) break;
        }
        return rJDataWndInf2;
    }

    private String getLocation(String string, String string2) {
        String string3 = "";
        String[] stringArray = new String[]{"602FFE", "602FFF", "623FFE"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.equals(stringArray[i])) continue;
            string3 = "-";
            return string3;
        }
        String[] stringArray2 = string.split("%", 3);
        block10: for (int i = 0; i < stringArray2.length; ++i) {
            switch (i) {
                case 0: {
                    string3 = string3.concat(stringArray2[0]);
                    continue block10;
                }
                case 1: {
                    continue block10;
                }
                case 2: {
                    int n;
                    int n2;
                    String string4 = "";
                    String string5 = stringArray2[1];
                    if (string5.equals("d")) {
                        try {
                            int n3 = Integer.parseInt(stringArray2[2]);
                            n2 = string2.length() - n3;
                            n = string2.length();
                            string4 = string2.substring(n2, n);
                            int n4 = Integer.parseInt(string4, 16);
                            string3 = string3.concat(String.valueOf(n4));
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                        continue block10;
                    }
                    if (string5.equals("x")) {
                        try {
                            int n5 = Integer.parseInt(stringArray2[2]);
                            n2 = string2.length() - n5;
                            n = string2.length();
                            string4 = string2.substring(n2, n);
                            String string6 = this.toDriveNumber(string4);
                            string3 = string3 + string6;
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                        continue block10;
                    }
                    if (!string5.equals("s")) continue block10;
                    string3 = string3.concat(stringArray2[2]);
                    continue block10;
                }
            }
        }
        return string3;
    }

    private String toDriveNumber(String string) {
        int n = Integer.parseInt(string, 16);
        int n2 = this.cutBit(n, 8, 11);
        int n3 = this.cutBit(n, 0, 7);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(RJcElement.toHexString(n2, 2));
        stringBuffer.append(RJDevHealthGetData.slashGuidance.getGuidance());
        stringBuffer.append(RJcElement.toHexString(n3, 2));
        return stringBuffer.toString();
    }

    private int cutBit(int n, int n2, int n3) {
        int n4 = -1;
        if (n2 < 0 || n3 < 0) {
            return n4;
        }
        if (n2 > n3 || n3 >= 32) {
            return n4;
        }
        int n5 = 32 - (n3 + 1);
        int n6 = n2;
        n4 = n;
        n4 <<= n5;
        return n4 >>>= n5 + n6;
    }

    public boolean showPanel(boolean bl) {
        boolean bl2 = false;
        this.setVisibleGLPRCmb(bl2);
        this.putLog("[Status]", "[showPanel]", "set GLPR CombBox showPanel( " + bl2 + " )", 1);
        RJDataControl rJDataControl = this.getDataCtl();
        RJDataWndInf rJDataWndInf = RJDevHealthGetData.caseDeviceGuidance;
        String string = rJDataWndInf.getGuidance();
        RJDataWndInf rJDataWndInf2 = RJDevHealthGetData.caseTabGuidance;
        String string2 = rJDataWndInf2.getGuidance();
        RJDataWndInf rJDataWndInf3 = RJDevHealthGetData.getDeviceHealthGuidance;
        String string3 = rJDataWndInf3.getGuidance();
        RJDataWndInf rJDataWndInf4 = RJDevHealthGetData.getTheDataFromDataContorolGuidance;
        String string4 = rJDataWndInf4.getGuidance();
        RJDataWndInf rJDataWndInf5 = RJDevHealthGetData.btnOKGuidance;
        String string5 = rJDataWndInf5.getGuidance();
        RJDataWndInf rJDataWndInf6 = RJDevHealthGetData.completeRetGuidance;
        String string6 = rJDataWndInf6.getGuidance();
        this.putLog(string, string2, string4, 1);
        boolean bl3 = this.m_DeviceHealthInf.getDeviceHealth(this.m_DataControl);
        if (!bl3) {
            this.putLog(string, string2, string3, 0);
            ArrayList arrayList = this.getDataCtl().getEndStatus();
            int n = (Integer)arrayList.get(0);
            int n2 = (Integer)arrayList.get(1);
            RJDataMsg rJDataMsg = this.getMsg(n, n2);
            Object[] objectArray = new Object[]{string5};
            RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
            int n3 = rJDataMsg.getErrorLevel();
            if (n3 >= 1 && n3 <= 4) {
                this.endRequest(n3);
            }
        } else {
            this.dspStatusHistory();
        }
        this.putLog(string, string2, string6 + bl3, 0);
        return bl3;
    }

    void dspStatusHistory() {
        Object object;
        ArrayList arrayList = (ArrayList)this.m_DeviceHealthInf.m_DeviceHealthList.get(0);
        this.cnt = arrayList.size();
        String string = String.valueOf(this.cnt);
        this.mainTableRowsCountLabel.setText(string);
        RJComEETableModel rJComEETableModel = new RJComEETableModel();
        Object[][] objectArray = new RJComCellDat[this.cnt][4];
        for (int i = 0; i < this.cnt; ++i) {
            object = (RJDevHealthHistory)arrayList.get(i);
            objectArray[i][0] = new RJComCellDat(((RJDevHealthHistory)object).m_RefCode, 0);
            objectArray[i][0].setSortAttr(0);
            objectArray[i][0].setAttr(16);
            objectArray[i][1] = new RJComCellDat(((RJDevHealthHistory)object).m_Errlevel, 0);
            ((RJComCellDat)objectArray[i][1]).setSortAttr(0);
            ((RJComCellDat)objectArray[i][1]).setAttr(16);
            objectArray[i][2] = new RJComCellDat(((RJDevHealthHistory)object).m_Statuse, 0);
            ((RJComCellDat)objectArray[i][2]).setSortAttr(0);
            ((RJComCellDat)objectArray[i][2]).setAttr(16);
            objectArray[i][3] = new RJComCellDat(((RJDevHealthHistory)object).m_Date + " " + ((RJDevHealthHistory)object).m_Time, 0);
            ((RJComCellDat)objectArray[i][3]).setSortAttr(0);
            ((RJComCellDat)objectArray[i][3]).setAttr(16);
        }
        Object[] objectArray2 = new Object[]{RJDevHealthGetData.REFCODE.getGuidance(), RJDevHealthGetData.ERRLEVEL.getGuidance(), RJDevHealthGetData.STATUS.getGuidance(), RJDevHealthGetData.DATE.getGuidance()};
        rJComEETableModel.setColumnCount(4);
        rJComEETableModel.setRowCount(this.cnt);
        rJComEETableModel.setDataVector(objectArray, objectArray2);
        this.m_StatHisList.setModel(rJComEETableModel);
        object = (DefaultTableColumnModel)this.m_StatHisList.getColumnModel();
        TableColumn[] tableColumnArray = new TableColumn[4];
        for (int i = 0; i < ((DefaultTableColumnModel)object).getColumnCount(); ++i) {
            tableColumnArray[i] = ((DefaultTableColumnModel)object).getColumn(i);
            tableColumnArray[i].setCellRenderer(this.m_Tcellr);
        }
        RJComTableSorterEx rJComTableSorterEx = new RJComTableSorterEx(this.m_StatHisList, true);
        rJComTableSorterEx.SortEx(3, 1);
    }

    public void rmvObj() {
        this.m_DeviceHealthInf = null;
        this.m_StatHisList = null;
    }

    void tblHeaderClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
        JTable jTable = jTableHeader.getTable();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n3 = tableColumnModel.getColumnIndexAtX(n);
        int n4 = jTable.convertColumnIndexToModel(n3);
        if (mouseEvent.getClickCount() == 1 && n4 != -1) {
            RJComTableSorterEx rJComTableSorterEx = new RJComTableSorterEx(jTable, true);
            rJComTableSorterEx.Sort(n4);
        }
    }

    private void InitFont() {
        RJDataControl rJDataControl = this.getDataCtl();
        DataControlFontModel dataControlFontModel = new DataControlFontModel(rJDataControl);
        FontManager fontManager = FontManager.getInstance();
        fontManager.setFontModel(dataControlFontModel);
    }

    protected JComponent createCenterComponent() {
        FontManager fontManager = FontManager.getInstance();
        Font font = fontManager.getViewLabelFont();
        Serializable serializable = new JScrollPane(this.m_StatHisList);
        Object object = RJDevHealthGetData.countTotalRowsGuidance.getGuidance();
        Object object2 = "    " + (String)object + "    ";
        Serializable serializable2 = new JLabel((String)object2);
        ((JComponent)serializable2).setFont(font);
        object = new Dimension(0, 26);
        object2 = BorderFactory.createLineBorder(Color.BLUE);
        BorderLayout borderLayout = new BorderLayout(4, 4);
        Serializable serializable3 = new JPanel();
        serializable3.setLayout(borderLayout);
        serializable3.setOpaque(true);
        serializable3.setBackground(Color.WHITE);
        serializable3.setBorder((Border)object2);
        serializable3.setPreferredSize((Dimension)object);
        serializable3.add((Component)serializable2, "West");
        serializable3.add(this.mainTableRowsCountLabel, "Center");
        serializable2 = this.guid.HISTPANEL2.getColor();
        int n = 1;
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel((JComponent)serializable, n);
        rJcCushionPanel.setOpaque(true);
        rJcCushionPanel.setBackground((Color)serializable2);
        rJcCushionPanel.add((Component)serializable3, "South");
        serializable = this.guid.BASEPANEL.getColor();
        serializable3 = new BorderLayout();
        serializable2 = new JPanel();
        ((Container)serializable2).setLayout((LayoutManager)((Object)serializable3));
        ((JComponent)serializable2).setOpaque(true);
        ((JComponent)serializable2).setBackground((Color)serializable);
        ((Container)serializable2).add(rJcCushionPanel, "Center");
        return serializable2;
    }

    protected JComponent createSouthComponent() {
        return null;
    }

    public String getWindowName() {
        String string = "Device Health";
        return string;
    }

    public Insets getInsets() {
        Insets insets = new Insets(8, 8, 8, 8);
        return insets;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

