/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.com;

import java.io.Serializable;
import javax.swing.Icon;
import sanproject.client.com.RJComDef;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcTreePanel;
import sanproject.client.data.RJDataLPRControler;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihElement;
import sanproject.client.monitor.com.RJHihIconTable;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.dataimpl.RJiLDEVInfoDetail3;

public class RJHihLdevElement
extends RJHihElement
implements Serializable {
    protected int ldkc = -1;
    protected int cu = -1;
    protected int ldev = -1;
    private byte volumeType;
    protected boolean external = false;
    protected boolean vVol = false;
    private String emulationType = null;
    private Integer clprNo = null;
    private String clprName = null;
    private boolean pVolInfo = false;

    public RJHihLdevElement(int n, int n2, int n3) {
        this(n, n2, n3, null, null);
    }

    public RJHihLdevElement(int n, int n2, int n3, RJHihDataSupplier rJHihDataSupplier, RJcTreePanel rJcTreePanel) {
        super(null, rJHihDataSupplier, rJcTreePanel);
        RJiLDEVIndex rJiLDEVIndex = new RJiLDEVIndex();
        rJiLDEVIndex.setLDEVIndex((short)n, (short)n2, (short)n3);
        this.initialize((Robj_interface_RJiLDEVIndex)rJiLDEVIndex);
    }

    public RJHihLdevElement(Robj_interface_RJiLDEVIndex robj_interface_RJiLDEVIndex, RJHihDataSupplier rJHihDataSupplier, RJcTreePanel rJcTreePanel) {
        super(null, rJHihDataSupplier, rJcTreePanel);
        this.initialize(robj_interface_RJiLDEVIndex);
    }

    protected void initialize(Robj_interface_RJiLDEVIndex robj_interface_RJiLDEVIndex) {
        this.ldkc = robj_interface_RJiLDEVIndex.getSLDKC();
        this.cu = robj_interface_RJiLDEVIndex.getSCU();
        this.ldev = robj_interface_RJiLDEVIndex.getSLDEV();
        this.setName(RJComUty.getLDEVDisplayName(this.ldkc, this.cu, this.ldev));
    }

    public void initDetail(RJiLDEVInfoDetail3 rJiLDEVInfoDetail3) {
        this.setName(RJHihLdevElement.getLDEVDisplayName(rJiLDEVInfoDetail3));
        this.volumeType = rJiLDEVInfoDetail3.getByVolumeType();
        this.external = rJiLDEVInfoDetail3.isExternalVolume();
        this.vVol = rJiLDEVInfoDetail3.isVvol();
        this.emulationType = this.supplier.changeEmulation(rJiLDEVInfoDetail3.getIEmulationType());
        this.clprNo = new Integer(rJiLDEVInfoDetail3.getSCLPR());
        RJDataLPRControler rJDataLPRControler = this.supplier.getLPRControler();
        this.clprName = rJDataLPRControler.getCLPRNoToName(rJiLDEVInfoDetail3.getSCLPR());
        this.pVolInfo = rJiLDEVInfoDetail3.isBPoolVol();
    }

    public Icon getIcon(boolean bl) {
        Icon icon = RJHihIconTable.getIcon(41);
        return icon;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof RJHihLdevElement && this.ldkc == ((RJHihLdevElement)object).getLDKC() && this.cu == ((RJHihLdevElement)object).getCU() && this.ldev == ((RJHihLdevElement)object).getLDEV()) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        int n = this.cu << 8 | this.ldev;
        return n;
    }

    public int compareTo(Object object) {
        int n = 0;
        if (object instanceof RJHihLdevElement && (n = this.ldkc - ((RJHihLdevElement)object).getLDKC()) == 0 && (n = this.cu - ((RJHihLdevElement)object).getCU()) == 0) {
            n = this.ldev - ((RJHihLdevElement)object).getLDEV();
        }
        return n;
    }

    public int getLDKC() {
        return this.ldkc;
    }

    public int getCU() {
        return this.cu;
    }

    public int getLDEV() {
        return this.ldev;
    }

    public Robj_interface_RJiLDEVIndex getLDEVIndex() {
        RJiLDEVIndex rJiLDEVIndex = new RJiLDEVIndex();
        rJiLDEVIndex.setLDEVIndex((short)this.ldkc, (short)this.cu, (short)this.ldev);
        return rJiLDEVIndex;
    }

    public Integer getClprNo() {
        return this.clprNo;
    }

    public String getClprName() {
        return this.clprName;
    }

    public String getEmulationType() {
        return this.emulationType;
    }

    public boolean isExternal() {
        return this.external;
    }

    public boolean isPoolVol() {
        return this.pVolInfo;
    }

    public static String getLDEVDisplayName(RJiLDEVInfoDetail3 rJiLDEVInfoDetail3) {
        StringBuffer stringBuffer = new StringBuffer(RJComUty.getLDEVDisplayName(rJiLDEVInfoDetail3.getSLDKC(), rJiLDEVInfoDetail3.getSCU(), rJiLDEVInfoDetail3.getSLDEV()));
        if (rJiLDEVInfoDetail3.isExternalVolume()) {
            stringBuffer.append(RJComDef.LDEV_MARK_E);
        }
        if (rJiLDEVInfoDetail3.isExternalMFVolume()) {
            stringBuffer.append(RJComDef.LDEV_MARK_M);
        }
        if (rJiLDEVInfoDetail3.isQSVvol()) {
            stringBuffer.append(RJComDef.LDEV_MARK_V);
        }
        if (rJiLDEVInfoDetail3.isAOUVvol()) {
            stringBuffer.append(RJComDef.LDEV_MARK_U);
        }
        return stringBuffer.toString();
    }
}

