/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.pool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComDialog;
import sanproject.client.com.RJComFuncPanel;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcAbsDataSupplier;
import sanproject.client.com.RJcException;
import sanproject.client.data.RJDataChange;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataException;
import sanproject.client.data.RJDataLDEVPart;
import sanproject.client.data.RJDataLPRControler;
import sanproject.client.data.RJDataMsg;
import sanproject.client.pool.RJPoolApplyData;
import sanproject.client.pool.RJPoolDef;
import sanproject.client.pool.RJPoolIconTable;
import sanproject.client.pool.RJPoolLdevElement;
import sanproject.common.Robj_interface_POOLIndex;
import sanproject.common.Robj_interface_POOLInfoDetail;
import sanproject.common.Robj_interface_POOLVolLDEV;
import sanproject.common.Robj_interface_POOLgetAOUVolRelationByPool;
import sanproject.common.Robj_interface_RJSetGettingParamLDEV;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiLDEVInfoDetail;
import sanproject.common.Robj_interface_RJiLDEVInfoDetailSUx;
import sanproject.common.Robj_interface_RJiLDKCIndex;
import sanproject.serverux.dataimpl.DCRgetAllDCRInfo;
import sanproject.serverux.dataimpl.DCRgetAllDCRInfo_IN;
import sanproject.serverux.dataimpl.DCRgetAllDCRInfo_OUT;
import sanproject.serverux.dataimpl.DKCgetLDEVSecurityInfo;
import sanproject.serverux.dataimpl.DKCgetLDEVSecurityInfo_IN;
import sanproject.serverux.dataimpl.DKCgetLDEVSecurityInfo_OUT;
import sanproject.serverux.dataimpl.LUNMgetLDEVStatus;
import sanproject.serverux.dataimpl.LUNMgetLDEVStatus_IN;
import sanproject.serverux.dataimpl.LUNMgetLDEVStatus_OUT;
import sanproject.serverux.dataimpl.POOLIndex;
import sanproject.serverux.dataimpl.POOLInfoDetail;
import sanproject.serverux.dataimpl.POOLgetAOUVolRelationByPool_IN;
import sanproject.serverux.dataimpl.POOLgetAOUVolRelationByPool_OUT;
import sanproject.serverux.dataimpl.POOLgetAllPoolInfo;
import sanproject.serverux.dataimpl.POOLgetAllPoolInfo_IN;
import sanproject.serverux.dataimpl.POOLgetAllPoolInfo_OUT;
import sanproject.serverux.dataimpl.POOLgetPoolVolInfo;
import sanproject.serverux.dataimpl.POOLgetPoolVolInfoEx_IN;
import sanproject.serverux.dataimpl.POOLgetPoolVolInfoEx_OUT;
import sanproject.serverux.dataimpl.QSAddPoolData;
import sanproject.serverux.dataimpl.QSPoolVolData;
import sanproject.serverux.dataimpl.QSRecoveryPoolData;
import sanproject.serverux.dataimpl.QSUpdatePoolData;
import sanproject.serverux.dataimpl.RJSetGettingParamLDEV;
import sanproject.serverux.dataimpl.SanRmiInputInterface;
import sanproject.serverux.dataimpl.SetAOUSIMComplete;
import sanproject.serverux.dataimpl.SetQSAddPool;
import sanproject.serverux.dataimpl.SetQSRecoveryPool;
import sanproject.serverux.dataimpl.SetQSSIMComplete;
import sanproject.serverux.dataimpl.SetQSUpdatePool;
import sanproject.serverux.dataimpl.SetQSVFSInitialize;

public class RJPoolDataSupplier
extends RJcAbsDataSupplier
implements RJPoolDef {
    RJDataLPRControler LPRControler = null;
    private Robj_interface_RJiLDKCIndex[] allLDKCIndex = null;
    private Robj_interface_RJiCUIndex[] allCUIndex = null;
    private Robj_interface_RJiLDEVIndex[] allLDEVIndex = null;
    private Robj_interface_RJiLDEVInfoDetail[] allPoolLDEV = null;
    private Robj_interface_RJiLDEVInfoDetail[] allFreeLDEV = null;
    private LUNMgetLDEVStatus[] allLDEVStatus = null;
    private DKCgetLDEVSecurityInfo[] allLDEVSecurity = null;
    private DCRgetAllDCRInfo[] allDCR = null;
    private POOLgetAllPoolInfo allPoolInfo = null;
    private POOLgetPoolVolInfo[] PoolVolInfo = null;
    private Robj_interface_POOLVolLDEV[] poolVolList = null;
    private RJPoolApplyData applyData = null;
    protected HashMap aouInfoMap = null;
    private boolean modify = false;
    public static final int POOL_KIND_NONE = 0;
    public static final int POOL_KIND_QS = 1;
    public static final int POOL_KIND_AOU = 2;
    public static final int LDEV_MIN_CAPA = 0x800000;
    private int messageShow = 0;
    public static final long HEADPOOLVOL_MASK = 0x80000000L;

    public RJPoolDataSupplier() {
        this(null);
    }

    public RJPoolDataSupplier(RJDataControl rJDataControl) {
        super(rJDataControl);
        RJPoolIconTable.setDataControl(rJDataControl);
    }

    public boolean isModify() {
        return this.modify;
    }

    public void setMode(boolean bl) {
        this.modify = bl && this.isPermission(2, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws RJcException {
        try {
            this.waitCursor(this.getParentPanel());
            this.applyData = new RJPoolApplyData(this);
            this.allDCR = this.getDCR();
            this.LPRControler = this.getLPRControler();
            this.allPoolInfo = this.getAllPoolInfo();
        }
        finally {
            this.defaultCursor(this.getParentPanel());
        }
    }

    protected RJDataLPRControler getLPRControler() throws RJcException {
        RJDataLPRControler rJDataLPRControler = null;
        this.waitControl();
        this.controller.getLPRControler();
        this.confirm("getLPRControler");
        rJDataLPRControler = this.controller.getLPRControlerData();
        return rJDataLPRControler;
    }

    protected Robj_interface_RJiLDKCIndex[] getLDKCIndex() {
        if (this.allLDKCIndex == null) {
            RJDataLDEVPart rJDataLDEVPart = this.controller.getLDEVPart();
            try {
                this.waitControl();
                this.allLDKCIndex = rJDataLDEVPart.getLDKCIndex();
                this.allLDKCIndex = (Robj_interface_RJiLDKCIndex[])this.allLDKCIndex.clone();
                Arrays.sort(this.allLDKCIndex);
            }
            catch (RJDataException rJDataException) {
                this.showErrorMessage(rJDataException.getErrPart(), rJDataException.getErrCode());
            }
        }
        return this.allLDKCIndex;
    }

    protected Robj_interface_RJiCUIndex[] getCUIndex(Robj_interface_RJiLDKCIndex robj_interface_RJiLDKCIndex) {
        System.out.println("getCUIndex LDKC = " + robj_interface_RJiLDKCIndex.getSLDKC());
        RJDataLDEVPart rJDataLDEVPart = this.controller.getLDEVPart();
        try {
            this.waitControl();
            this.allCUIndex = rJDataLDEVPart.getCUIndex(robj_interface_RJiLDKCIndex);
            this.allCUIndex = (Robj_interface_RJiCUIndex[])this.allCUIndex.clone();
            Arrays.sort(this.allCUIndex);
        }
        catch (RJDataException rJDataException) {
            this.showErrorMessage(rJDataException.getErrPart(), rJDataException.getErrCode());
        }
        return this.allCUIndex;
    }

    protected Robj_interface_RJiLDEVIndex[] getLDEVIndex(Robj_interface_RJiCUIndex robj_interface_RJiCUIndex) {
        RJDataLDEVPart rJDataLDEVPart = this.controller.getLDEVPart();
        try {
            this.waitControl();
            this.allLDEVIndex = rJDataLDEVPart.getLDEVIndex(robj_interface_RJiCUIndex);
            this.allLDEVIndex = (Robj_interface_RJiLDEVIndex[])this.allLDEVIndex.clone();
            Arrays.sort(this.allLDEVIndex);
        }
        catch (RJDataException rJDataException) {
            this.showErrorMessage(rJDataException.getErrPart(), rJDataException.getErrCode());
        }
        return this.allLDEVIndex;
    }

    protected Robj_interface_RJiLDEVInfoDetail[] getLDEVDetail(Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray, Robj_interface_RJSetGettingParamLDEV robj_interface_RJSetGettingParamLDEV) {
        Robj_interface_RJiLDEVInfoDetailSUx[] robj_interface_RJiLDEVInfoDetailSUxArray = null;
        RJDataLDEVPart rJDataLDEVPart = this.controller.getLDEVPart();
        try {
            this.waitControl();
            robj_interface_RJiLDEVInfoDetailSUxArray = rJDataLDEVPart.getLDEVInfoDetail(robj_interface_RJiLDEVIndexArray, robj_interface_RJSetGettingParamLDEV);
        }
        catch (RJDataException rJDataException) {
            this.showErrorMessage(rJDataException.getErrPart(), rJDataException.getErrCode());
        }
        this.getLDEVStatusInfo(robj_interface_RJiLDEVIndexArray);
        return robj_interface_RJiLDEVInfoDetailSUxArray;
    }

    public ArrayList getFreeLDEV(int n, Robj_interface_RJiCUIndex robj_interface_RJiCUIndex) {
        ArrayList<Robj_interface_RJiLDEVInfoDetail> arrayList = new ArrayList<Robj_interface_RJiLDEVInfoDetail>();
        if (this.allFreeLDEV == null || this.allFreeLDEV != null && !this.allFreeLDEV[0].equals(robj_interface_RJiCUIndex)) {
            Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = this.getLDEVIndex(robj_interface_RJiCUIndex);
            RJSetGettingParamLDEV rJSetGettingParamLDEV = new RJSetGettingParamLDEV();
            rJSetGettingParamLDEV.setBAll(true);
            this.allFreeLDEV = this.getLDEVDetail(robj_interface_RJiLDEVIndexArray, (Robj_interface_RJSetGettingParamLDEV)rJSetGettingParamLDEV);
            this.allFreeLDEV = (Robj_interface_RJiLDEVInfoDetail[])this.allFreeLDEV.clone();
            Arrays.sort(this.allFreeLDEV);
        }
        for (int i = 0; i < this.allFreeLDEV.length; ++i) {
            if (!this.isFree(n, this.allFreeLDEV[i])) continue;
            arrayList.add(this.allFreeLDEV[i]);
        }
        return arrayList;
    }

    public ArrayList getPoolLDEV(POOLIndex pOOLIndex) {
        ArrayList<Robj_interface_RJiLDEVInfoDetail> arrayList = new ArrayList<Robj_interface_RJiLDEVInfoDetail>();
        POOLgetPoolVolInfo pOOLgetPoolVolInfo = this.getPoolVolInfo(pOOLIndex);
        this.poolVolList = pOOLgetPoolVolInfo.getObjPoolVolLDEV();
        if (this.poolVolList != null) {
            RJSetGettingParamLDEV rJSetGettingParamLDEV = new RJSetGettingParamLDEV();
            rJSetGettingParamLDEV.setBBasic(true);
            rJSetGettingParamLDEV.setBSize(true);
            rJSetGettingParamLDEV.setBVDEVindex(true);
            rJSetGettingParamLDEV.setBExternal(true);
            this.allPoolLDEV = this.getLDEVDetail((Robj_interface_RJiLDEVIndex[])this.poolVolList, (Robj_interface_RJSetGettingParamLDEV)rJSetGettingParamLDEV);
            if (this.allPoolLDEV != null) {
                this.allPoolLDEV = (Robj_interface_RJiLDEVInfoDetail[])this.allPoolLDEV.clone();
                Arrays.sort(this.allPoolLDEV);
                for (int i = 0; i < this.allPoolLDEV.length; ++i) {
                    arrayList.add(this.allPoolLDEV[i]);
                }
            }
        }
        return arrayList;
    }

    public boolean isTopPoolVOL(Robj_interface_RJiLDEVIndex robj_interface_RJiLDEVIndex) {
        boolean bl = false;
        for (int i = 0; i < this.poolVolList.length; ++i) {
            if (!this.poolVolList[i].equals(robj_interface_RJiLDEVIndex)) continue;
            bl = this.isHeadPoolVol(this.poolVolList[i]);
            break;
        }
        return bl;
    }

    public boolean isHeadPoolVol(Robj_interface_POOLVolLDEV robj_interface_POOLVolLDEV) {
        boolean bl = false;
        if ((robj_interface_POOLVolLDEV.getLLDEVStatus() & 0x80000000L) == 0x80000000L) {
            bl = true;
        }
        return bl;
    }

    protected LUNMgetLDEVStatus[] getLDEVStatusInfo(Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray) {
        LUNMgetLDEVStatus_OUT lUNMgetLDEVStatus_OUT = null;
        try {
            LUNMgetLDEVStatus_IN lUNMgetLDEVStatus_IN = new LUNMgetLDEVStatus_IN(robj_interface_RJiLDEVIndexArray);
            this.waitControl();
            this.controller.getDataInfEx((SanRmiInputInterface)lUNMgetLDEVStatus_IN);
            this.confirm("getLDEVStatusInfo");
            lUNMgetLDEVStatus_OUT = (LUNMgetLDEVStatus_OUT)this.controller.getDataInfExData();
        }
        catch (RJcException rJcException) {
            // empty catch block
        }
        this.allLDEVStatus = (LUNMgetLDEVStatus[])lUNMgetLDEVStatus_OUT.getDataObject().clone();
        Arrays.sort(this.allLDEVStatus);
        return this.allLDEVStatus;
    }

    protected DKCgetLDEVSecurityInfo[] getLDEVSecurityInfo(Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray) {
        DKCgetLDEVSecurityInfo_OUT dKCgetLDEVSecurityInfo_OUT = null;
        DKCgetLDEVSecurityInfo_IN dKCgetLDEVSecurityInfo_IN = new DKCgetLDEVSecurityInfo_IN(robj_interface_RJiLDEVIndexArray);
        try {
            this.waitControl();
            this.controller.getDataInfEx((SanRmiInputInterface)dKCgetLDEVSecurityInfo_IN);
            this.confirm("getLDEVSecurityInfo");
            dKCgetLDEVSecurityInfo_OUT = (DKCgetLDEVSecurityInfo_OUT)this.controller.getDataInfExData();
        }
        catch (RJcException rJcException) {
            // empty catch block
        }
        this.allLDEVSecurity = (DKCgetLDEVSecurityInfo[])dKCgetLDEVSecurityInfo_OUT.getDataObject().clone();
        Arrays.sort(this.allLDEVSecurity);
        return this.allLDEVSecurity;
    }

    protected DCRgetAllDCRInfo[] getDCR() throws RJcException {
        DCRgetAllDCRInfo_OUT dCRgetAllDCRInfo_OUT = null;
        DCRgetAllDCRInfo_IN dCRgetAllDCRInfo_IN = new DCRgetAllDCRInfo_IN();
        try {
            this.waitControl();
            this.controller.getDataInfEx((SanRmiInputInterface)dCRgetAllDCRInfo_IN);
            this.confirm("getDCR");
            dCRgetAllDCRInfo_OUT = (DCRgetAllDCRInfo_OUT)this.controller.getDataInfExData();
        }
        catch (RJcException rJcException) {
            // empty catch block
        }
        this.allDCR = (DCRgetAllDCRInfo[])dCRgetAllDCRInfo_OUT.getDataObject().clone();
        Arrays.sort(this.allDCR);
        return this.allDCR;
    }

    protected POOLgetAllPoolInfo getAllPoolInfo() throws RJcException {
        POOLgetAllPoolInfo pOOLgetAllPoolInfo = null;
        POOLgetAllPoolInfo_IN pOOLgetAllPoolInfo_IN = new POOLgetAllPoolInfo_IN();
        this.waitControl();
        this.controller.getDataInfEx((SanRmiInputInterface)pOOLgetAllPoolInfo_IN);
        this.confirm("getAllPoolInfo");
        POOLgetAllPoolInfo_OUT pOOLgetAllPoolInfo_OUT = (POOLgetAllPoolInfo_OUT)this.controller.getDataInfExData();
        pOOLgetAllPoolInfo = pOOLgetAllPoolInfo_OUT.getDataObject();
        return pOOLgetAllPoolInfo;
    }

    public Robj_interface_POOLgetAOUVolRelationByPool[] getAOURelation(Robj_interface_POOLIndex[] robj_interface_POOLIndexArray) {
        Robj_interface_POOLgetAOUVolRelationByPool[] robj_interface_POOLgetAOUVolRelationByPoolArray = null;
        try {
            POOLgetAOUVolRelationByPool_OUT pOOLgetAOUVolRelationByPool_OUT = null;
            POOLgetAOUVolRelationByPool_IN pOOLgetAOUVolRelationByPool_IN = new POOLgetAOUVolRelationByPool_IN(robj_interface_POOLIndexArray);
            this.waitControl();
            this.controller.getDataInfEx((SanRmiInputInterface)pOOLgetAOUVolRelationByPool_IN);
            this.confirm("getAOUVolRelationByPool");
            pOOLgetAOUVolRelationByPool_OUT = (POOLgetAOUVolRelationByPool_OUT)this.controller.getDataInfExData();
            robj_interface_POOLgetAOUVolRelationByPoolArray = (Robj_interface_POOLgetAOUVolRelationByPool[])pOOLgetAOUVolRelationByPool_OUT.getDataObject().clone();
        }
        catch (RJcException rJcException) {
            // empty catch block
        }
        return robj_interface_POOLgetAOUVolRelationByPoolArray;
    }

    protected POOLgetPoolVolInfo getPoolVolInfo(POOLIndex pOOLIndex) {
        POOLgetPoolVolInfoEx_OUT pOOLgetPoolVolInfoEx_OUT = null;
        POOLIndex[] pOOLIndexArray = new POOLIndex[]{pOOLIndex};
        try {
            POOLgetPoolVolInfoEx_IN pOOLgetPoolVolInfoEx_IN = new POOLgetPoolVolInfoEx_IN((Robj_interface_POOLIndex[])pOOLIndexArray);
            this.waitControl();
            this.controller.getDataInfEx((SanRmiInputInterface)pOOLgetPoolVolInfoEx_IN);
            this.confirm("getPoolVolInfo");
            pOOLgetPoolVolInfoEx_OUT = (POOLgetPoolVolInfoEx_OUT)this.controller.getDataInfExData();
        }
        catch (RJcException rJcException) {
            // empty catch block
        }
        this.PoolVolInfo = (POOLgetPoolVolInfo[])pOOLgetPoolVolInfoEx_OUT.getDataObject().clone();
        return this.PoolVolInfo[0];
    }

    public Robj_interface_POOLgetAOUVolRelationByPool getRelation(POOLIndex pOOLIndex) {
        Robj_interface_POOLgetAOUVolRelationByPool robj_interface_POOLgetAOUVolRelationByPool = null;
        if (this.aouInfoMap != null) {
            Integer n = new Integer(pOOLIndex.getSPoolId());
            robj_interface_POOLgetAOUVolRelationByPool = (Robj_interface_POOLgetAOUVolRelationByPool)this.aouInfoMap.get(n);
        } else {
            POOLIndex[] pOOLIndexArray = new POOLIndex[]{pOOLIndex};
            Robj_interface_POOLgetAOUVolRelationByPool[] robj_interface_POOLgetAOUVolRelationByPoolArray = this.getAOURelation((Robj_interface_POOLIndex[])pOOLIndexArray);
            robj_interface_POOLgetAOUVolRelationByPool = robj_interface_POOLgetAOUVolRelationByPoolArray[0];
        }
        return robj_interface_POOLgetAOUVolRelationByPool;
    }

    public ArrayList getPoolList(int n) {
        ArrayList<POOLInfoDetail> arrayList = new ArrayList<POOLInfoDetail>();
        POOLInfoDetail[] pOOLInfoDetailArray = null;
        if (this.allPoolInfo != null) {
            pOOLInfoDetailArray = (Robj_interface_POOLInfoDetail[])this.allPoolInfo.getObjPoolInfo().clone();
            Arrays.sort(pOOLInfoDetailArray, new PoolComparetor());
        } else {
            pOOLInfoDetailArray = new POOLInfoDetail[]{};
        }
        for (int i = 0; i < pOOLInfoDetailArray.length; ++i) {
            if (pOOLInfoDetailArray[i].getByPoolKind() != n) continue;
            arrayList.add(pOOLInfoDetailArray[i]);
        }
        if (n == 2 && !arrayList.isEmpty()) {
            POOLIndex[] pOOLIndexArray = arrayList.toArray(new POOLIndex[0]);
            Robj_interface_POOLgetAOUVolRelationByPool[] robj_interface_POOLgetAOUVolRelationByPoolArray = null;
            robj_interface_POOLgetAOUVolRelationByPoolArray = this.getAOURelation((Robj_interface_POOLIndex[])pOOLIndexArray);
            this.aouInfoMap = new HashMap(16, 4.0f);
            for (int i = 0; i < robj_interface_POOLgetAOUVolRelationByPoolArray.length; ++i) {
                Integer n2 = new Integer(pOOLIndexArray[i].getSPoolId());
                this.aouInfoMap.put(n2, robj_interface_POOLgetAOUVolRelationByPoolArray[i]);
            }
        }
        return arrayList;
    }

    public boolean isRelation(POOLIndex pOOLIndex) {
        Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray;
        boolean bl = false;
        Robj_interface_POOLgetAOUVolRelationByPool robj_interface_POOLgetAOUVolRelationByPool = this.getRelation(pOOLIndex);
        if (robj_interface_POOLgetAOUVolRelationByPool != null && (robj_interface_RJiLDEVIndexArray = robj_interface_POOLgetAOUVolRelationByPool.getAouVol()).length != 0) {
            bl = true;
        }
        return bl;
    }

    private boolean isFree(int n, Robj_interface_RJiLDEVInfoDetail robj_interface_RJiLDEVInfoDetail) {
        boolean bl = false;
        if (!(robj_interface_RJiLDEVInfoDetail.getIEmulationType() != 625 || robj_interface_RJiLDEVInfoDetail.isBPoolVol() || robj_interface_RJiLDEVInfoDetail.getSLUPathNumber() != 0 || robj_interface_RJiLDEVInfoDetail.isVvol() || this.getLDEVStatus(robj_interface_RJiLDEVInfoDetail) != 1 && this.getLDEVStatus(robj_interface_RJiLDEVInfoDetail) != 9 || this.isLDEVSecurity(robj_interface_RJiLDEVInfoDetail) || robj_interface_RJiLDEVInfoDetail.isBLUPathCmdDev() || (byte)(robj_interface_RJiLDEVInfoDetail.getByLDEVGuardStatus() & 0xFF) != -128 || robj_interface_RJiLDEVInfoDetail.isBHIHSMReserve() || robj_interface_RJiLDEVInfoDetail.getSLUSEElmCount() != 1 || this.isDCR(robj_interface_RJiLDEVInfoDetail) || robj_interface_RJiLDEVInfoDetail.isBJNLVolume() || robj_interface_RJiLDEVInfoDetail.isBSystemDisk() || robj_interface_RJiLDEVInfoDetail.getLLDEVLBASize() / 2L < 0x800000L)) {
            bl = true;
        }
        return bl;
    }

    private int getLDEVStatus(Robj_interface_RJiLDEVInfoDetail robj_interface_RJiLDEVInfoDetail) {
        int n = 0;
        if (this.allLDEVStatus != null) {
            for (int i = 0; i < this.allLDEVStatus.length; ++i) {
                LUNMgetLDEVStatus lUNMgetLDEVStatus = this.allLDEVStatus[i];
                if (!lUNMgetLDEVStatus.equals((Object)robj_interface_RJiLDEVInfoDetail)) continue;
                n = lUNMgetLDEVStatus.getByLDEVStatus();
                break;
            }
        }
        return n;
    }

    private boolean isLDEVSecurity(Robj_interface_RJiLDEVInfoDetail robj_interface_RJiLDEVInfoDetail) {
        boolean bl = false;
        if (this.allLDEVSecurity != null) {
            for (int i = 0; i < this.allLDEVSecurity.length; ++i) {
                DKCgetLDEVSecurityInfo dKCgetLDEVSecurityInfo = this.allLDEVSecurity[i];
                if (!dKCgetLDEVSecurityInfo.equals((Object)robj_interface_RJiLDEVInfoDetail)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private boolean isDCR(Robj_interface_RJiLDEVInfoDetail robj_interface_RJiLDEVInfoDetail) {
        boolean bl = false;
        if (this.allDCR != null) {
            for (int i = 0; i < this.allDCR.length; ++i) {
                DCRgetAllDCRInfo dCRgetAllDCRInfo = this.allDCR[i];
                if (!dCRgetAllDCRInfo.equals((Object)robj_interface_RJiLDEVInfoDetail)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public RJDataLPRControler getLPRCtr() {
        return this.LPRControler;
    }

    private void sortLdev(ArrayList arrayList) {
        Object[] objectArray = arrayList.toArray();
        Arrays.sort(objectArray, new LdevComparetor());
        arrayList.clear();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
    }

    public void sort(ArrayList arrayList) {
        Object[] objectArray = arrayList.toArray();
        Arrays.sort(objectArray);
        arrayList.clear();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
    }

    public POOLgetPoolVolInfo getPoolVolInfo() {
        return this.PoolVolInfo[0];
    }

    public void setObject(Object object) {
        this.putLogApplyObject(object);
        super.setObject(object);
    }

    private void putLogApplyObject(Object object) {
        int n;
        QSRecoveryPoolData[] qSRecoveryPoolDataArray;
        SetQSAddPool setQSAddPool;
        if (object instanceof SetQSAddPool) {
            setQSAddPool = (SetQSAddPool)object;
            this.putLog("[Pool]", "[ApplyArg]", "SetQSAddPool cmd=" + setQSAddPool.lComannd + "(0x" + this.toHexString((int)setQSAddPool.lComannd, 4) + ")");
            qSRecoveryPoolDataArray = (QSAddPoolData[])setQSAddPool.getObjPoolData();
            for (n = 0; n < qSRecoveryPoolDataArray.length; ++n) {
                this.putLog("[Pool]", "[ApplyArg]", "    nPoolId=" + qSRecoveryPoolDataArray[n].sPoolId + ", nPoolFixThreshold=" + qSRecoveryPoolDataArray[n].sPoolFixThreshold + ", nPoolThreshold=" + qSRecoveryPoolDataArray[n].sPoolThreshold + ", nPoolGrainSize=" + qSRecoveryPoolDataArray[n].sPoolGrainSize + ", nPoolKind=" + qSRecoveryPoolDataArray[n].byPoolKind);
                String string = "";
                QSPoolVolData[] qSPoolVolDataArray = (QSPoolVolData[])qSRecoveryPoolDataArray[n].getObjPoolVolData();
                for (int i = 0; i < qSPoolVolDataArray.length; ++i) {
                    if (i % 8 == 0 & i != 0) {
                        this.putLog("[Pool]", "[ApplyArg]", "        " + string);
                        string = "";
                    }
                    RJPoolLdevElement rJPoolLdevElement = new RJPoolLdevElement(qSPoolVolDataArray[i].sLDKC, qSPoolVolDataArray[i].sCU, qSPoolVolDataArray[i].sLDEV);
                    string = string + "[" + rJPoolLdevElement.toString() + "]";
                }
                this.putLog("[Pool]", "[ApplyArg]", "        " + string);
            }
        }
        if (object instanceof SetQSUpdatePool) {
            setQSAddPool = (SetQSUpdatePool)object;
            this.putLog("[Pool]", "[ApplyArg]", "SetQSUpdatePool cmd=" + setQSAddPool.lComannd + "(0x" + this.toHexString((int)setQSAddPool.lComannd, 4) + ")");
            qSRecoveryPoolDataArray = (QSUpdatePoolData[])setQSAddPool.getObjPoolData();
            for (n = 0; n < qSRecoveryPoolDataArray.length; ++n) {
                this.putLog("[Pool]", "[ApplyArg]", "    nPoolId=" + qSRecoveryPoolDataArray[n].sPoolId + ", nPoolThreshold=" + qSRecoveryPoolDataArray[n].sPoolThreshold + ", nPoolGrainSize=" + qSRecoveryPoolDataArray[n].sPoolGrainSize + ", nPoolKind=" + qSRecoveryPoolDataArray[n].byPoolKind);
            }
        }
        if (object instanceof SetQSRecoveryPool) {
            setQSAddPool = (SetQSRecoveryPool)object;
            this.putLog("[Pool]", "[ApplyArg]", "SetQSRecoveryPool ");
            qSRecoveryPoolDataArray = (QSRecoveryPoolData[])setQSAddPool.getObjPoolData();
            for (n = 0; n < qSRecoveryPoolDataArray.length; ++n) {
                this.putLog("[Pool]", "[ApplyArg]", "    nPoolId=" + qSRecoveryPoolDataArray[n].sPoolId);
            }
        }
        if (object instanceof SetQSVFSInitialize) {
            this.putLog("[Pool]", "[ApplyArg]", "SetQSVFSInitialize ");
        }
        if (object instanceof SetQSSIMComplete) {
            this.putLog("[Pool]", "[ApplyArg]", "SetQSSIMComplete ");
        }
        if (object instanceof SetAOUSIMComplete) {
            this.putLog("[Pool]", "[ApplyArg]", "SetAOUSIMComplete ");
        }
    }

    public RJPoolApplyData getApplyData() {
        return this.applyData;
    }

    public String toHexString2(long l, int n) {
        String string = "0000000" + Long.toHexString(l).toUpperCase();
        return string.substring(string.length() - n);
    }

    public String chgEmulation(int n) {
        RJDataChange rJDataChange = this.controller.getChangeTbl();
        String string = rJDataChange.getEmulationTypeName(n);
        return string;
    }

    public String chgRAIDLevel(int n) {
        RJDataChange rJDataChange = this.controller.getChangeTbl();
        String string = rJDataChange.getRAIDLevelName(n);
        return string;
    }

    public boolean isPPCheck(int n) {
        boolean bl = false;
        if (n == 1) {
            bl = this.isPP(RJPoolDef.PP_QUICKSHADOW) || this.getVenderID() == 99;
        } else if (n == 2) {
            bl = this.isPP(RJPoolDef.PP_AOU) || this.getVenderID() == 99;
        }
        return bl;
    }

    public RJDataMsg getMessage(int n, int n2) {
        RJDataMsg rJDataMsg = RJCom.getMsg(this.controller, n, n2);
        return rJDataMsg;
    }

    protected void showErrorMessage(int n, int n2) {
        RJDataMsg rJDataMsg = this.getMessage(n, n2);
        Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
        ++this.messageShow;
        RJComDialog.show(this.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
        --this.messageShow;
        int n3 = this.getErrorLevel(rJDataMsg);
        RJComFuncPanel rJComFuncPanel = (RJComFuncPanel)this.getParentPanel();
        rJComFuncPanel.endRequest(n3);
    }

    class LdevComparetor
    implements Comparator {
        LdevComparetor() {
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            n = ((Robj_interface_RJiLDEVIndex)object).hashCode() - ((Robj_interface_RJiLDEVIndex)object2).hashCode();
            return n;
        }

        public boolean equals(Object object) {
            return true;
        }
    }

    class PoolComparetor
    implements Comparator {
        PoolComparetor() {
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            short s = ((POOLIndex)object).sPoolId;
            short s2 = ((POOLIndex)object2).sPoolId;
            n = s - s2;
            return n;
        }

        public boolean equals(Object object) {
            return true;
        }
    }
}

