/*
 * Decompiled with CFR 0.152.
 */
package spfc;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.UIManager;
import spfc.SPFC_UploadPanel;
import spfc.ctrl.SPFC_BaseCtrl;
import spfc.ctrl.SPFC_LookAndFeelManager;
import spfc.data.SPFC_ApplicationParameters;
import spfc.data.SPFC_CSVLineData;

public class SPFC_ApplicationCtrl
extends SPFC_BaseCtrl
implements WindowListener {
    private static final String SET_SERVER_LIST = "SERVER_LIST";
    private static final String SET_FRAME_POS = "FRAME_POS";
    public static final String APPPARM_DEBUG = "--debug";
    public static final String APPPARM_TITLE = "--title";
    public static final String APPPARM_REMOVE = "--remove";
    public static final String APPPARM_ADDRESS = "--address";
    public static final String APPPARM_PORT = "--port";
    public static final String APPPARM_USER = "--user";
    public static final String APPPARM_PASSWORD = "--password";
    public static final String APPPARM_DIRECTORY = "--directory";
    public static final String APPPARM_PASSIVE = "--passive";
    public static final String APPPARM_ACTIVE = "--active";
    public static final String APPPARM_BINARY = "--binary";
    public static final String APPPARM_ASCII = "--ascii";
    public static final String APPPARM_PROPERTIES = "--properties";
    public static final String APPPARM_COMP_COLOR = "--color";
    public static final String APPPARM_FILEOUT = "--fileout";
    public static final String APPPARM_PRINT = "--print";
    protected SPFC_UploadPanel m_clsPanel;
    private String m_stFTPAddress;
    private int m_iFTPPort = 21;
    private String m_stFTPUser = "RSDRAIDSYS";
    private String m_stFTPPass = "SANPROJECT";
    private String m_stFTPDirectory = "/java";
    private boolean m_bFTPPassiveMode = false;
    private boolean m_bFTPBinaryMode = false;
    private static boolean m_bRemoveAddress = false;
    protected static final String m_stSettingFile = ".appset";
    protected static final String m_stExceptionFile = ".appext";
    protected String m_stFrameTitle = "UPLOAD";
    private JFrame m_frmMainFrame;
    protected Dimension m_dmFrameSize = new Dimension(605, 166);
    private Point m_pntFramePos = new Point(0, 0);
    public static String UPLOAD_PANEL_ADDRESS_LABEL_TEXT;
    public static String UPLOAD_PANEL_ADDRESS_FIELD_TEXT;
    public static String UPLOAD_PANEL_REMOVE_BUTTON_TEXT;
    public static String UPLOAD_PANEL_CLIENTFILE_LABEL_TEXT;
    public static String UPLOAD_PANEL_CLIENTFILE_FIELD_TEXT;
    public static String UPLOAD_PANEL_REFERENCE_BUTTON_TEXT;
    public static String UPLOAD_PANEL_ASCIIMODE_BUTTON_TEXT;
    public static String UPLOAD_PANEL_BINARYMODE_BUTTON_TEXT;
    public static String UPLOAD_PANEL_UPLOAD_BUTTON_TEXT;
    public static String UPLOAD_PANEL_EXIT_BUTTON_TEXT;

    public SPFC_ApplicationCtrl(SPFC_ApplicationParameters sPFC_ApplicationParameters) {
        try {
            this.readApplicationSettings(sPFC_ApplicationParameters);
            SPFC_ApplicationCtrl.changeLookAndFeel();
            this.initialize();
            this.loadSettings();
            this.createMainFrame();
        }
        catch (Exception exception) {
            SPFC_BaseCtrl.logWrite("@ Application Exception @");
            this.writeExceptionTrace(exception);
        }
    }

    protected void initialize() throws Exception {
        this.m_clsPanel = new SPFC_UploadPanel(this);
    }

    protected void readApplicationSettings(SPFC_ApplicationParameters sPFC_ApplicationParameters) {
        int n;
        String string = "notfound";
        String string2 = sPFC_ApplicationParameters.getValue(APPPARM_DEBUG, string);
        if (!string2.equals(string)) {
            SPFC_BaseCtrl.setDebugMode(true);
        } else {
            SPFC_BaseCtrl.setDebugMode(false);
        }
        this.readWordsValue("");
        string2 = sPFC_ApplicationParameters.getValue(APPPARM_TITLE, string);
        if (!string2.equals(string)) {
            this.setFrameTitle(string2);
        }
        if (!(string2 = sPFC_ApplicationParameters.getValue(APPPARM_REMOVE, string)).equals(string)) {
            this.setVisibleRemoveAddress(true);
        } else {
            this.setVisibleRemoveAddress(false);
        }
        string2 = sPFC_ApplicationParameters.getValue(APPPARM_ADDRESS, string);
        if (!string2.equals(string)) {
            this.setFTPAddress(string2);
        }
        if (!(string2 = sPFC_ApplicationParameters.getValue(APPPARM_PORT, string)).equals(string)) {
            n = this.m_iFTPPort;
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setFTPPort(n);
        }
        if (!(string2 = sPFC_ApplicationParameters.getValue(APPPARM_USER, string)).equals(string)) {
            this.setFTPUser(string2);
        }
        if (!(string2 = sPFC_ApplicationParameters.getValue(APPPARM_PASSWORD, string)).equals(string)) {
            this.setFTPPassword(string2);
        }
        if (!(string2 = sPFC_ApplicationParameters.getValue(APPPARM_DIRECTORY, string)).equals(string)) {
            this.setFTPDirectory(string2);
        }
        if (!(string2 = sPFC_ApplicationParameters.getValue(APPPARM_PASSIVE, string)).equals(string)) {
            this.setFTPPassiveMode(true);
        }
        if (!(string2 = sPFC_ApplicationParameters.getValue(APPPARM_ACTIVE, string)).equals(string)) {
            this.setFTPPassiveMode(false);
        }
        if (!(string2 = sPFC_ApplicationParameters.getValue(APPPARM_BINARY, string)).equals(string)) {
            this.setFTPBinaryMode(true);
        }
        if (!(string2 = sPFC_ApplicationParameters.getValue(APPPARM_ASCII, string)).equals(string)) {
            this.setFTPBinaryMode(false);
        }
        if (!(string2 = sPFC_ApplicationParameters.getValue(APPPARM_COMP_COLOR, string)).equals(string)) {
            n = 3;
            if (string2.equals("red")) {
                n = 1;
            } else if (string2.equals("green")) {
                n = 2;
            } else if (string2.equals("blue")) {
                n = 3;
            } else if (string2.equals("black")) {
                n = 4;
            }
            SPFC_BaseCtrl.setComponentColor(n);
        }
        if (!(string2 = sPFC_ApplicationParameters.getValue(APPPARM_FILEOUT, string)).equals(string)) {
            SPFC_BaseCtrl.setFileOut(true);
        } else {
            SPFC_BaseCtrl.setFileOut(false);
        }
        string2 = sPFC_ApplicationParameters.getValue(APPPARM_PRINT, string);
        if (!string2.equals(string)) {
            SPFC_BaseCtrl.setLinePrint(true);
        } else {
            SPFC_BaseCtrl.setLinePrint(false);
        }
    }

    protected void readWordsValue(String string) {
        if (string != null) {
            UPLOAD_PANEL_ADDRESS_LABEL_TEXT = "SVP IP Address : ";
            UPLOAD_PANEL_ADDRESS_FIELD_TEXT = "";
            UPLOAD_PANEL_REMOVE_BUTTON_TEXT = "Remove";
            UPLOAD_PANEL_CLIENTFILE_LABEL_TEXT = "File Name on Client : ";
            UPLOAD_PANEL_CLIENTFILE_FIELD_TEXT = "";
            UPLOAD_PANEL_REFERENCE_BUTTON_TEXT = "Reference";
            UPLOAD_PANEL_ASCIIMODE_BUTTON_TEXT = "AsciiMode";
            UPLOAD_PANEL_BINARYMODE_BUTTON_TEXT = "BinaryMode";
            UPLOAD_PANEL_UPLOAD_BUTTON_TEXT = "Upload";
            UPLOAD_PANEL_EXIT_BUTTON_TEXT = "Exit";
        }
    }

    protected void setFrameTitle(String string) {
        this.m_stFrameTitle = string;
    }

    protected void setVisibleRemoveAddress(boolean bl) {
        m_bRemoveAddress = bl;
    }

    public boolean isVisibleRemoveAddress() {
        return m_bRemoveAddress;
    }

    protected void setFTPAddress(String string) {
        if (string != null) {
            UPLOAD_PANEL_ADDRESS_FIELD_TEXT = string;
        }
    }

    protected void setFTPPassiveMode(boolean bl) {
        this.m_bFTPPassiveMode = bl;
    }

    public boolean isFTPPassiveMode() {
        return this.m_bFTPPassiveMode;
    }

    protected void setFTPPort(int n) {
        if (n > 0) {
            this.m_iFTPPort = n;
        }
    }

    public int getFTPPort() {
        return this.m_iFTPPort;
    }

    protected void setFTPUser(String string) {
        if (string != null && !string.equals("")) {
            this.m_stFTPUser = string;
        }
    }

    public String getFTPUser() {
        return this.m_stFTPUser;
    }

    protected void setFTPPassword(String string) {
        if (string != null) {
            this.m_stFTPPass = string;
        }
    }

    public String getFTPPassword() {
        return this.m_stFTPPass;
    }

    protected void setFTPDirectory(String string) {
        if (string != null) {
            this.m_stFTPDirectory = string;
        }
    }

    public String getFTPDirectory() {
        return this.m_stFTPDirectory;
    }

    protected void setFTPBinaryMode(boolean bl) {
        this.m_bFTPBinaryMode = bl;
    }

    public boolean isFTPBinaryMode() {
        return this.m_bFTPBinaryMode;
    }

    protected void createMainFrame() {
        this.m_frmMainFrame = new JFrame(this.m_stFrameTitle);
        this.m_frmMainFrame.getContentPane().add(this.m_clsPanel);
        this.m_frmMainFrame.setDefaultCloseOperation(0);
        this.m_frmMainFrame.addWindowListener(this);
        ((Component)this.m_frmMainFrame).setSize(this.m_dmFrameSize);
        ((Component)this.m_frmMainFrame).setLocation(this.m_pntFramePos);
        this.m_frmMainFrame.setResizable(false);
        ((Component)this.m_frmMainFrame).setVisible(true);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.exitApplication(0);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void exitApplication(int n) {
        SPFC_BaseCtrl.debug_logWrite("exitApplication( )");
        this.m_clsPanel.abortFTPConnection();
        this.saveSettings();
        System.exit(n);
    }

    protected void loadSettings() {
        String[] stringArray = this.readSetting(SET_SERVER_LIST);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.m_clsPanel.addAddress(stringArray[n2]);
            ++n2;
        }
        stringArray = this.readSetting(SET_FRAME_POS);
        n = stringArray.length;
        if (n > 1) {
            int n3 = Integer.parseInt(stringArray[0]);
            int n4 = Integer.parseInt(stringArray[1]);
            this.m_pntFramePos = new Point(n3, n4);
        }
    }

    protected String[] readSetting(String string) {
        String[] stringArray = new String[]{""};
        try {
            File file = new File(m_stSettingFile);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            if (bufferedReader != null && bufferedReader.ready()) {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    SPFC_CSVLineData sPFC_CSVLineData = new SPFC_CSVLineData(string2);
                    String string3 = sPFC_CSVLineData.getValue(0);
                    if (!string.equals(string3)) continue;
                    int n = sPFC_CSVLineData.length();
                    stringArray = new String[n];
                    int n2 = 1;
                    while (n2 < n) {
                        stringArray[n2 - 1] = sPFC_CSVLineData.getValue(n2);
                        ++n2;
                    }
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    protected void saveSettings() {
        this.writeSetting(SET_SERVER_LIST, this.m_clsPanel.getAllAddress());
        String[] stringArray = new String[]{Integer.toString(this.m_frmMainFrame.getX(), 10), Integer.toString(this.m_frmMainFrame.getY(), 10)};
        this.writeSetting(SET_FRAME_POS, stringArray);
    }

    protected void writeSetting(String string, String[] stringArray) {
        String string2 = new String("");
        try {
            BufferedReader bufferedReader;
            File file;
            if (string == null || stringArray == null) {
                return;
            }
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                string2 = string2 + ",\"" + stringArray[n2] + "\"";
                ++n2;
            }
            try {
                file = new File(m_stSettingFile);
                bufferedReader = new BufferedReader(new FileReader(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                file = null;
                bufferedReader = null;
            }
            String string3 = new String("");
            File file2 = new File(".appset.bak");
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
            if (bufferedReader != null && bufferedReader.ready()) {
                String string4;
                boolean bl = false;
                while ((string4 = bufferedReader.readLine()) != null) {
                    SPFC_CSVLineData sPFC_CSVLineData = new SPFC_CSVLineData(string4);
                    String string5 = sPFC_CSVLineData.getValue(0);
                    if (string5.equals(string)) {
                        string3 = string + string2;
                        bl = true;
                    } else {
                        string3 = string4;
                    }
                    bufferedWriter.write(string3);
                    bufferedWriter.newLine();
                }
                if (!bl) {
                    bufferedWriter.write(string + string2);
                    bufferedWriter.newLine();
                }
                bufferedReader.close();
                file.delete();
            } else {
                string3 = string + string2;
                bufferedWriter.write(string3);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
            file2.renameTo(new File(m_stSettingFile));
            file2.delete();
        }
        catch (Exception exception) {
            SPFC_BaseCtrl.logWrite("Found Exception : " + exception.getMessage());
        }
    }

    protected void writeExceptionTrace(Exception exception) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(m_stExceptionFile, true));
            Date date = new Date();
            printWriter.println("\n\n");
            printWriter.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            printWriter.println("++ " + date.toString() + "Found Application Exception");
            printWriter.println("++                                 print StackTrace");
            printWriter.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            exception.printStackTrace();
            exception.printStackTrace(printWriter);
            printWriter.close();
        }
        catch (Exception exception2) {
            System.out.println(exception2.getMessage());
        }
    }

    public static void changeLookAndFeel() {
        String string = System.getProperty("os.name");
        SPFC_BaseCtrl.debug_logWrite("os.name = '" + string + "'");
        int n = 1;
        if (string != null && string.toLowerCase().indexOf("windows") != -1) {
            n = 3;
        }
        SPFC_LookAndFeelManager.setLookAndFeel(n);
        String string2 = UIManager.getLookAndFeel().getName();
        SPFC_BaseCtrl.debug_logWrite("use LookAndFeel : " + string2);
    }

    public static String getApplicationHelp() {
        String string = "                                                                           \n";
        string = string + "Usage java -cp <JAR name> <Application name> [options]                     \n";
        string = string + "                                                                           \n";
        string = string + "Options :                                                                  \n";
        string = string + " [--port <port_number>]                                                    \n";
        string = string + "                 The port of a connection place is changed.                \n";
        string = string + " [--passive] or [--active]                                                 \n";
        string = string + "     --passive   A data connection is generated in the passive mode.       \n";
        string = string + "     --active    A data connection is generated in the active mode.        \n";
        string = string + " [--print]       A log is outputted to standard output.                    \n";
        return new String(string);
    }
}

