/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility;

import java.util.ArrayList;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcAccountChkUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.account.exception.SJcParamErrorException;

public class SJcSNAuthBitUty {
    private static final String LOG_FUNCTION = "SJcSNAuthBitUty";
    private static final String LOG_TITLE = "SJcSNAuthBitUty";
    private static int[][] changeMatrix_R = new int[][]{{1, 32}, {2, 32}, {3, 32}, {7, 16}, {7, 17}, {8, 18}, {8, 19}, {9, 32}, {10, 32}, {11, 32}, {17, 32}, {18, 32}, {19, 32}, {20, 32}, {25, 32}, {33, 32}, {34, 32}, {35, 32}, {41, 32}, {49, 32}, {57, 32}, {65, 32}, {73, 32}, {74, 32}, {75, 32}, {76, 32}, {97, 32}, {105, 32}, {113, 32}, {121, 32}, {122, 32}, {125, 32}, {127, 32}, {129, 32}, {137, 32}, {145, 32}, {146, 20}};
    private static int[][] changeMatrix_RW = new int[][]{{1, 33}, {7, 17}, {8, 19}, {9, 79, 80, 82, 83, 84, 85, 86, 89, 90, 91, 57}, {10, 78}, {11, 81}, {17, 87, 88}, {18, 48, 49, 50, 51, 52, 53}, {19, 43, 65, 66, 67, 68}, {20, 69, 70, 71, 72, 73}, {25, 44, 45}, {33, 95, 97}, {34, 103, 104, 105, 106}, {35, 96}, {41, 78, 111, 112, 113, 114, 115, 116}, {49, 98, 99, 100, 101, 102}, {57, 43, 78, 111, 112, 113, 114, 115, 116}, {65, 98, 99, 100, 101, 102}, {73, 63, 64}, {74, 56}, {75, 55}, {76, 111, 112, 113, 114}, {97, 54}, {105, 58, 59, 60, 61, 62, 78, 119}, {121, 35}, {122, 33}, {125, 38, 39, 40}, {127, 33}, {129, 78, 111, 112, 113, 114}, {137, 43, 78, 111, 112, 113, 114}, {145, 32}, {146, 21, 22, 23, 24, 46, 47}};
    private static int[] CFLMatrix = new int[]{1, 9, 10, 17, 18, 19, 20, 25, 33, 34, 35, 41, 49, 57, 65, 73, 74, 75, 76, 97, 105, 121, 122, 125, 127, 129, 137, 145};

    private SJcSNAuthBitUty() {
    }

    public static String[] getAuthBitSN2toSN(String szSN2Bit) throws SJcException {
        String LOG_SUBTITLE = "getAuthBitSN2toSN";
        try {
            SJcLogUty.getLogger().debug("SJcSNAuthBitUty", "SJcSNAuthBitUty", "getAuthBitSN2toSN", "Start.");
            String[] szRet = new String[2];
            ArrayList<Integer> alAddBit_R = SJcSNAuthBitUty.getAddBit_SN(szSN2Bit, changeMatrix_R);
            szRet[0] = SJcSNAuthBitUty.createAuthBitmap(SJcAccountChkUty.chgIntArray(alAddBit_R));
            ArrayList<Integer> alAddBit_RW = SJcSNAuthBitUty.getAddBit_SN(szSN2Bit, changeMatrix_RW);
            boolean bCFL = true;
            for (int i = 0; i < CFLMatrix.length; ++i) {
                if (alAddBit_RW.indexOf(CFLMatrix[i]) >= 0) continue;
                bCFL = false;
                break;
            }
            if (bCFL) {
                alAddBit_RW.add(113);
            }
            szRet[1] = SJcSNAuthBitUty.createAuthBitmap(SJcAccountChkUty.chgIntArray(alAddBit_RW));
            String[] stringArray = szRet;
            return stringArray;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcSNAuthBitUty", "SJcSNAuthBitUty", "getAuthBitSN2toSN", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcSNAuthBitUty", "SJcSNAuthBitUty", "getAuthBitSN2toSN", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().debug("SJcSNAuthBitUty", "SJcSNAuthBitUty", "getAuthBitSN2toSN", "End.");
        }
    }

    private static ArrayList<Integer> getAddBit_SN(String szSN2Bit, int[][] iMatrix) throws SJcException {
        String LOG_SUBTITLE = "getAddBit_SN";
        try {
            ArrayList<Integer> alAddBit = new ArrayList<Integer>();
            for (int i = 0; i < iMatrix.length; ++i) {
                int[] iChkBit = new int[iMatrix[i].length - 1];
                for (int j = 1; j < iMatrix[i].length; ++j) {
                    iChkBit[j - 1] = iMatrix[i][j];
                }
                if (!SJcAccountChkUty.checkBitAnd(szSN2Bit, iChkBit)) continue;
                alAddBit.add(iMatrix[i][0]);
            }
            return alAddBit;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcSNAuthBitUty", "SJcSNAuthBitUty", "getAddBit_SN", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcSNAuthBitUty", "SJcSNAuthBitUty", "getAddBit_SN", "Exception.", e);
            throw new SJcException();
        }
    }

    private static String createAuthBitmap(int[] iAuth) throws SJcException {
        String LOG_SUBTITLE = "createAuthBitmap";
        try {
            int i;
            String szRet = "";
            int[] iWork = new int[64];
            if (iAuth == null) {
                throw new SJcParamErrorException();
            }
            for (i = 0; i < iAuth.length; ++i) {
                if (iAuth[i] < 1 || iAuth[i] >= 512) continue;
                int iByte = iWork.length - (iAuth[i] - 1) / 8 - 1;
                int iBit = iAuth[i] % 8;
                if (iBit == 0) {
                    iBit = 8;
                }
                iWork[iByte] = iWork[iByte] | 1 << iBit - 1;
            }
            for (i = 0; i < iWork.length; ++i) {
                szRet = szRet + String.format("%2s", Integer.toString(iWork[i], 16));
            }
            szRet = szRet.replaceAll(" ", "0");
            return szRet;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcSNAuthBitUty", "SJcSNAuthBitUty", "createAuthBitmap", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcSNAuthBitUty", "SJcSNAuthBitUty", "createAuthBitmap", "Exception.", e);
            throw new SJcException();
        }
    }
}

