/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.fileuty;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import sanproject.sn2.base.SJbaseConst;
import sanproject.sn2.base.system.inf.SJbasePluginInterface;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.fileuty.SJcFileUtyDirInfo;
import sanproject.sn2.com.utility.fileuty.SJcFileUtyProcessorImpl;
import sanproject.sn2.com.utility.fileuty.inf.SJcFileInterface;
import sanproject.sn2.com.utility.fileuty.inf.SJcFileUtyProcessor;

public class SJcFileUtyManager
implements SJbasePluginInterface {
    private final String LOG_FUNCTION = "FileIOUtility";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private List<SJcFileUtyDirInfo> specialDirList;
    private boolean stopDeleteTmpThreadFlg;
    private Thread deleteTmpThread;
    private SJcFileUtyProcessor processor;
    private SJcLoggerInterface stdLogger = SJcLogUty.getLogger("SN_System.log");

    @Override
    public void initialize(int status) {
        String LOG_SUBTITLE = "initialize";
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "initialize", "Start. - status:" + status);
        if (0 != status) {
            this.cleanUpFailureFinish();
        }
        Properties props = this.loadSettings();
        this.specialDirList = this.initDirList(props);
        this.deleteDirOnBoot();
        this.startDeleteTmpThread();
        this.initProcessor();
        this.createOnMemoryDir();
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "initialize", "End.");
    }

    private void cleanUpFailureFinish() {
        String LOG_SUBTITLE = "cleanUpFailureFinish";
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "cleanUpFailureFinish", "Start.");
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "cleanUpFailureFinish", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadSettings() {
        String LOG_SUBTITLE = "loadSettings";
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "loadSettings", "Start.");
        String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
        String fileUtyPath = SJcFileUty.concatFolderPath(dataPath, SJbaseConst.SN_DIRECTORY_BASE_SETTING_SPECIALDIR);
        String filePath = SJcFileUty.concatFolderPath(fileUtyPath, "SpecialDirList.properties");
        Properties props = new Properties();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(filePath);
            props.load(inStream);
        }
        catch (FileNotFoundException fnfe) {
            this.stdLogger.error("FileIOUtility", this.LOG_TITLE, "loadSettings", "FileNotFoundException occured.", fnfe);
        }
        catch (IOException ioe) {
            this.stdLogger.error("FileIOUtility", this.LOG_TITLE, "loadSettings", "IOException occured." + props.toString(), ioe);
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (Exception e) {
                    this.stdLogger.error("FileIOUtility", this.LOG_TITLE, "loadSettings", "Failed to inStream close.", e);
                }
            }
        }
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "loadSettings", "End.");
        return props;
    }

    private List<SJcFileUtyDirInfo> initDirList(Properties props) {
        String LOG_SUBTITLE = "initDirList";
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "initDirList", "Start.");
        ArrayList list = new ArrayList();
        if (null != props) {
            String dirList = props.getProperty("dirList");
            this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "initDirList", "List:" + dirList);
            String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
            if (null != dirList) {
                String[] dirs = dirList.split(",");
                for (int i = 0; i < dirs.length; ++i) {
                    String dir = dirs[i].trim();
                    String pathKey = dir + ".dirPath";
                    String path = props.getProperty(pathKey);
                    if (null == path) continue;
                    if ((path = SJcFileUty.concatFolderPath(dataPath, path)).endsWith(File.separator)) {
                        path = path.substring(0, path.lastIndexOf(File.separator));
                    }
                    String onMemoryKey = dir + ".onMemory";
                    boolean onMemoryFlg = false;
                    try {
                        onMemoryFlg = Boolean.valueOf(props.getProperty(onMemoryKey));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    String keepTimeKey = dir + ".keepTime";
                    int keepTimeInMins = -1;
                    try {
                        keepTimeInMins = Integer.parseInt(props.getProperty(keepTimeKey));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    keepTimeInMins = -1 > keepTimeInMins ? -1 : keepTimeInMins;
                    long keepTimeInMillis = -1 == keepTimeInMins ? -1L : (long)(keepTimeInMins * 60 * 1000);
                    String deleteOnBootKey = dir + ".deleteOnBoot";
                    boolean deleteOnBootFlg = false;
                    try {
                        deleteOnBootFlg = Boolean.valueOf(props.getProperty(deleteOnBootKey));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    SJcFileUtyDirInfo dirInfo = new SJcFileUtyDirInfo();
                    dirInfo.setPath(path);
                    dirInfo.setDirType(onMemoryFlg ? 1 : 0);
                    dirInfo.setKeepTime(keepTimeInMillis);
                    dirInfo.setDeleteOnBoot(deleteOnBootFlg);
                    list.add(dirInfo);
                }
            }
        }
        list = (ArrayList)this.purgeDirList(list);
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "initDirList", "End.");
        return list;
    }

    private List<SJcFileUtyDirInfo> purgeDirList(List<SJcFileUtyDirInfo> srcList) {
        String LOG_SUBTITLE = "purgeDirList";
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "purgeDirList", "Start.");
        ArrayList<SJcFileUtyDirInfo> list = new ArrayList<SJcFileUtyDirInfo>();
        ListIterator<SJcFileUtyDirInfo> iterator = srcList.listIterator();
        while (iterator.hasNext()) {
            SJcFileUtyDirInfo dirInfo = iterator.next();
            if (!this.isDirInfoAvailable(srcList, dirInfo.getPath())) continue;
            list.add(dirInfo);
        }
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "purgeDirList", "End.");
        return list;
    }

    private boolean isDirInfoAvailable(List<SJcFileUtyDirInfo> srcList, String path) {
        String LOG_SUBTITLE = "isDirInfoAvailable";
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "isDirInfoAvailable", "Start. - path:" + path);
        boolean ret = true;
        ListIterator<SJcFileUtyDirInfo> iterator = srcList.listIterator();
        while (iterator.hasNext()) {
            File file;
            SJcFileUtyDirInfo dirInfo = iterator.next();
            String parentPath = path;
            while (ret && null != (parentPath = (file = new File(parentPath)).getParent())) {
                if (!parentPath.equals(dirInfo.getPath())) continue;
                ret = false;
            }
            if (ret) continue;
            break;
        }
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "isDirInfoAvailable", "End. - return:" + ret);
        return ret;
    }

    private void deleteDirOnBoot() {
        String LOG_SUBTITLE = "deleteDirOnBoot";
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "deleteDirOnBoot", "Start.");
        ListIterator<SJcFileUtyDirInfo> iterator = this.specialDirList.listIterator();
        while (iterator.hasNext()) {
            SJcFileUtyDirInfo dirInfo = iterator.next();
            if (!dirInfo.isDeleteOnBoot() || dirInfo.getDirType() != 0) continue;
            this.deleteContainsAll(new File(dirInfo.getPath()));
        }
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "deleteDirOnBoot", "End.");
    }

    private void startDeleteTmpThread() {
        String LOG_SUBTITLE = "startDeleteTmpThread";
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "startDeleteTmpThread", "Start.");
        this.stopDeleteTmpThreadFlg = false;
        this.deleteTmpThread = new Thread(){

            @Override
            public void run() {
                SJcFileUtyManager.this.pollingDeleteTmpDir();
            }
        };
        this.deleteTmpThread.start();
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "startDeleteTmpThread", "End.");
    }

    private void initProcessor() {
        String LOG_SUBTITLE = "initProcessor";
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "initProcessor", "Start.");
        this.processor = new SJcFileUtyProcessorImpl(this.specialDirList);
        SJcFileUty.setProcessor(this.processor);
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "initProcessor", "End.");
    }

    @Override
    public void finish() {
        String LOG_SUBTITLE = "finish";
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "finish", "Start.");
        this.stopDeleteTmpThread();
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "finish", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopDeleteTmpThread() {
        String LOG_SUBTITLE = "stopDeleteTmpThread";
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "stopDeleteTmpThread", "Start.");
        if (null == this.deleteTmpThread) {
            this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "stopDeleteTmpThread", "Thread is already null.");
            return;
        }
        Thread thread = this.deleteTmpThread;
        synchronized (thread) {
            this.stopDeleteTmpThreadFlg = true;
            this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "stopDeleteTmpThread", "Thread notify start.");
            this.deleteTmpThread.notify();
        }
        try {
            this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "stopDeleteTmpThread", "Thread join start.");
            this.deleteTmpThread.join();
            this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "stopDeleteTmpThread", "Thread join end.");
        }
        catch (InterruptedException e) {
            this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "stopDeleteTmpThread", "Wait interrupted.");
            Thread.currentThread().interrupt();
        }
        this.deleteTmpThread = null;
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "stopDeleteTmpThread", "End.");
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean isEnable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollingDeleteTmpDir() {
        String LOG_SUBTITLE = "pollingDeleteTmpDir";
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "pollingDeleteTmpDir", "Start.");
        int intervalTimeInMin = SJcEnvUty.getProperty2int("SN_Base_DirectoryTmpRoundTime");
        if (0 == intervalTimeInMin || intervalTimeInMin < -1) {
            intervalTimeInMin = 3;
        }
        long intervalTimeInMillis = -1 == intervalTimeInMin ? (long)intervalTimeInMin : (long)(intervalTimeInMin * 60 * 1000);
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "pollingDeleteTmpDir", "Interval time(ms):" + intervalTimeInMillis);
        if (-1L != intervalTimeInMillis) {
            while (!this.stopDeleteTmpThreadFlg) {
                this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "pollingDeleteTmpDir", "Loop start.");
                Thread thread = this.deleteTmpThread;
                synchronized (thread) {
                    try {
                        this.deleteTmpThread.wait(intervalTimeInMillis);
                    }
                    catch (InterruptedException e) {
                        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "pollingDeleteTmpDir", "Wait interrupted.");
                        Thread.currentThread().interrupt();
                    }
                }
                ListIterator<SJcFileUtyDirInfo> iterator = this.specialDirList.listIterator();
                while (iterator.hasNext()) {
                    SJcFileUtyDirInfo dirInfo = iterator.next();
                    this.deleteFilesOverKeepTime(dirInfo);
                }
            }
        }
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "pollingDeleteTmpDir", "End.");
    }

    private void deleteFilesOverKeepTime(SJcFileUtyDirInfo dirInfo) {
        SJcFileInterface iFileDir;
        String LOG_SUBTITLE = "deleteFilesOverKeepTime";
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "deleteFilesOverKeepTime", "Start. - path:" + dirInfo.getPath());
        long keepTimeInMillis = dirInfo.getKeepTime();
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "deleteFilesOverKeepTime", "Keep time:" + keepTimeInMillis);
        if (-1L != keepTimeInMillis && null != this.processor && null != (iFileDir = this.processor.getSJcFile(dirInfo.getPath()))) {
            long currentTime = System.currentTimeMillis();
            this.deleteFilesOverKeepTime(iFileDir, keepTimeInMillis, currentTime);
            this.deleteEmptyDirs(iFileDir);
        }
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "deleteFilesOverKeepTime", "End.");
    }

    private void deleteFilesOverKeepTime(SJcFileInterface dirInfo, long keepTimeInMillis, long currentTime) {
        String LOG_SUBTITLE = "deleteFilesOverKeepTime";
        this.stdLogger.trace("FileIOUtility", this.LOG_TITLE, "deleteFilesOverKeepTime", "Start. - path:" + dirInfo.getPath());
        List<SJcFileUtyManTmpFile> tmpFileList = this.getTmpFileList(dirInfo.listFiles());
        ListIterator<SJcFileUtyManTmpFile> iterator = tmpFileList.listIterator();
        while (iterator.hasNext()) {
            SJcFileUtyManTmpFile tmpFile = iterator.next();
            if (tmpFile.isDirectory()) {
                SJcFileInterface iDir = this.processor.getSJcFile(tmpFile.getPath());
                this.deleteFilesOverKeepTime(iDir, keepTimeInMillis, currentTime);
                this.deleteEmptyDirs(iDir);
                continue;
            }
            long lastModified = tmpFile.getLastModified();
            if (currentTime - lastModified <= keepTimeInMillis) continue;
            SJcFileInterface iFile = this.processor.getSJcFile(tmpFile.getPath());
            iFile.deleteAll();
            this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "deleteFilesOverKeepTime", "Delete. - path:" + iFile.getPath());
        }
        this.stdLogger.trace("FileIOUtility", this.LOG_TITLE, "deleteFilesOverKeepTime", "End.");
    }

    private List<SJcFileUtyManTmpFile> getTmpFileList(SJcFileInterface[] list) {
        ArrayList<SJcFileUtyManTmpFile> tmpFileList = new ArrayList<SJcFileUtyManTmpFile>();
        for (int i = 0; i < list.length; ++i) {
            SJcFileInterface f = list[i];
            SJcFileUtyManTmpFile tmpFile = new SJcFileUtyManTmpFile();
            tmpFile.setPath(f.getPath());
            tmpFile.setLastModified(f.lastModified());
            tmpFile.setIsDirectory(f.isDirectory());
            tmpFileList.add(tmpFile);
        }
        return tmpFileList;
    }

    private void deleteEmptyDirs(SJcFileInterface dirInfo) {
        SJcFileInterface iFile;
        String LOG_SUBTITLE = "deleteEmptyDirs";
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "deleteEmptyDirs", "Start. - path:" + dirInfo.getPath());
        if (null != this.processor && (iFile = dirInfo).exists()) {
            SJcFileInterface[] list = iFile.listFiles();
            for (int i = 0; i < list.length; ++i) {
                SJcFileInterface f = list[i];
                if (!f.isDirectory() || f.listFiles().length != 0) continue;
                boolean result = f.delete();
                this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "deleteEmptyDirs", "Delete. - path:" + f.getPath() + ", result:" + result);
            }
        }
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "deleteEmptyDirs", "End.");
    }

    private void deleteContainsAll(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.deleteContainsAll(files[i]);
            }
            file.delete();
        }
    }

    private void createOnMemoryDir() {
        String LOG_SUBTITLE = "createOnMemoryDir";
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "createOnMemoryDir", "Start.");
        ListIterator<SJcFileUtyDirInfo> iterator = this.specialDirList.listIterator();
        while (iterator.hasNext()) {
            SJcFileUtyDirInfo dirInfo = iterator.next();
            if (dirInfo.getDirType() != 1) continue;
            SJcFileUty.makeDirectoryAbsolutePath(dirInfo.getPath());
        }
        this.stdLogger.info("FileIOUtility", this.LOG_TITLE, "createOnMemoryDir", "End.");
    }

    private class SJcFileUtyManTmpFile {
        private String path;
        private long lastModified;
        private boolean directory = false;

        private SJcFileUtyManTmpFile() {
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(long timeInMillis) {
            this.lastModified = timeInMillis;
        }

        public boolean isDirectory() {
            return this.directory;
        }

        public void setIsDirectory(boolean directory) {
            this.directory = directory;
        }
    }
}

