/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJcTRLogUty {
    private static final String ERROR = "0";
    private static final String WARN = "1";
    private static final String INFO = "2";
    private static final String DEFAULT_LOG_STR = "-";
    private static final String BAT_FILE = "mp" + File.separator + "pc" + File.separator + "TroubleshootLogOperation.bat";
    private static final String LOG_FUNCTION = "TRLog";
    private static final String LOG_TITLE = "SJcTRLogUty";
    private static SJcLoggerInterface logger = SJcLogUty.getLogger("SN_System.log");

    public static void error(String appName, String trCode, String msg) {
        SJcTRLogUty.logCommon(ERROR, appName, trCode, msg);
    }

    public static void error(String appName, String trCode, String msg, String moduleId) {
        SJcTRLogUty.logCommon(ERROR, appName, trCode, msg, moduleId);
    }

    public static void warn(String appName, String trCode, String msg) {
        SJcTRLogUty.logCommon(WARN, appName, trCode, msg);
    }

    public static void warn(String appName, String trCode, String msg, String moduleId) {
        SJcTRLogUty.logCommon(WARN, appName, trCode, msg, moduleId);
    }

    public static void warn(String appName, String msg) {
        SJcTRLogUty.warn(appName, DEFAULT_LOG_STR, msg);
    }

    public static void info(String appName, String trCode, String msg) {
        SJcTRLogUty.logCommon(INFO, appName, trCode, msg);
    }

    public static void info(String appName, String trCode, String msg, String moduleId) {
        SJcTRLogUty.logCommon(INFO, appName, trCode, msg, moduleId);
    }

    public static void info(String appName, String msg) {
        SJcTRLogUty.info(appName, DEFAULT_LOG_STR, msg);
    }

    private static void logCommon(String logLevel, String appName, String trCode, String msg) {
        SJcTRLogUty.logCommon(logLevel, appName, trCode, msg, DEFAULT_LOG_STR);
    }

    private static void logCommon(String logLevel, String appName, String trCode, String msg, String moduleId) {
        String LOG_SUBTITLE = "logCommon";
        logger.info(LOG_FUNCTION, LOG_TITLE, "logCommon", "Start. CODE=" + trCode);
        String snBasePath = SJcEnvUty.getSnBasePath();
        String batPath = snBasePath + BAT_FILE;
        ArrayList<String> strcmd = new ArrayList<String>();
        strcmd.add(batPath);
        strcmd.add(logLevel);
        strcmd.add(appName);
        strcmd.add(trCode);
        strcmd.add(msg);
        strcmd.add(moduleId);
        SJcTRLogUty.executeCommand(strcmd);
        logger.info(LOG_FUNCTION, LOG_TITLE, "logCommon", "End. CODE=" + trCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void executeCommand(ArrayList<String> strcmd) {
        Process execProc = null;
        String LOG_SUBTITLE = "executeCommand";
        try {
            ProcessBuilder builder = new ProcessBuilder(strcmd);
            execProc = builder.start();
            execProc.waitFor();
        }
        catch (Exception ex) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Exception.", ex);
        }
        finally {
            if (execProc != null) {
                try {
                    execProc.getInputStream().close();
                }
                catch (IOException ioe) {}
                try {
                    execProc.getOutputStream().close();
                }
                catch (IOException ioe) {}
                try {
                    execProc.getErrorStream().close();
                }
                catch (IOException iOException) {}
                execProc.destroy();
            }
        }
    }
}

