/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRscUtil_IF;
import sanproject.sn2.model.connector.kind.SJmoGetThroughRmiData;
import sanproject.sn2.model.data.inf.SJmoDataIndex_IF;

public class SJctrGetDirectWrapper {
    private boolean cacheMode;
    private final SJmoGetDirect myDirect;
    private final String myString;

    public SJctrGetDirectWrapper(SJmoGetDirect direct) {
        this(direct, true);
    }

    public SJctrGetDirectWrapper(SJmoGetDirect direct, boolean cache) {
        if (direct == null) {
            throw new IllegalArgumentException();
        }
        if (direct.getGetKind() == null) {
            throw new NullPointerException();
        }
        this.myDirect = direct;
        this.myString = this.createString(direct);
        this.cacheMode = cache;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SJctrGetDirectWrapper) {
            return this.myString.equals(obj.toString());
        }
        return false;
    }

    public SJmoGetDirect getDirect() {
        return this.myDirect;
    }

    public Class<? extends SJmoGetKind_IF> getKindClass() {
        return this.myDirect.getGetKind().getClass();
    }

    public String getCacheKey() {
        return this.getCacheKey(this.myDirect);
    }

    public String getCacheKey(SJmoGetDirect direct) {
        Object kind = direct.getGetKind();
        if (kind.getClass() == SJmoGetThroughRmiData.class) {
            SJmoGetThroughRmiData through = (SJmoGetThroughRmiData)kind;
            if (through.iskeyValue()) {
                return through.getMethodName();
            }
            String methodName = through.getMethodName();
            if (!"getCmnData".equals(methodName)) {
                throw new SJcException();
            }
            Object[] paramObj = through.getMethodParamObject();
            kind = paramObj[0];
        }
        String cacheKey = kind.getClass().getName();
        return cacheKey;
    }

    public int hashCode() {
        return this.myString.hashCode();
    }

    public boolean isCacheMode() {
        return this.cacheMode;
    }

    public boolean isRscUtil() {
        boolean ret = this.myDirect.getGetKind() instanceof SJmoGetRscUtil_IF;
        return ret;
    }

    public void setCacheMode(boolean cache) {
        this.cacheMode = cache;
    }

    public String toString() {
        return this.myString;
    }

    private String createString(SJmoGetDirect direct) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getCacheKey(direct));
        buf.append('/');
        SJmoGetRange_IF range = direct.getGetRange();
        if (range == null) {
            buf.append("null");
        } else {
            buf.append(range.getClass().getSimpleName());
            SJmoDataIndex_IF s = range.getStartIndex();
            SJmoDataIndex_IF e = range.getEndIndex();
            if (s != null && e != null) {
                buf.append('(');
                buf.append(s.getIndexKey());
                buf.append(",");
                buf.append(e.getIndexKey());
                buf.append(')');
            }
        }
        buf.append('/');
        List list = direct.getGetTermList();
        if (list == null) {
            buf.append("null");
        } else {
            buf.append('[');
            int length = list.size();
            for (int i = 0; i < length; ++i) {
                Object obj = list.get(i);
                if (obj == null) {
                    buf.append("null");
                } else {
                    buf.append(obj.getClass().getSimpleName());
                }
                buf.append(',');
            }
            if (length > 0) {
                buf.setCharAt(buf.length() - 1, ']');
            } else {
                buf.append(']');
            }
        }
        return buf.toString();
    }
}

