/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortFcoeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortFcoeInfo;

public class SJctrFcfIndexColumnFromPortFcoeInfo
extends SJctrColumn {
    private static final int FCOE_INFO_LIST_ZERO = 0;
    private static final int FAILD_NUMBER = -1;
    private static final int FAILD_NUMBER_QUESTION = -2;
    protected HashMap<String, Integer> fcfIndexNumMap = null;

    public SJctrFcfIndexColumnFromPortFcoeInfo(String key) {
        super(key);
        if (SJctrDataController.isHM()) {
            this.setSupportColumn(false);
        }
        this.setSupportColumn(false);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("FCF_INDEX"));
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortFcoeInfo.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        int fcoeIndex;
        SJmoPortDetail ptDetail = (SJmoPortDetail)index;
        SJmoPortFcoeInfo fcoeInfo = null;
        List<?> ptFcoeList = modelData.get(SJmoGetPortFcoeInfo.class);
        if (ptFcoeList.size() != 0 && (fcoeIndex = Collections.binarySearch(ptFcoeList, ptDetail)) >= 0) {
            fcoeInfo = (SJmoPortFcoeInfo)ptFcoeList.get(fcoeIndex);
        }
        ArrayList<SJmoPortFcoeInfo> list = new ArrayList<SJmoPortFcoeInfo>();
        list.add(fcoeInfo);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoPortFcoeInfo fcoeInfo = (SJmoPortFcoeInfo)dataList.get(0);
        SJctrPortUtility util = this.getTable().getComUtility().getPortUtility();
        String fcfIndex = util.toFcfIndexDisplay(fcoeInfo);
        if (this.fcfIndexNumMap == null) {
            this.fcfIndexNumMap = new HashMap(this.getTable().getRowCount());
        }
        boolean mapPutFlg = !fcfIndex.equals(SJctrPortUtility.STR_HYPHEN);
        mapPutFlg &= !fcfIndex.equals("?");
        if (mapPutFlg &= !fcfIndex.equals("")) {
            this.fcfIndexNumMap.put(fcfIndex, Integer.parseInt(fcfIndex));
        }
        return fcfIndex;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        int num = -1;
        String strNum = this.getString(dat);
        boolean numFlg = strNum.length() != 0;
        numFlg &= !strNum.equals(SJctrPortUtility.STR_HYPHEN);
        numFlg &= !strNum.equals("?");
        if (numFlg &= !strNum.equals("")) {
            num = this.fcfIndexNumMap.get(strNum);
        }
        return num;
    }
}

