/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;

public class SJctrLunNumColumnFromPortHostGroupTableKey
extends SJctrColumn {
    protected HashMap<String, Integer> lunNumMap = null;

    public SJctrLunNumColumnFromPortHostGroupTableKey(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("NUM_OF_LUN"));
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Integer data = 0;
        short sHostGroup = 0;
        short sPort = 0;
        SJctrPortHostGroupTableKey ptHginfo = (SJctrPortHostGroupTableKey)index;
        if (ptHginfo.isFibre()) {
            SJmoHostGroupInfo hgInfo = ptHginfo.getHostGroupInfo();
            sPort = ptHginfo.getPortHostGroupInfo().getSPort();
            sHostGroup = hgInfo.getSHostGroup();
        } else {
            SJmoIscsiTargetInfo itInfo = ptHginfo.getIscsiTargetInfo();
            sPort = ptHginfo.getPortIscsiTargetInfo().getSPort();
            sHostGroup = itInfo.getSIscsiTarget();
        }
        List<?> portLunInfoList = modelData.get(SJmoGetPortLunInfo.class);
        for (SJmoPortLunInfo ptLun : portLunInfoList) {
            if (sPort != ptLun.getSPort()) continue;
            ArrayList ptLunDetailList = ptLun.getAlPortLun();
            int num = 0;
            for (SJmoPortLunDetail ptLunDetail : ptLunDetailList) {
                if (sHostGroup != ptLunDetail.getSHostGroup()) continue;
                ++num;
            }
            data = num;
            break;
        }
        list.add(data);
        return list;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortLunInfo.class);
        return list;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public String toDispString(List<?> dataList) {
        int num = (Integer)dataList.get(0);
        String strNum = SJctrComUtility.toDecString(num);
        if (this.lunNumMap == null) {
            this.lunNumMap = new HashMap(this.getTable().getRowCount());
        }
        this.lunNumMap.put(strNum, num);
        return strNum;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        boolean num = false;
        String strNum = this.getString(dat);
        return this.lunNumMap.get(strNum).intValue();
    }
}

