/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.iscsi;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.data.device.SJmoPortDetail;

public class SJctrVlanTaggingColumnFromPortDetail
extends SJctrColumn {
    protected String strEnabled = "?";
    protected String strDisabled = "?";

    public SJctrVlanTaggingColumnFromPortDetail(String key) {
        super(key);
        this.setPartsId("VLAN_TAG_MODE");
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.strEnabled = util.getGuidance("ENABLED");
        this.strDisabled = util.getGuidance("DISABLED");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortDetail.class);
        return list;
    }

    @Override
    public int getFilterType() {
        return 3;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoPortDetail portInfo = (SJmoPortDetail)dataList.get(0);
        if (!SJctrPortUtility.isIscsiPort(portInfo)) {
            return SJctrPortUtility.STR_HYPHEN;
        }
        if (portInfo.getIVPortMode() == 1) {
            return SJctrPortUtility.STR_HYPHEN;
        }
        if (portInfo.getBAvailableVlanTagging()) {
            return this.strEnabled;
        }
        return this.strDisabled;
    }
}

