/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrp;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrJournalCapacityColumnFromUrJnlGrp
extends SJctrCapacityColumn {
    public SJctrJournalCapacityColumnFromUrJnlGrp(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("JNL_CAP"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetLdevDetail.class);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJctrCapacityUtility capUtil = this.getTable().getComUtility().getCapacityUtility();
        String select = this.getUnitSelect();
        SJctrCapacityUtility.UNIT unit = SJctrCapacityUtility.UNIT.valueOf(select);
        SJmoUniversalReplicatorJnlGrp jnlGrp = (SJmoUniversalReplicatorJnlGrp)dataList.get(0);
        List<?> ldevDetailList = this.getTable().getBasicDataMap().get(SJmoGetLdevDetail.class);
        SJctrRemoteReplicationUtility remoteReplicaUty = this.getTable().getComUtility().getRemoteReplicationUtility();
        return remoteReplicaUty.getJournalCapacityString(jnlGrp, ldevDetailList, capUtil, unit);
    }

    @Override
    public int getFilterType() {
        return 4;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long number = -1L;
        SJmoUniversalReplicatorJnlGrp tblData = (SJmoUniversalReplicatorJnlGrp)this.getPrimaryKeyObject(dat);
        List<?> ldevDetailList = this.getTable().getBasicDataMap().get(SJmoGetLdevDetail.class);
        if (tblData != null) {
            int target;
            number = 0L;
            ArrayList alJnlVols = tblData.getJnlVols();
            if (alJnlVols != null && 0 <= (target = Collections.binarySearch(ldevDetailList, alJnlVols.get(0)))) {
                SJmoLdevDetail ldevDetail = (SJmoLdevDetail)ldevDetailList.get(target);
                number += ldevDetail.getLLDEVLBASize();
            }
        }
        return number;
    }

    @Override
    protected long getCylinderNumber(Map<String, Object> dat) {
        long number = -1L;
        SJmoUniversalReplicatorJnlGrp tblData = (SJmoUniversalReplicatorJnlGrp)this.getPrimaryKeyObject(dat);
        List<?> ldevDetailList = this.getTable().getBasicDataMap().get(SJmoGetLdevDetail.class);
        if (tblData != null) {
            int target;
            number = 0L;
            ArrayList alJnlVols = tblData.getJnlVols();
            if (alJnlVols != null && 0 <= (target = Collections.binarySearch(ldevDetailList, alJnlVols.get(0)))) {
                SJmoLdevDetail ldevDetail = (SJmoLdevDetail)ldevDetailList.get(target);
                long block = ldevDetail.getLLDEVLBASize();
                int emuType = ldevDetail.getIEmulationType();
                SJctrCapacityUtility capaUtil = this.getTable().getComUtility().getCapacityUtility();
                number += capaUtil.toCylValue(block, emuType);
            }
        }
        return number;
    }
}

