/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.replication.com;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetLDEVLUPathInfo;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public abstract class SJctrHgNameColumnFromLdevIndex
extends SJctrColumn {
    protected Map<Integer, List<SJmoPortLunDetail>> ldevLUPathInfoMap = null;

    public SJctrHgNameColumnFromLdevIndex(String key) {
        super(key);
    }

    protected abstract SJmoLdevIndex getTargetLdevIndex(Object var1);

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("HG_NAME_ISCSI_TARGET_ALIAS"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortHostGroupInfo.class);
        list.add(SJmoGetPortIscsiTargetInfo.class);
        list.add(SJmoGetPortDetail.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        List<?> portDetailList;
        SJmoPortDetail portDetail;
        SJmoLdevIndex volIndex;
        SJmoPortLunDetail portLunDtl;
        List<Object> retList = new ArrayList<Object>();
        if (this.ldevLUPathInfoMap == null) {
            this.ldevLUPathInfoMap = (Map)modelData.get(SJctrGetLDEVLUPathInfo.class).get(0);
        }
        if ((portLunDtl = SJctrRemoteReplicationUtility.getDisplayLunDetailInfo(volIndex = this.getTargetLdevIndex(index), this.ldevLUPathInfoMap)) != null && (portDetail = (SJmoPortDetail)SJctrIscsiUtility.getPortInfoByPortIndex(portDetailList = modelData.get(SJmoGetPortDetail.class), (SJmoPortIndex)portLunDtl)) != null) {
            if (SJctrIscsiUtility.isFibrePort(portDetail)) {
                List<SJmoPortHostGroupInfo> portHGList = modelData.get(SJmoGetPortHostGroupInfo.class);
                retList = SJctrIscsiUtility.getHostGroupInfoList(portHGList, portLunDtl);
            } else if (SJctrIscsiUtility.isIscsiPort(portDetail)) {
                List<SJmoPortIscsiTargetInfo> portIscsiTargetList = modelData.get(SJmoGetPortIscsiTargetInfo.class);
                retList = SJctrIscsiUtility.getIscsiTargetInfoList(portIscsiTargetList, portLunDtl);
            } else {
                retList.add(null);
            }
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "? (?)";
        if (dataList == null || dataList.isEmpty()) {
            ret = "-";
        } else {
            Object rowData = dataList.get(0);
            if (rowData instanceof SJmoHostGroupInfo) {
                SJmoHostGroupInfo hgInfo = (SJmoHostGroupInfo)rowData;
                SJctrPortUtility util = this.getTable().getComUtility().getPortUtility();
                ret = util.toHostGroupNameDisplay(hgInfo);
            } else if (rowData instanceof SJmoIscsiTargetInfo) {
                SJmoIscsiTargetInfo tgInfo = (SJmoIscsiTargetInfo)rowData;
                SJctrIscsiUtility util = this.getTable().getComUtility().getIscsiUtility();
                ret = util.getIscsiTargetAliasIdString(tgInfo);
            }
        }
        return ret;
    }
}

