/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.tasks;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrTask;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.topwindow.tasks.SJctrDispTaskInfo;
import sanproject.sn2.controller.topwindow.tasks.com.SJctrTaskDef;
import sanproject.sn2.controller.topwindow.tasks.status.SJctrTasksStatusDC;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;

public class SJctrColumnStatus
extends SJctrColumn {
    public String sSTask_Status = "";
    public String sStatus = "";
    public String sWaiting = "";
    public String sSuspended = "";
    public String sIn_Progress_Str = "";
    public String sIn_Progress_Par = "";
    public String sCompleted = "";
    public String sFailed = "";
    public String sAborted = "";
    public String sCompleted_Req = "";

    public SJctrColumnStatus(String key) {
        super(key);
        this.setItemInfo(3);
    }

    @Override
    public int getSortType() {
        return 0;
    }

    @Override
    public int getFilterType() {
        return 3;
    }

    @Override
    public String getLabel() {
        return this.sStatus;
    }

    @Override
    public String getString(Map<String, Object> dat) {
        SJctrDataObject cell = (SJctrDataObject)dat.get(this.getMyFullPathKey());
        String label = (String)cell.getData("label");
        return label;
    }

    @Override
    public String toDispString(List<?> dataList) {
        return this.sStatus;
    }

    @Override
    public Object createCellObject(List<?> dataList) {
        SJctrDataObject cellObject = new SJctrDataObject();
        SJctrDispTaskInfo taskInfo = (SJctrDispTaskInfo)dataList.get(0);
        int icon = 12294;
        String label = "";
        switch (taskInfo.getStatus()) {
            case 0: {
                break;
            }
            case 1: {
                icon = 16386;
                label = this.sWaiting;
                break;
            }
            case 2: {
                icon = 16387;
                label = this.sSuspended;
                break;
            }
            case 256: 
            case 257: 
            case 258: {
                icon = 16385;
                label = taskInfo.getProgress() + this.sIn_Progress_Par + " " + this.sIn_Progress_Str;
                break;
            }
            case 512: {
                icon = 16388;
                SJctrTask task = taskInfo.getTaskInst();
                int behavior = task.getGeneralBehavior();
                if (SJctrTask.checkBehavior(behavior, 4)) {
                    label = this.sCompleted_Req;
                    break;
                }
                label = this.sCompleted;
                break;
            }
            case 513: 
            case 514: {
                icon = 16397;
                label = this.sFailed;
                break;
            }
        }
        cellObject.setData("label", label);
        cellObject.setData("COM_ICON", icon);
        return cellObject;
    }

    @Override
    public List<Object> doLinkAction(Map<String, Object> rowData) {
        ArrayList<Object> param = new ArrayList<Object>();
        SJctrDispTaskInfo taskInfo = (SJctrDispTaskInfo)this.getPrimaryKeyObject(rowData);
        param.add(SJctrTaskDef.TASK_CONTROL_MSG.MAKE_STATUS);
        param.add(SJctrTasksStatusDC.class);
        param.add(taskInfo.getTaskInst());
        return param;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        return new ArrayList<Class<? extends SJmoGetKind_IF>>(0);
    }

    @Override
    protected Comparator<Object> createObjectComparator() {
        return super.createObjectComparator();
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        this.sSTask_Status = util.getGuidance("COMMON", "TASK_STATUS");
        this.sStatus = util.getGuidance("COMMON", "STATUS");
        this.sWaiting = util.getGuidance("COMMON", "WAITING");
        this.sSuspended = util.getGuidance("COMMON", "SUSPENDED");
        this.sIn_Progress_Str = util.getGuidance("COMMON", "COMPLETED2");
        this.sIn_Progress_Par = util.getGuidance("COMMON", "PERCENT");
        this.sCompleted = util.getGuidance("COMMON", "COMPLETED");
        this.sFailed = util.getGuidance("COMMON", "FAILED");
        this.sAborted = util.getGuidance("COMMON", "ABORTED");
        this.sCompleted_Req = util.getGuidance("COMMON", "COMPLETED_REQUEST");
        super.initGuidance(util);
    }
}

