/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.volumemigration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrVolumeMigrationUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.controller.wizard.volumemigration.com.SJctrVolumeMigrationMacro;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public abstract class SJctrVMPoolCapacityColumnFromLdevDetail
extends SJctrCapacityColumn {
    public SJctrVMPoolCapacityColumnFromLdevDetail(String key) {
        super(key);
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJctrVolumeMigrationMacro.KEY_CLASS_POOL_DETAIL);
        alList.add(SJctrVolumeMigrationMacro.KEY_CLASS_HDP_RELATION);
        return alList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        ArrayList<Object> retList = new ArrayList<Object>();
        SJmoLdevDetail ldevDetail = (SJmoLdevDetail)index;
        List<SJmoPoolDetail> poolDetaillList = basicData.get(SJctrVolumeMigrationMacro.KEY_CLASS_POOL_DETAIL);
        List<SJmoHDPRelation> dpvolList = basicData.get(SJctrVolumeMigrationMacro.KEY_CLASS_HDP_RELATION);
        if (ldevDetail.getbAouVvol()) {
            SJmoPoolDetail poolDetailData = SJctrVolumeMigrationUtility.findHDPRelationData(dpvolList, poolDetaillList, ldevDetail);
            retList.add(poolDetailData);
        } else {
            retList.add(ldevDetail);
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "?";
        Object toDispData = dataList.get(0);
        if (toDispData instanceof SJmoPoolDetail) {
            strRtn = this.createVMPoolCapaString(dataList);
        } else if (toDispData instanceof SJmoLdevDetail) {
            strRtn = "-";
        }
        return strRtn;
    }

    @Override
    protected long getCylinderNumber(Map<String, Object> dat) {
        long lNum = -2L;
        Object primaryKeyObj = this.getPrimaryKeyObject(dat);
        SJmoLdevDetail ldevDetail = (SJmoLdevDetail)primaryKeyObj;
        List<SJmoPoolDetail> poolDetailList = this.getTable().getDataController().getProxy().getCache(SJctrVolumeMigrationMacro.KEY_CLASS_POOL_DETAIL);
        List<SJmoHDPRelation> dpvolList = this.getTable().getDataController().getProxy().getCache(SJctrVolumeMigrationMacro.KEY_CLASS_HDP_RELATION);
        if (ldevDetail.getbAouVvol()) {
            SJmoPoolDetail poolDetailData = SJctrVolumeMigrationUtility.findHDPRelationData(dpvolList, poolDetailList, ldevDetail);
            int iPoolEmu = poolDetailData.getEmulationType();
            SJctrComUtility comUtl = this.getTable().getComUtility();
            SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
            int iEmulation = poolUtl.changeEmulationType(iPoolEmu);
            long block = this.getNumber(dat);
            SJctrCapacityUtility capaUtil = this.getTable().getComUtility().getCapacityUtility();
            lNum = capaUtil.toCylValue(block, iEmulation);
        } else {
            lNum = SJctrPoolUtility.HAIFUN_NUM;
        }
        return lNum;
    }

    @Override
    public boolean hasMainframeVolume(Map<Class<?>, List<?>> basicData) {
        boolean brtn = false;
        List<?> list = basicData.get(SJmoGetLdevDetail.class);
        for (SJmoLdevDetail ldevDetail : list) {
            if (!ldevDetail.getbMfVolume()) continue;
            brtn = true;
            break;
        }
        return brtn;
    }

    @Override
    public boolean hasOpenVolume(Map<Class<?>, List<?>> basicData) {
        boolean brtn = false;
        List<?> list = basicData.get(SJmoGetLdevDetail.class);
        for (SJmoLdevDetail ldevDetail : list) {
            if (!ldevDetail.getbOpenVolume()) continue;
            brtn = true;
            break;
        }
        return brtn;
    }

    protected abstract String createVMPoolCapaString(List<?> var1);
}

