/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.volumemigration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrVolumeMigrationUtility;
import sanproject.sn2.controller.com.column.volumemigration.SJctrVMBasicRemainColumnFromLdevDetail;
import sanproject.sn2.controller.wizard.volumemigration.com.SJctrVolumeMigrationMacro;
import sanproject.sn2.controller.wizard.volumemigration.migratevolumes.SJctrAvailableTargetVolsData;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrVMTargetBasicRemainColumnFromLdevDetail
extends SJctrVMBasicRemainColumnFromLdevDetail {
    private String toolTip = null;

    public SJctrVMTargetBasicRemainColumnFromLdevDetail(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.toolTip = util.getGuidance("REMAINING_PREDICTED_MIN_MAX");
    }

    @Override
    protected String getHeaderTooltip() {
        return this.toolTip;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        ArrayList<Object> retList = new ArrayList<Object>();
        List<?> poolDetailList = this.getTable().getDataController().getProxy().getCache(SJctrVolumeMigrationMacro.KEY_CLASS_POOL_DETAIL);
        List<?> dpvolList = this.getTable().getDataController().getProxy().getCache(SJctrVolumeMigrationMacro.KEY_CLASS_HDP_RELATION);
        List<?> list = super.getNeedModelData(index, basicData);
        if (list.get(0) instanceof SJmoPoolDetail) {
            SJmoPoolDetail poolDetailData;
            List<?> targetVolsDataList = this.getTable().getDataController().getProxy().getCache("KEY_TARGET_VOLUMES");
            SJctrAvailableTargetVolsData targetVolsData = (SJctrAvailableTargetVolsData)targetVolsDataList.get(0);
            List latestPoolDetailList = targetVolsData.getPoolList();
            int iTarget = Collections.binarySearch(latestPoolDetailList, poolDetailData = (SJmoPoolDetail)list.get(0));
            if (0 <= iTarget) {
                Object latestPoolDetailData = latestPoolDetailList.get(iTarget);
                retList.add(poolDetailData);
                retList.add(latestPoolDetailData);
            }
        } else if (list.get(0) instanceof SJmoLdevDetail) {
            SJmoLdevDetail ldevDetail = (SJmoLdevDetail)list.get(0);
            retList.add(ldevDetail);
        }
        return retList;
    }

    @Override
    protected String createVMPoolCapaString(List<?> dataList) {
        String strRtn = "?";
        Object toDispData = dataList.get(0);
        Object toDispDataNext = dataList.get(1);
        if (toDispDataNext instanceof SJmoPoolDetail) {
            SJmoPoolDetail poolDtl = (SJmoPoolDetail)toDispData;
            SJmoPoolDetail latestPoolDtl = (SJmoPoolDetail)toDispDataNext;
            String strClmUnit = this.getUnitSelect();
            SJctrComUtility comUtl = this.getTable().getComUtility();
            SJctrVolumeMigrationUtility vmUtl = comUtl.getVmUtility();
            long lRemainCapa = SJctrVolumeMigrationUtility.toPoolBasicRemainCapa(poolDtl, SJctrCapacityUtility.UNIT.BLOCK, comUtl);
            long lLatestRemainCapa = SJctrVolumeMigrationUtility.toPoolBasicRemainCapa(latestPoolDtl, SJctrCapacityUtility.UNIT.BLOCK, comUtl);
            strRtn = SJctrVolumeMigrationUtility.toPoolBasicRemainCapacityDisplay(poolDtl, strClmUnit, comUtl);
            if (lRemainCapa != lLatestRemainCapa) {
                long lUsedPage = poolDtl.getLPoolActualUsedPages();
                long lLatestUsedPage = latestPoolDtl.getLPoolActualUsedPages();
                long lDiffPage = lLatestUsedPage - lUsedPage;
                long lMinUsedPage = lDiffPage / 16L;
                if (lDiffPage % 16L != 0L) {
                    ++lMinUsedPage;
                }
                latestPoolDtl.setLPoolActualUsedPages(poolDtl.getLPoolActualUsedPages() + lMinUsedPage);
                String strLatestPoolMaxRemainCapa = SJctrVolumeMigrationUtility.toPoolBasicRemainCapacityDisplay(latestPoolDtl, strClmUnit, comUtl);
                latestPoolDtl.setLPoolActualUsedPages(lLatestUsedPage);
                if (latestPoolDtl.getLPoolActualUsedPages() > latestPoolDtl.getLPoolActualPages()) {
                    latestPoolDtl.setLPoolActualUsedPages(latestPoolDtl.getLPoolActualPages());
                }
                String strLatestMinPoolRemainCapa = SJctrVolumeMigrationUtility.toPoolBasicRemainCapacityDisplay(latestPoolDtl, strClmUnit, comUtl);
                strRtn = strRtn + " >> " + strLatestMinPoolRemainCapa + " - " + strLatestPoolMaxRemainCapa;
                latestPoolDtl.setLPoolActualUsedPages(lLatestUsedPage);
            }
        } else {
            strRtn = "?";
        }
        return strRtn;
    }
}

