/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.profiles.common;

import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.profiles.common.BaseInstanceProvider;
import com.ws.wbem.query.fql.FQLParser;
import java.util.ArrayList;
import java.util.Arrays;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;

public abstract class BaseRegisteredProfileProvider
extends BaseInstanceProvider {
    private final String mCPVInstanceID;
    private final String mCPVRegisteredName;
    private final UnsignedInteger16 mCPVRegisteredOrg;
    private final String mCPVRegisteredVersion;
    private final UnsignedInteger16[] mCPVAdvertiseTypes;
    private final String mCPVCaption;
    private final String mCPVElementName;
    private final String mCPVDescription;
    private final String mCPVOtherOrg;

    public BaseRegisteredProfileProvider(String className, String instanceID, String registeredName, UnsignedInteger16 registeredOrg, String registeredVersion, UnsignedInteger16[] advertiseTypes, String caption, String elementName, String description) {
        this(className, instanceID, registeredName, registeredOrg, registeredVersion, advertiseTypes, caption, elementName, description, null, true);
    }

    public BaseRegisteredProfileProvider(String className, String instanceID, String registeredName, UnsignedInteger16 registeredOrg, String registeredVersion, UnsignedInteger16[] advertiseTypes, String caption, String elementName, String description, String otherOrgName, boolean branded) {
        this.mClassName = branded ? JServerSettings.replaceSchemaClassName(className) : className;
        this.mCPVInstanceID = instanceID;
        this.mCPVRegisteredName = registeredName;
        this.mCPVRegisteredOrg = registeredOrg;
        this.mCPVRegisteredVersion = registeredVersion;
        this.mCPVAdvertiseTypes = advertiseTypes;
        this.mCPVCaption = caption;
        this.mCPVElementName = elementName;
        this.mCPVDescription = description;
        this.mCPVOtherOrg = otherOrgName;
    }

    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError) throws WBEMException {
        this.checkArguments(op, WBEMOperation.OPENENUMERATEINSTANCES, filterQueryLanguage, filterQuery, continueOnError);
        ArrayList<CIMInstance> instances = new ArrayList<CIMInstance>();
        CIMInstance inst = this.generateInstance(op, false, false, propertyList, FQLParser.getFQLParser((String)filterQueryLanguage, (String)filterQuery, (CIMObjectPath)op, (WBEMOperation)WBEMOperation.OPENENUMERATEINSTANCES));
        if (null != inst) {
            instances.add(inst);
        }
        return new CloseableAddableIterator(instances);
    }

    private CIMInstance generateInstance(CIMObjectPath target, boolean localOnly, boolean includeClassOrigin, String[] propertyList, FQLParser fqlParser) throws WBEMException {
        CIMProperty<?>[] keyProps = this.getKeyPropertyArray(this.mCPVRegisteredVersion);
        ArrayList<Object> props = new ArrayList<Object>();
        props.add(keyProps[0]);
        props.add(new CIMProperty("RegisteredName", CIMDataType.STRING_T, (Object)this.mCPVRegisteredName, false));
        props.add(new CIMProperty("RegisteredOrganization", CIMDataType.UINT16_T, (Object)this.mCPVRegisteredOrg, false));
        props.add(new CIMProperty("RegisteredVersion", CIMDataType.STRING_T, (Object)this.mCPVRegisteredVersion, false));
        props.add(new CIMProperty("AdvertiseTypes", CIMDataType.UINT16_ARRAY_T, (Object)this.mCPVAdvertiseTypes, false));
        props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)this.mCPVCaption, false));
        props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)this.mCPVElementName, false));
        props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)this.mCPVDescription, false));
        props.add(new CIMProperty("OtherRegisteredOrganization", CIMDataType.STRING_T, (Object)this.mCPVOtherOrg, false));
        CIMProperty<?>[] addtionalProps = this.getAdditionalProperties(target, propertyList, this.mCPVRegisteredVersion);
        if (null != addtionalProps && addtionalProps.length > 0) {
            props.addAll(Arrays.asList(addtionalProps));
        }
        CIMInstance ci = new CIMInstance(this.generateObjectPath(target, this.mCPVRegisteredVersion), props.toArray(new CIMProperty[props.size()])).filterProperties(propertyList);
        if (null == fqlParser || fqlParser.evaluate(ci)) {
            return ci;
        }
        return null;
    }

    private CIMObjectPath generateObjectPath(CIMObjectPath target, String version) {
        return new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), JServerProperties.getInteropNamespace(), this.mClassName, this.getKeyPropertyArray(version));
    }

    public CIMProperty<?>[] getAdditionalProperties(CIMObjectPath target, String[] propertyList, String registeredVersion) {
        return new CIMProperty[0];
    }

    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        CIMInstance i = this.generateInstance(op, false, false, propertyList, null);
        if (i.getObjectPath().equalsModelPath(op)) {
            return i;
        }
        throw WBEMOperationErrors.getInstanceNotFoundException((CIMObjectPath)op, (WBEMOperation)WBEMOperation.GETINSTANCE, null);
    }

    private CIMProperty<?>[] getKeyPropertyArray(String version) {
        String instanceID = String.format("%s:%s", this.mCPVInstanceID, version);
        CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)instanceID, true)};
        return keyProps;
    }
}

