/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.profiles.dmtf.simpleidentity;

import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.AuthService;
import com.ws.wbem.jserver.AuthServiceType;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSecurityAdapterFactory;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.profiles.common.GenericReadOnlyProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.provider.ProviderHandle;

public class AccountProvider
extends GenericReadOnlyProvider {
    private AuthService mAuthService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void deleteInstance(CIMObjectPath target) throws WBEMException {
        if (this.mAuthService.getType() != AuthServiceType.ACCOUNTS) throw WBEMOperationErrors.getOperationNotSupportedByProviderException((CIMObjectPath)target, (WBEMOperation)WBEMOperation.DELETEINSTANCE, (String)target.getObjectName());
        CIMInstance accountInstance = mInternalProvider.getInstance(this.cleanSystemName(target), null);
        CloseableIterator<CIMInstance> ci = this.enumerateInstances(target, null, null, null, false);
        if (null == ci || !ci.hasNext()) return;
        ci.next();
        if (ci.hasNext()) {
            mInternalProvider.deleteInstance(this.cleanSystemName(target));
            try {
                String id = (String)accountInstance.getPropertyValue("UserID");
                if ("jserveradmin".equals(id)) return;
                CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)(JServerProperties.getSchemaName() + ":" + id), true)};
                CIMObjectPath identityInstance = new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), target.getNamespace(), JServerSettings.replaceSchemaClassName("WS_Identity"), keyProps);
                mInternalProvider.deleteInstance(identityInstance);
                return;
            }
            catch (WBEMException e) {
                mLogger.log(Level.WARNING, "Delete instance was successful for account, but could not delete the identity instance, this will not cause any ill effects", e);
            }
            return;
        } else {
            String info = "You can not delete the last account. One account is requried to be configured!";
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)"You can not delete the last account. One account is requried to be configured!", (WBEMOperation)WBEMOperation.DELETEINSTANCE, null);
        }
    }

    @Override
    public synchronized CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError) throws WBEMException {
        if (this.mAuthService.getType() == AuthServiceType.ACCOUNTS) {
            return super.enumerateInstances(op, propertyList, filterQueryLanguage, filterQuery, continueOnError);
        }
        return new CloseableAddableIterator(Collections.emptyList());
    }

    @Override
    public synchronized CloseableIterator<CIMInstance> execQuery(CIMObjectPath op, String query, String ql) throws WBEMException {
        if (this.mAuthService.getType() == AuthServiceType.ACCOUNTS) {
            return super.execQuery(op, query, ql);
        }
        return new CloseableAddableIterator(Collections.emptyList());
    }

    @Override
    public synchronized CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        if (this.mAuthService.getType() == AuthServiceType.ACCOUNTS) {
            return super.getInstance(this.cleanSystemName(op), propertyList);
        }
        throw WBEMOperationErrors.getInstanceNotFoundException((CIMObjectPath)op, (WBEMOperation)WBEMOperation.GETINSTANCE, null);
    }

    @Override
    public void initialize(ProviderHandle cimom) throws WBEMException {
        super.initialize(cimom);
        this.mClassName = JServerSettings.replaceSchemaClassName("CIM_Account");
        this.mAuthService = JServerSecurityAdapterFactory.getAdapter();
    }

    @Override
    public synchronized void modifyInstance(CIMInstance target, String[] propertyList) throws WBEMException {
        if (this.mAuthService.getType() == AuthServiceType.ACCOUNTS) {
            mInternalProvider.modifyInstance(this.cleanSystemName(target), propertyList);
            return;
        }
        throw WBEMOperationErrors.getOperationNotSupportedByProviderException((CIMObjectPath)target.getObjectPath(), (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)target.getClassName());
    }

    @Override
    public CIMInstance verifyInstance(CIMInstance i) {
        CIMInstance ci = i.deriveInstance(this.verifyObjectPath(i.getObjectPath()));
        CIMProperty p = new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)this.getHostName(), true);
        String[] userPassword = new String[]{};
        CIMProperty pass = new CIMProperty("UserPassword", CIMDataType.STRING_ARRAY_T, (Object)userPassword, true);
        ci = ci.deriveInstance(new CIMProperty[]{p, pass});
        return ci;
    }

    public CIMObjectPath verifyObjectPath(CIMObjectPath op) {
        CIMProperty[] keys;
        ArrayList<CIMProperty> keyList = new ArrayList<CIMProperty>();
        for (CIMProperty key : keys = op.getKeys()) {
            if (key.getName().equalsIgnoreCase("SystemName")) {
                keyList.add(new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)this.getHostName(), true));
                continue;
            }
            keyList.add(key);
        }
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), op.getObjectName(), keyList.toArray(new CIMProperty[keyList.size()]));
    }
}

