/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.profiles.dmtf.wbemserver;

import com.ws.wbem.IndicationManager;
import com.ws.wbem.IndicationType;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.embed.EndPoint;
import com.ws.wbem.jserver.embed.Protocol;
import com.ws.wbem.jserver.profiles.common.BaseInstanceProvider;
import com.ws.wbem.jserver.profiles.common.EnabledDefault;
import com.ws.wbem.jserver.profiles.common.EnabledState;
import com.ws.wbem.jserver.profiles.common.ProtocolIFType;
import com.ws.wbem.jserver.profiles.common.StateChange;
import com.ws.wbem.jserver.services.ProtocolServiceService;
import com.ws.wbem.query.fql.FQLParser;
import java.util.UUID;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTimeInterval;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.provider.ProviderHandle;

public abstract class TCPProtocolEndpointProvider
extends BaseInstanceProvider {
    private IndicationManager mIndicationFactory;
    static final ProtocolServiceService mProtocolService = ProtocolServiceService.getService();
    private String mProtocolName;

    public static String generateNameValue(String protocolName, String protocolIFType) {
        return JServerProperties.getSchemaName() + ":" + protocolName + ":" + protocolIFType + ":" + UUID.randomUUID().toString();
    }

    public static CIMInstance generateTCPProtocolEndpointInstance(CIMObjectPath op1, Protocol protocol, EndPoint endpoint, EnabledState enabledState) throws WBEMException {
        EnabledDefault enabledDefault = EnabledDefault.getEnabledDefault(endpoint.getEnabledDefault());
        String bindToAddress = null != endpoint.getBoundToAddress() ? endpoint.getBoundToAddress().getHostAddress() : null;
        String protocolName = protocol.getProtocolName();
        String nameFormat = JServerProperties.getSchemaName() + ":Protocol:ProtocolIFType:UUID";
        String description = JServerProperties.getSchemaName() + " " + protocol.getProtocolName() + " TCP Protocol Endpoint";
        CIMObjectPath opRet = TCPProtocolEndpointProvider.generateTCPProtocolEndpointObjectPath(op1, protocolName, endpoint.getName());
        CIMProperty[] keyProps = opRet.getKeys();
        ProtocolIFType protocolIFType = ProtocolIFType.getProtocolIFType(endpoint.getScheme());
        if (null == protocolIFType) {
            throw new WBEMException(1);
        }
        protocolIFType.getValue();
        CIMProperty[] props = new CIMProperty[]{keyProps[0], keyProps[1], keyProps[2], keyProps[3], new CIMProperty("PortNumber", CIMDataType.UINT32_T, (Object)new UnsignedInteger32((long)endpoint.getPort()), false), new CIMProperty("ProtocolIFType", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(protocolIFType.getValue()), false), new CIMProperty("ProtocolType", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(27), false), new CIMProperty("NameFormat", CIMDataType.STRING_T, (Object)nameFormat, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)description, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(enabledState.getValue()), false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(enabledDefault.getValue()), false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false), new CIMProperty("BindToAddress", CIMDataType.STRING_T, (Object)bindToAddress, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(2)}, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)description, false)};
        return new CIMInstance(opRet, props);
    }

    public static CIMObjectPath generateTCPProtocolEndpointObjectPath(CIMObjectPath op, String protocolName, String name) throws WBEMException {
        String creationClassName = null;
        switch (protocolName) {
            case "CIM-RS": {
                creationClassName = JServerSettings.replaceSchemaClassName("WS_CIMRSProtocolEndpoint");
                break;
            }
            case "CIM-XML": {
                creationClassName = JServerSettings.replaceSchemaClassName("WS_CIMXMLProtocolEndpoint");
                break;
            }
            case "WS-Management": {
                creationClassName = JServerSettings.replaceSchemaClassName("WS_WSManagementProtocolEndpoint");
                break;
            }
            default: {
                creationClassName = JServerSettings.replaceSchemaClassName("WS_CIMXMLProtocolEndpoint");
            }
        }
        CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty("Name", CIMDataType.STRING_T, (Object)name, true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)JServerSettings.replaceSchemaClassName("WS_WBEMServerSystem"), true), new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)creationClassName, true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)JServerProperties.getServerHost(), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), JServerProperties.getInteropNamespace(), creationClassName, keyProps);
    }

    @Override
    public void activateFilter(CIMInstance filter, CIMInstance listenerDestination, CIMInstance subscription) throws WBEMException {
        this.mIndicationFactory.activateFilter(filter, subscription);
    }

    @Override
    public void authorizeFilter(CIMInstance filter, CIMInstance listenerDestination, CIMInstance subscription) throws WBEMException {
        this.mIndicationFactory.authorizeFilter(filter);
    }

    @Override
    public void deActivateFilter(CIMInstance filter, CIMInstance listenerDestination, CIMInstance subscription) throws WBEMException {
        this.mIndicationFactory.deactivateFilter(filter, subscription);
    }

    @Override
    public synchronized void deleteInstance(CIMObjectPath opTCPProtocolEndpoint) throws WBEMException {
        mProtocolService.removeTCPProtocolEndpoint(opTCPProtocolEndpoint);
    }

    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath target, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError) throws WBEMException {
        this.checkArguments(target, WBEMOperation.OPENENUMERATEINSTANCES, filterQueryLanguage, filterQuery, continueOnError);
        FQLParser fqlParser = FQLParser.getFQLParser((String)filterQueryLanguage, (String)filterQuery, (CIMObjectPath)target, (WBEMOperation)WBEMOperation.OPENENUMERATEINSTANCES);
        return mProtocolService.getProtocolEndpointInstances(target, this.mProtocolName, fqlParser, propertyList);
    }

    public abstract String getClassName();

    public CIMInstance getInstance(CIMObjectPath target, String[] propertyList) throws WBEMException {
        try {
            CIMInstance inst = mProtocolService.getTCPProtocolEndpointInstance(target);
            return inst.filterProperties(propertyList);
        }
        catch (WBEMException we) {
            if (6 == we.getID()) {
                throw WBEMOperationErrors.getInstanceNotFoundException((CIMObjectPath)target, (WBEMOperation)WBEMOperation.GETINSTANCE, null);
            }
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)we.getMessage(), (WBEMOperation)WBEMOperation.GETINSTANCE, null);
        }
    }

    public abstract String getProtocolName();

    @Override
    public void initialize(ProviderHandle handle) throws WBEMException {
        super.initialize(handle);
        this.mClassName = this.getClassName();
        this.mProtocolName = this.getProtocolName();
        this.mIndicationFactory = new IndicationManager(handle, this.mClassName);
        this.mIndicationFactory.addEnabledIndicationType(IndicationType.InstanceCreation);
        this.mIndicationFactory.addEnabledIndicationType(IndicationType.InstanceDeletion);
        this.mIndicationFactory.addEnabledIndicationType(IndicationType.InstanceModification);
        mProtocolService.addIndicationFactory(this.mClassName.toLowerCase(), this.mIndicationFactory);
    }

    @Override
    public Object invokeMethod(CIMObjectPath opTCPProtocolEndpoint, String methodName, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        int ret;
        block29: {
            ret = 0;
            if ("RequestStateChange".equals(methodName)) {
                Object[] objs;
                StateChange requestedState = null;
                UnsignedInteger16 cpvRequestedState = null;
                CIMDateTimeInterval timeoutPeriod = null;
                for (CIMArgument<?> inArg : inArgs) {
                    if ("RequestedState".equals(inArg.getName())) {
                        cpvRequestedState = (UnsignedInteger16)inArg.getValue();
                        requestedState = StateChange.getStateChange(cpvRequestedState.intValue());
                        continue;
                    }
                    if (!"TimeoutPeriod".equals(inArg.getName())) continue;
                    timeoutPeriod = (CIMDateTimeInterval)inArg.getValue();
                }
                if (null != timeoutPeriod && timeoutPeriod.getTotalMilliseconds() > 0L) {
                    objs = new Object[]{methodName};
                    mLogger.log(Level.WARNING, "{0}: The TimeoutPeriod argument is not supported", objs);
                    ret = 4098;
                } else if (null == requestedState) {
                    objs = new Object[]{methodName};
                    mLogger.log(Level.WARNING, "{0}: The RequestedState argument was null.", objs);
                    ret = 5;
                } else if (StateChange.Enabled == requestedState || StateChange.Disabled == requestedState) {
                    try {
                        mProtocolService.setProtocolEndpointEnabledState(opTCPProtocolEndpoint, requestedState, false);
                    }
                    catch (WBEMException we) {
                        if (7 == we.getID()) {
                            Object[] objs2 = new Object[]{methodName};
                            mLogger.log(Level.WARNING, "{0}: This method is not supported", objs2);
                            ret = 1;
                            break block29;
                        }
                        Object[] objs3 = new Object[]{methodName, opTCPProtocolEndpoint, requestedState.toString(), we.toString()};
                        mLogger.log(Level.WARNING, "{0}: Caught exception trying to set TCPProtocolEndpoint, {1}, to {2}\n{3}", objs3);
                        ret = 4;
                    }
                } else if (StateChange.Reset == requestedState) {
                    try {
                        mProtocolService.setProtocolEndpointEnabledState(opTCPProtocolEndpoint, StateChange.Disabled, false);
                        try {
                            mProtocolService.setProtocolEndpointEnabledState(opTCPProtocolEndpoint, StateChange.Enabled, false);
                        }
                        catch (WBEMException we) {
                            if (7 == we.getID()) {
                                Object[] objs4 = new Object[]{methodName};
                                mLogger.log(Level.WARNING, "{0}: This method is not supported", objs4);
                                ret = 1;
                                break block29;
                            }
                            Object[] objs5 = new Object[]{methodName, opTCPProtocolEndpoint, we.toString()};
                            mLogger.log(Level.WARNING, "{0}: Caught exception trying to start the TCPProtocolEndpoint:{1}\n{2}", objs5);
                            ret = 4;
                        }
                    }
                    catch (WBEMException we) {
                        if (7 == we.getID()) {
                            Object[] objs6 = new Object[]{methodName};
                            mLogger.log(Level.WARNING, "{0}: This method is not supported", objs6);
                            ret = 1;
                            break block29;
                        }
                        Object[] objs7 = new Object[]{methodName, opTCPProtocolEndpoint, we.toString()};
                        mLogger.log(Level.WARNING, "{0}: Caught exception trying to stop the TCPProtocolEndpoint:{1}\n{2}", objs7);
                        ret = 4;
                    }
                } else {
                    objs = new Object[]{methodName, cpvRequestedState};
                    mLogger.log(Level.WARNING, "{0}: The RequestedState argument value ({1}) was invalid", objs);
                    ret = 5;
                }
            } else if ("BindTo".equals(methodName)) {
                CIMObjectPath opIPEndpoint = null;
                for (CIMArgument<?> inArg : inArgs) {
                    if (!"IPEndpoint".equals(inArg.getName())) continue;
                    opIPEndpoint = (CIMObjectPath)inArg.getValue();
                }
                if (null == opIPEndpoint) {
                    Object[] objs = new Object[]{methodName};
                    mLogger.log(Level.WARNING, "{0}: The IPProtocolEndpoint argument was null", objs);
                    ret = 4;
                } else {
                    try {
                        mProtocolService.setTCPProtocolEndpointBindToAddress(opTCPProtocolEndpoint, opIPEndpoint);
                    }
                    catch (WBEMException we) {
                        if (7 == we.getID()) {
                            Object[] objs = new Object[]{methodName};
                            mLogger.log(Level.WARNING, "{0}: This method is not supported", objs);
                            ret = 1;
                            break block29;
                        }
                        ret = 4;
                    }
                }
            } else {
                throw WBEMOperationErrors.getMethodNotSupportedException((CIMObjectPath)opTCPProtocolEndpoint, (String)methodName, (WBEMOperation)WBEMOperation.INVOKEMETHOD);
            }
        }
        return new UnsignedInteger32((long)ret);
    }

    @Override
    public void modifyInstance(CIMInstance ci, String[] propertyList) throws WBEMException {
        mProtocolService.modifyTCPProtocolEndpoint(ci, propertyList);
    }
}

