/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.profiles.dmtf.wbemserver;

import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.profiles.common.BaseSingletonInstanceProvider;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;

public class WBEMServerSystemProvider
extends BaseSingletonInstanceProvider {
    private static final String CPV_ELEMENTNAME = JServerProperties.getSchemaName() + " WBEM Server System";
    private CIMDateTime mCPVInstallDate = null;

    @Override
    protected CIMInstance generateInstance(CIMObjectPath target) {
        CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty("Name", CIMDataType.STRING_T, (Object)this.getHostName(), true), new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)this.mClassName, true)};
        UnsignedInteger16[] ops = new UnsignedInteger16[]{new UnsignedInteger16(2)};
        ArrayList<CIMProperty> propList = new ArrayList<CIMProperty>();
        propList.add(keyProps[0]);
        propList.add(keyProps[1]);
        propList.add(new CIMProperty("NameFormat", CIMDataType.STRING_T, (Object)"IP", false));
        propList.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)CPV_ELEMENTNAME, false));
        propList.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)CPV_ELEMENTNAME, false));
        propList.add(new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false));
        propList.add(new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(2), false));
        propList.add(new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false));
        propList.add(new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)ops, false));
        if (null != this.mCPVInstallDate) {
            propList.add(new CIMProperty("InstallDate", CIMDataType.DATETIME_T, (Object)this.mCPVInstallDate, false));
        }
        CIMObjectPath op = new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), JServerProperties.getInteropNamespace(), this.mClassName, keyProps);
        return new CIMInstance(op, propList.toArray(new CIMProperty[propList.size()]));
    }

    @Override
    public void initialize(ProviderHandle ch) throws WBEMException {
        super.initialize(ch);
        this.mClassName = JServerSettings.replaceSchemaClassName("WS_WBEMServerSystem");
        String installDate = JServerProperties.getInstallDate();
        if (null != installDate && installDate.length() > 0) {
            try {
                this.mCPVInstallDate = new CIMDateTimeAbsolute(installDate);
            }
            catch (IllegalArgumentException e) {
                Object[] objs = new Object[]{installDate};
                mLogger.log(Level.WARNING, "InstallDate value, {0}, in jserver.properties file is an invalid CIMDateTime value.  This value will be ignored", objs);
            }
        }
    }
}

