/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.services;

import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.ClientProtocolAdapter;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.ProtocolServiceFactory;
import com.ws.wbem.jserver.WBEMServer;
import com.ws.wbem.jserver.embed.JWBEMServerProtocolData;
import com.ws.wbem.jserver.embed.Protocol;
import com.ws.wbem.jserver.embed.RequestHandler;
import com.ws.wbem.jserver.profiles.common.EnabledDefault;
import com.ws.wbem.jserver.profiles.common.ProtocolIFType;
import com.ws.wbem.jserver.profiles.common.WSBaseProvider;
import com.ws.wbem.jserver.profiles.dmtf.wbemserver.ProtocolServiceProvider;
import com.ws.wbem.jserver.services.JServerEndpointHTTP;
import com.ws.wbem.jserver.services.JServerProtocol;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.cim.CIMClass;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;

public class JServerProtocolData
extends WSBaseProvider
implements JWBEMServerProtocolData {
    static final String IPADDRESS = "ipaddress";
    static final String EXCLUSIVE = "exclusive";
    public final ConcurrentHashMap<String, PropFileInfo> mPropInfoMap;
    private final WBEMServer mServer;

    public JServerProtocolData(ProviderHandle handle, WBEMServer server) throws WBEMException {
        this.mServer = server;
        this.mPropInfoMap = new ConcurrentHashMap();
        this.processPropFile();
        this.initialize(handle);
    }

    private void addProtocolEndpoints(ClientProtocolAdapter protocolAdapter, JServerProtocol jserverProtocol, CIMObjectPath opProtocolService) {
        try {
            CloseableIterator<CIMInstance> iterTCPProtocolEndpoints = this.getAssocatedTCPProtocolInstances(opProtocolService);
            while (iterTCPProtocolEndpoints.hasNext()) {
                CIMInstance instTCPProtocolEndpoint = (CIMInstance)iterTCPProtocolEndpoints.next();
                CIMObjectPath opTCPProtocolEndpoint = instTCPProtocolEndpoint.getObjectPath();
                UnsignedInteger16 cpvProtocolIFType = (UnsignedInteger16)instTCPProtocolEndpoint.getPropertyValue("ProtocolIFType");
                if (null == cpvProtocolIFType) {
                    Object[] objs = new Object[]{instTCPProtocolEndpoint.getObjectPath()};
                    mLogger.log(Level.WARNING, "TCPProtocolEndpoint {0} has a null ProtocolIFType Property.  This endpoint will not be started", objs);
                    continue;
                }
                ProtocolIFType protocolIFType = ProtocolIFType.getProtocolIFType(cpvProtocolIFType.intValue());
                if (null == protocolIFType) {
                    Object[] objs = new Object[]{opTCPProtocolEndpoint, cpvProtocolIFType};
                    mLogger.log(Level.WARNING, "TCPProtocolEndpoint {0} has an invalid ProtocolIFType property value, {1}.  This endpoint will not be started", objs);
                    continue;
                }
                String propFileInfoKey = this.createPropFileKey(protocolAdapter.getProtocolName(), protocolIFType.getName());
                PropFileInfo propFileInfo = this.mPropInfoMap.get(propFileInfoKey);
                UnsignedInteger16 cpvEnabledDefault = (UnsignedInteger16)instTCPProtocolEndpoint.getPropertyValue("EnabledDefault");
                EnabledDefault enabledDefault = null != cpvEnabledDefault ? EnabledDefault.getEnabledDefault(cpvEnabledDefault.intValue()) : EnabledDefault.Enabled;
                String cpvName = (String)instTCPProtocolEndpoint.getPropertyValue("Name");
                UnsignedInteger32 cpvPort = (UnsignedInteger32)instTCPProtocolEndpoint.getPropertyValue("PortNumber");
                if (null == cpvPort) {
                    Object[] objs = new Object[]{opTCPProtocolEndpoint};
                    mLogger.log(Level.WARNING, "TCPProtocolEndpoint {0} has a null PortNumber Property.  This endpoint will not be started", objs);
                    continue;
                }
                String bindToAddress = (String)instTCPProtocolEndpoint.getPropertyValue("BindToAddress");
                InetAddress boundedInetAddress = null;
                try {
                    boundedInetAddress = null != bindToAddress ? InetAddress.getByName(bindToAddress) : null;
                }
                catch (UnknownHostException e) {
                    Object[] objs = new Object[]{opTCPProtocolEndpoint, bindToAddress};
                    mLogger.log(Level.WARNING, "Could not bind TCPProtocolEndpoint {0} to IPAddress {1} because there is no IPProtocolEndpoint with that IP Address.  Will bind to all available IP Addresses", objs);
                    continue;
                }
                EnabledDefault newEnabledDefault = null;
                InetAddress newInetAddress = null;
                if (null != propFileInfo) {
                    int propFilePort = propFileInfo.getPort();
                    InetAddress propFileInetAddress = propFileInfo.getIPAddress();
                    if (-1 != propFilePort) {
                        if (propFilePort == cpvPort.intValue()) {
                            propFileInfo.setExists();
                            if (enabledDefault != EnabledDefault.Enabled) {
                                newEnabledDefault = EnabledDefault.Enabled;
                                enabledDefault = EnabledDefault.Enabled;
                                if (null != propFileInetAddress && !propFileInetAddress.equals(boundedInetAddress)) {
                                    newInetAddress = propFileInetAddress;
                                    boundedInetAddress = propFileInetAddress;
                                }
                            }
                        } else if (propFileInfo.isExclusive() && enabledDefault != EnabledDefault.Disabled) {
                            newEnabledDefault = EnabledDefault.Disabled;
                            enabledDefault = EnabledDefault.Disabled;
                        }
                    } else if (null != propFileInetAddress) {
                        if (!propFileInetAddress.equals(boundedInetAddress)) {
                            newInetAddress = propFileInetAddress;
                            boundedInetAddress = propFileInetAddress;
                        }
                    } else if (propFileInfo.isExclusive()) {
                        newEnabledDefault = EnabledDefault.Disabled;
                        enabledDefault = EnabledDefault.Disabled;
                    }
                }
                try {
                    boolean enable = null != newEnabledDefault ? newEnabledDefault == EnabledDefault.Enabled : enabledDefault == EnabledDefault.Enabled;
                    boundedInetAddress = null != newInetAddress ? newInetAddress : boundedInetAddress;
                    JServerEndpointHTTP endpoint = new JServerEndpointHTTP(protocolAdapter, cpvName, cpvPort.intValue(), protocolIFType, protocolAdapter.getProtocolName(), boundedInetAddress, enable, mHandle);
                    ArrayList<CIMProperty> propList = new ArrayList<CIMProperty>();
                    ArrayList<String> propNameList = new ArrayList<String>();
                    if (null != newEnabledDefault) {
                        propList.add(new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(newEnabledDefault.getValue())));
                        propNameList.add("EnabledDefault");
                    }
                    if (null != newInetAddress) {
                        propList.add(new CIMProperty("BindToAddress", CIMDataType.STRING_T, (Object)newInetAddress.getHostName()));
                        propNameList.add("BindToAddress");
                    }
                    if (!propList.isEmpty()) {
                        CIMInstance newInstance = this.deriveInstance(instTCPProtocolEndpoint, propList.toArray(new CIMProperty[propList.size()]));
                        try {
                            mInternalProvider.modifyInstance(newInstance, propNameList.toArray(new String[propNameList.size()]));
                        }
                        catch (WBEMException we) {
                            mLogger.log(Level.WARNING, "Could not modify instance of TCPProtocolEndpoint, {0}, with values from tcppe.properties file");
                        }
                    }
                    if (enable) {
                        endpoint.startEndpoint();
                    }
                    jserverProtocol.addEndpoint(endpoint);
                }
                catch (Exception e) {
                    Object[] objs = new Object[]{instTCPProtocolEndpoint.getObjectPath(), e.getMessage()};
                    mLogger.log(Level.SEVERE, "Could not initialize Protocol Endpoint {0}.\n{1}", objs);
                }
            }
            Enumeration<PropFileInfo> enumPropInfo = this.mPropInfoMap.elements();
            while (enumPropInfo.hasMoreElements()) {
                PropFileInfo propFileInfo = enumPropInfo.nextElement();
                if (!propFileInfo.getProtocol().equals(jserverProtocol.getProtocolName()) || propFileInfo.exists()) continue;
                jserverProtocol.startEndpoint(propFileInfo.getPort(), propFileInfo.getProtocolIFType().getName(), propFileInfo.getIPAddress());
            }
        }
        catch (WBEMException we) {
            Object[] objs = new Object[]{opProtocolService, we.getMessage()};
            mLogger.log(Level.SEVERE, "Caught exception trying to get supported protocols:{0}", objs);
        }
    }

    private String createPropFileKey(String protocol, String scheme) {
        return protocol.toLowerCase() + "." + scheme.toLowerCase() + ".";
    }

    private CloseableIterator<CIMInstance> getAssocatedTCPProtocolInstances(CIMObjectPath opProtocolService) throws WBEMException {
        CloseableAddableIterator ret = null;
        CloseableIterator<CIMClass> iter = mInternalProvider.associatorClasses(opProtocolService, "CIM_ServiceAccessBySAP", "CIM_TCPProtocolEndpoint", "Antecedent", "Dependent", false);
        if (iter.hasNext()) {
            CIMObjectPath opTCPProtocolEndpoint = new CIMObjectPath(null, null, null, opProtocolService.getNamespace(), ((CIMClass)iter.next()).getName(), null);
            ret = mInternalProvider.enumerateInstances(opTCPProtocolEndpoint, null, null, null, false);
        } else {
            ret = new CloseableAddableIterator(Collections.emptyList());
        }
        return ret;
    }

    public Protocol[] getSupportedProtocols() {
        ArrayList<JServerProtocol> protocolList = new ArrayList<JServerProtocol>();
        Enumeration<String> enumProtocols = ProtocolServiceFactory.getProtocolList();
        while (enumProtocols.hasMoreElements()) {
            String protocol = enumProtocols.nextElement();
            try {
                CIMObjectPath op = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), "", null);
                CIMObjectPath opProtocolService = ProtocolServiceProvider.generateProtocolServiceObjectPath(op, protocol);
                ClientProtocolAdapter protocolAdapter = ProtocolServiceFactory.getProtocolAdapter(protocol);
                protocolAdapter.initialize(this.mServer);
                JServerProtocol jserverProtocol = new JServerProtocol(protocol, true, mHandle, this.mServer, protocolAdapter);
                this.addProtocolEndpoints(protocolAdapter, jserverProtocol, opProtocolService);
                protocolList.add(jserverProtocol);
            }
            catch (WBEMException we) {
                Object[] objs = new Object[]{protocol, we.getMessage()};
                mLogger.log(Level.SEVERE, "Could not initialize ProtocolService {0} because there was an error getting the associated protocolEndpoints: {1}", objs);
            }
        }
        return protocolList.toArray(new JServerProtocol[protocolList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFile() {
        Properties props = null;
        FileInputStream inputStream = null;
        String propFilename = JServerProperties.getPropertiesDirectory() + File.separator + "tcppe.properties";
        try {
            inputStream = new FileInputStream(propFilename);
            props = new Properties();
            props.load(inputStream);
        }
        catch (Exception e) {
            props = null;
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (Exception e1) {}
            }
        }
        if (null != props) {
            File origFile = new File(propFilename);
            File renamedFile = null;
            try {
                String newPropFilename;
                for (int i = 0; i < 1000 && (renamedFile = new File(newPropFilename = propFilename + "." + i)).exists(); ++i) {
                    renamedFile = null;
                }
                if (null != renamedFile) {
                    origFile.renameTo(renamedFile);
                } else {
                    Object[] objs = new Object[]{propFilename};
                    mLogger.log(Level.WARNING, "Could not rename TCPProtocolProperties file: {0}", objs);
                }
            }
            catch (Throwable th) {
                String renamedFilename = null != renamedFile ? renamedFile.getAbsolutePath() : "null";
                Object[] objs = new Object[]{propFilename, renamedFilename, th.toString()};
                mLogger.log(Level.WARNING, "Caught exception trying to rename TCPProtocolProperties file {0} to {1}\n{2} ", objs);
            }
        }
        return props;
    }

    private void processPropFile() {
        Properties propFile = this.loadPropertiesFile();
        if (null != propFile) {
            Enumeration<String> enumProtocols = ProtocolServiceFactory.getProtocolList();
            while (enumProtocols.hasMoreElements()) {
                String protocol = enumProtocols.nextElement();
                for (ProtocolIFType protocolIFType : ProtocolIFType.values()) {
                    String id = this.createPropFileKey(protocol, protocolIFType.getName());
                    String portPropName = id + "PortNumber".toLowerCase();
                    String ipAddressPropName = id + IPADDRESS;
                    String exclusivePropName = id + EXCLUSIVE;
                    String portString = propFile.getProperty(portPropName);
                    String ipAddress = propFile.getProperty(ipAddressPropName);
                    String exclusive = propFile.getProperty(exclusivePropName);
                    int port = -1;
                    if (null != portString) {
                        try {
                            port = Integer.parseInt(portString);
                        }
                        catch (NumberFormatException nfe) {
                            Object[] objs = new Object[]{portPropName, portString};
                            mLogger.log(Level.SEVERE, "Error reading values from TCPProtocolEndpoint properties file. The value of {0} was {1} but that is not a valid Integer value", objs);
                            port = -1;
                            ipAddress = null;
                        }
                    }
                    InetAddress inetAddress = null;
                    if (null != ipAddress) {
                        try {
                            inetAddress = InetAddress.getByName(ipAddress);
                        }
                        catch (UnknownHostException e) {
                            Object[] objs = new Object[]{ipAddressPropName, ipAddress};
                            mLogger.log(Level.SEVERE, "Error reading values from TCPProtocolEndpoint properties file. The value of {0} was {1} but there is not an instances of IPProtocolEndpoint with that IPAddress.  Ignoring that value.", objs);
                        }
                    }
                    if (-1 == port && null == inetAddress && null == exclusive) continue;
                    PropFileInfo propFileInfo = new PropFileInfo(protocol, protocolIFType, port, inetAddress, null != exclusive);
                    this.mPropInfoMap.put(id, propFileInfo);
                }
            }
        }
    }

    public void setParser(String protocol, RequestHandler handler) {
    }

    private class PropFileInfo {
        private final InetAddress mIPAddress;
        private final ProtocolIFType mProtocolIFType;
        private final String mProtocol;
        private final int mPort;
        private final boolean mExclusive;
        private boolean mExists;

        public PropFileInfo(String protocol, ProtocolIFType protocolIFType, int port, InetAddress ipAddress, boolean exclusive) {
            this.mProtocolIFType = protocolIFType;
            this.mProtocol = protocol;
            this.mPort = port;
            this.mIPAddress = ipAddress;
            this.mExclusive = exclusive;
            this.mExists = false;
        }

        public boolean exists() {
            return this.mExists;
        }

        public InetAddress getIPAddress() {
            return this.mIPAddress;
        }

        public int getPort() {
            return this.mPort;
        }

        public String getProtocol() {
            return this.mProtocol;
        }

        public ProtocolIFType getProtocolIFType() {
            return this.mProtocolIFType;
        }

        public boolean isExclusive() {
            return this.mExclusive;
        }

        private void setExists() {
            this.mExists = true;
        }
    }
}

