/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim;

import com.ws.cim.CIMMapping;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class CIMMappingBase
implements CIMMapping {
    private List<File> getFileListing(File aStartingDir, String[] remove) {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        for (File file : filesDirs) {
            if (file.isDirectory()) {
                List<File> deeperList = this.getFileListing(file, remove);
                result.addAll(deeperList);
                continue;
            }
            boolean x = false;
            for (String e : remove) {
                if (e.endsWith(".") && file.getName().startsWith(e)) {
                    x = true;
                    continue;
                }
                if (e.startsWith(".") && file.getName().endsWith(e)) {
                    x = true;
                    continue;
                }
                if (!file.getName().equals(e)) continue;
                x = true;
            }
            if (!x) continue;
            result.add(file);
        }
        Collections.sort(result);
        return result;
    }

    protected void removeTempFiles(boolean quiet, String dir, String[] remove) {
        List<File> files = this.getFileListing(new File(dir), remove);
        if (!quiet) {
            System.out.println("Removing Temporary Files...");
        }
        for (File fName : files) {
            fName.deleteOnExit();
        }
    }
}

