/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim;

import java.util.ArrayList;
import java.util.Arrays;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger8;

public class CIMOctetString {
    public static UnsignedInteger8[] getCIMUint8(String value) {
        UnsignedInteger8[] retVal = new UnsignedInteger8[value.length() + 4];
        UnsignedInteger32 size = new UnsignedInteger32((long)(value.length() + 4));
        String sizeStr = String.format("%08x", size.intValue());
        for (int x = 0; x < 4; ++x) {
            retVal[x] = new UnsignedInteger8(Short.parseShort(sizeStr.substring(x * 2, x * 2 + 2), 16));
        }
        int i = 0;
        for (char ch : value.toCharArray()) {
            retVal[i++ + 4] = new UnsignedInteger8((short)ch);
        }
        return retVal;
    }

    public static String[] getCIMString(String value) {
        UnsignedInteger32 size = new UnsignedInteger32((long)(4 + value.length()));
        String sizeStr = String.format("0x%08x", size.intValue());
        ArrayList<String> l = new ArrayList<String>();
        l.add(sizeStr);
        for (char ch : value.toCharArray()) {
            String hex = String.format("0x%08x", ch);
            l.add(hex);
        }
        return l.toArray(new String[l.size()]);
    }

    public static String getString(UnsignedInteger8[] octetArray) {
        int i = 0;
        String a = "";
        for (UnsignedInteger8 s : octetArray) {
            if (++i <= 4) continue;
            a = a + (char)Short.parseShort(s.toString());
        }
        return a;
    }

    public static String getString(String[] octetArray) {
        String a = "";
        int i = 0;
        for (String str : octetArray) {
            if (++i <= 1) continue;
            a = a + (char)Integer.parseInt(str.substring(3, str.length()), 16);
        }
        return a;
    }

    public static void main(String[] args) {
        String value = "jserveradmin";
        System.out.println(CIMOctetString.getString(new String[]{"0x00000034", "0x0000006a", "0x00000073", "0x00000065", "0x00000072", "0x00000076", "0x00000065", "0x00000072", "0x00000061", "0x00000064", "0x0000006d", "0x00000069", "0x0000006e"}));
        System.out.println(Arrays.toString(CIMOctetString.getCIMString(value)));
        UnsignedInteger8[] octetString = new UnsignedInteger8[]{new UnsignedInteger8(0), new UnsignedInteger8(0), new UnsignedInteger8(0), new UnsignedInteger8(16), new UnsignedInteger8(106), new UnsignedInteger8(115), new UnsignedInteger8(101), new UnsignedInteger8(114), new UnsignedInteger8(118), new UnsignedInteger8(101), new UnsignedInteger8(114), new UnsignedInteger8(97), new UnsignedInteger8(100), new UnsignedInteger8(109), new UnsignedInteger8(105), new UnsignedInteger8(110)};
        System.out.println(CIMOctetString.getString(octetString));
        System.out.println(Arrays.toString(CIMOctetString.getCIMUint8(value)));
    }
}

