/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.cmpi;

import com.ws.cim.codegen.cmpi.CArgument;
import com.ws.cim.codegen.java.JavaCodeWriterConstants;
import com.ws.cim.codegen.java.JavaMethod;
import java.util.ArrayList;
import java.util.Iterator;

public class CFunction
extends JavaMethod {
    private ArrayList<CArgument> mArguments;
    private final String mComment;
    private final String mBody;
    private final String mReturnType;
    private final String mName;
    private final boolean mIsStatic;

    public CFunction(String pComment, boolean pIsStatic, String pReturnType, String pName, ArrayList<CArgument> pArguments, String pBody) {
        super(pComment, JavaCodeWriterConstants.TYPE.DEFAULT, pIsStatic, pReturnType, pName, null, null, pBody);
        this.mArguments = pArguments == null ? new ArrayList() : pArguments;
        this.mComment = pComment;
        this.mBody = pBody;
        this.mIsStatic = pIsStatic;
        this.mReturnType = pReturnType;
        this.mName = pName;
    }

    public ArrayList<CArgument> getCArguments() {
        return this.mArguments;
    }

    @Override
    public String toString() {
        StringBuilder methodStructure = new StringBuilder();
        StringBuilder tempMethodStructure = new StringBuilder();
        int maxLen = 80;
        String tabs = "";
        int ntabs = 0;
        Iterator<String> commentIterator = JavaCodeWriterConstants.getLineIterator(this.mComment, maxLen, ntabs, true);
        while (commentIterator.hasNext()) {
            methodStructure.append(commentIterator.next());
        }
        tempMethodStructure.append("");
        tempMethodStructure.append(" ");
        if (this.mIsStatic) {
            tempMethodStructure.append("static");
            tempMethodStructure.append(" ");
        }
        if (this.mReturnType != null) {
            tempMethodStructure.append(this.mReturnType);
            tempMethodStructure.append(" ");
        }
        tempMethodStructure.append(this.mName);
        tempMethodStructure.append("(");
        if (this.mArguments != null) {
            tempMethodStructure.append(JavaCodeWriterConstants.getCommaSeparatedLine(this.mArguments));
        }
        tempMethodStructure.append(")");
        tempMethodStructure.append(System.getProperty("line.separator"));
        tempMethodStructure.append("{");
        Iterator<String> methodIterator = JavaCodeWriterConstants.getLineIterator(tempMethodStructure.toString(), maxLen, ntabs, false);
        while (methodIterator.hasNext()) {
            methodStructure.append(methodIterator.next());
        }
        if (this.mBody != null) {
            methodStructure.append(this.mBody);
        }
        methodStructure.append(tabs);
        methodStructure.append("}");
        return methodStructure.toString();
    }
}

