/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.java;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Iterator;

public class JavaCodeWriterConstants {
    public static final String BUNDLE = "com.ws.cim.codegen.java.JavaCodeWriter";
    public static final String TAB = "\t";
    public static final String SPACE = " ";
    public static final String SEMICOLON = ";";
    public static final String COMMA = ",";
    public static final String DOT = ".";
    public static final String EQUAL = "=";
    public static final String OPEN_PAREN = "(";
    public static final String CLOSE_PAREN = ")";
    public static final String OPEN_CURLYBRACE = "{";
    public static final String CLOSE_CURLYBRACE = "}";
    public static final String OPEN_SQUAREBRACE = "[";
    public static final String CLOSE_SQUAREBRACE = "]";
    public static final String CLASS = "class";
    public static final String INTERFACE = "interface";
    public static final String IMPORT = "import";
    public static final String THROWS = "throws";
    public static final String PUBLIC = "public";
    public static final String PRIVATE = "private";
    public static final String PROTECTED = "protected";
    public static final String DEFAULT = "";
    public static final String STATIC = "static";
    public static final String FINAL = "final";

    public static String lineBreak(String pStr) {
        StringBuffer result = new StringBuffer();
        int strLength = pStr.length();
        int startLoc = 0;
        int endLoc = strLength;
        if (strLength > 80) {
            String nextString;
            String tempString = pStr.substring(startLoc, 80);
            if (tempString.contains(DOT) && !tempString.startsWith(DOT)) {
                endLoc = tempString.lastIndexOf(DOT);
            } else if (tempString.contains(SPACE) && !tempString.startsWith(SPACE)) {
                endLoc = tempString.lastIndexOf(SPACE);
            }
            String currentStr = pStr.substring(startLoc, endLoc);
            result.append(currentStr);
            if (endLoc < strLength && !(nextString = pStr.substring(startLoc = endLoc, strLength)).isEmpty()) {
                result.append(System.getProperty("line.separator") + TAB + TAB + TAB + TAB + JavaCodeWriterConstants.lineBreak(nextString));
            }
        } else {
            result.append(pStr);
        }
        return result.toString();
    }

    public static Iterator<String> getLineIterator(String pText, int len, int ntabs, boolean pIsComment) {
        if (pIsComment) {
            pText = pText.replaceAll("\n\n", "\n");
        }
        String tab = DEFAULT;
        for (int i = 0; i < ntabs; ++i) {
            tab = tab + TAB;
        }
        ArrayList<String> l = new ArrayList<String>();
        if (pIsComment) {
            l.add(tab + "/**\n");
        }
        BreakIterator i = BreakIterator.getWordInstance();
        StringBuffer buf = new StringBuffer();
        if (pIsComment) {
            buf.append(tab + " * ");
        }
        i.setText(pText);
        int start = i.first();
        boolean flag = false;
        int end = i.next();
        while (end != -1) {
            String tempWord;
            String word = pText.substring(start, end);
            if (word.equals("&") && (tempWord = pText.substring(end, i.next())).equals("&")) {
                flag = true;
            }
            if (word.equals(" \n") || buf.length() + word.length() >= len || flag) {
                String line = DEFAULT;
                flag = false;
                line = pIsComment ? tab + SPACE + buf.toString().trim() + System.getProperty("line.separator") : (word.equals(" \n") ? buf.toString().trim() + TAB : tab + buf.toString().trim() + (ntabs != 0 ? "\n\t\t" : "\n\t"));
                l.add(line);
                buf.delete(0, buf.length());
                if (pIsComment) {
                    buf.append(tab + " * ");
                }
                if (word.equals(" \n")) {
                    word = DEFAULT;
                }
            }
            buf.append(word);
            start = end;
            end = i.next();
        }
        if (pIsComment) {
            l.add(tab + SPACE + buf.toString().trim() + System.getProperty("line.separator"));
            l.add(tab + " */\n");
        } else {
            l.add(tab + buf.toString().trim() + System.getProperty("line.separator"));
        }
        return l.iterator();
    }

    public static String getCommaSeparatedLine(ArrayList<?> pList) {
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < pList.size(); ++i) {
            strBuf.append(pList.get(i));
            if (i == pList.size() - 1) continue;
            strBuf.append(", ");
        }
        return strBuf.toString();
    }

    public static enum TYPE {
        PRIVATE,
        PUBLIC,
        PROTECTED,
        DEFAULT;

    }
}

