/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.java;

import com.ws.cim.codegen.java.JavaCodeWriterConstants;
import java.util.Iterator;

public class JavaDataMember {
    private final String mComment;
    private final JavaCodeWriterConstants.TYPE mType;
    private final boolean mIsFinal;
    private final boolean mIsStatic;
    private final String mDataType;
    private final String mName;
    private Object mValue;
    private boolean mInEnum;

    public JavaDataMember(String pComment, JavaCodeWriterConstants.TYPE pType, boolean pFinal, boolean pStatic, String pDataType, String pName, Object pValue) {
        this.mComment = pComment;
        this.mType = pType;
        this.mIsFinal = pFinal;
        this.mIsStatic = pStatic;
        this.mDataType = pDataType;
        this.mName = pName;
        this.mValue = pValue;
    }

    public void setInEnum(boolean pInEnum) {
        this.mInEnum = pInEnum;
    }

    public String getComment() {
        return this.mComment;
    }

    public JavaCodeWriterConstants.TYPE getType() {
        return this.mType;
    }

    public boolean isFinal() {
        return this.mIsFinal;
    }

    public boolean isStatic() {
        return this.mIsStatic;
    }

    public String getDataType() {
        return this.mDataType;
    }

    public String getName() {
        return this.mName;
    }

    public Object getValue() {
        return this.mValue;
    }

    public void setValue(Object pValue) {
        this.mValue = pValue;
    }

    public String toString() {
        StringBuilder strBuff = new StringBuilder();
        int maxLen = 73;
        String tabs = "\t";
        int ntabs = 1;
        if (this.mInEnum) {
            maxLen = 68;
            tabs = tabs + "\t";
            ++ntabs;
        }
        if (null != this.mComment && !this.mComment.isEmpty()) {
            Iterator<String> i = JavaCodeWriterConstants.getLineIterator(this.mComment, maxLen, ntabs, true);
            while (i.hasNext()) {
                strBuff.append((Object)i.next());
            }
        }
        strBuff.append(tabs);
        switch (this.mType) {
            case PUBLIC: {
                strBuff.append("public");
                break;
            }
            case PRIVATE: {
                strBuff.append("private");
                break;
            }
            case PROTECTED: {
                strBuff.append("protected");
            }
        }
        strBuff.append(" ");
        if (this.mIsStatic) {
            strBuff.append("static");
            strBuff.append(" ");
        }
        if (this.mIsFinal) {
            strBuff.append("final");
            strBuff.append(" ");
        }
        strBuff.append(this.mDataType);
        strBuff.append(" ");
        strBuff.append(this.mName);
        if (this.mValue != null) {
            strBuff.append(" = ");
            strBuff.append(this.mValue.toString());
        }
        strBuff.append(";");
        return strBuff.toString();
    }
}

