/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.json;

import com.ws.wbem.CloseableAddableIterator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMDateTimeInterval;
import javax.cim.CIMInstance;
import javax.cim.CIMMethod;
import javax.cim.CIMObjectPath;
import javax.cim.CIMParameter;
import javax.cim.CIMProperty;
import javax.cim.CIMQualifier;
import javax.cim.CIMQualifierType;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;
import javax.json.Json;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.client.EnumerateResponse;

public class CIMRSElementsParser {
    private final JsonParserFactory mFactory = Json.createParserFactory(null);

    public CIMObjectPath generateInstanceObjectPath(CIMObjectPath target, String self, String namespace, String classname) {
        ArrayList<CIMProperty> l = new ArrayList<CIMProperty>();
        String str = self.substring(self.indexOf("instances") + 10);
        if (!str.isEmpty()) {
            List<String> pList = Arrays.asList(str.split(","));
            for (String prop : pList) {
                String name = prop.substring(0, prop.indexOf("="));
                String value = prop.substring(prop.indexOf(61) + 1);
                try {
                    value = URLDecoder.decode(value, "UTF-8");
                }
                catch (Throwable t) {
                    // empty catch block
                }
                l.add(new CIMProperty(name, CIMDataType.STRING_T, (Object)value, true));
            }
        }
        return new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), namespace, classname, l.toArray(new CIMProperty[l.size()]));
    }

    private Object getCIMValue(Object value, CIMDataType dataType) {
        Object[] retVal = null;
        if (null == value || null == value.toString()) {
            return null;
        }
        switch (dataType.getType()) {
            case 9: {
                if (dataType.isArray()) {
                    Object[] vals = value;
                    Boolean[] retValArray = new Boolean[vals.length];
                    for (int x = 0; x < vals.length; ++x) {
                        retValArray[x] = new Boolean(vals[x].toString());
                    }
                    retVal = retValArray;
                    break;
                }
                retVal = new Boolean(value.toString());
                break;
            }
            case 13: {
                if (dataType.isArray()) {
                    Object[] vals = value;
                    Character[] retValArray = new Character[vals.length];
                    for (int x = 0; x < vals.length; ++x) {
                        retValArray[x] = new Character(vals[x].toString().charAt(0));
                    }
                    retVal = retValArray;
                    break;
                }
                retVal = new Character(value.toString().charAt(0));
                break;
            }
            case 12: {
                if (dataType.isArray()) {
                    Object[] vals = value;
                    if (value.toString().contains(":")) {
                        CIMDateTimeInterval[] retValArray = new CIMDateTimeInterval[vals.length];
                        for (int x = 0; x < vals.length; ++x) {
                            retValArray[x] = new CIMDateTimeInterval(vals[x].toString());
                        }
                        retVal = retValArray;
                        break;
                    }
                    CIMDateTimeAbsolute[] retValArray = new CIMDateTimeAbsolute[vals.length];
                    for (int x = 0; x < vals.length; ++x) {
                        retValArray[x] = new CIMDateTimeAbsolute(vals[x].toString());
                    }
                    retVal = retValArray;
                    break;
                }
                if (null == value) break;
                if (value.toString().contains(":")) {
                    retVal = new CIMDateTimeInterval(value.toString());
                    break;
                }
                retVal = new CIMDateTimeAbsolute(value.toString());
                break;
            }
            case 10: {
                if (dataType.isArray()) {
                    Object[] vals = value;
                    Float[] retValArray = new Float[vals.length];
                    for (int x = 0; x < vals.length; ++x) {
                        retValArray[x] = new Float(vals[x].toString());
                    }
                    retVal = retValArray;
                    break;
                }
                retVal = new Float(value.toString());
                break;
            }
            case 11: {
                if (dataType.isArray()) {
                    Object[] vals = value;
                    Double[] retValArray = new Double[vals.length];
                    for (int x = 0; x < vals.length; ++x) {
                        retValArray[x] = new Double(vals[x].toString());
                    }
                    retVal = retValArray;
                    break;
                }
                retVal = new Double(value.toString());
                break;
            }
            case 14: {
                if (dataType.isArray()) {
                    Object[] vals = value;
                    CIMObjectPath[] retValArray = new CIMObjectPath[vals.length];
                    for (int x = 0; x < vals.length; ++x) {
                        retValArray[x] = new CIMObjectPath(vals[x].toString());
                    }
                    retVal = retValArray;
                    break;
                }
                retVal = new CIMObjectPath(value.toString());
                break;
            }
            case 1: {
                if (dataType.isArray()) {
                    Object[] vals = value;
                    Byte[] retValArray = new Byte[vals.length];
                    for (int x = 0; x < vals.length; ++x) {
                        retValArray[x] = new Byte(vals[x].toString());
                    }
                    retVal = retValArray;
                    break;
                }
                retVal = new Byte(value.toString());
                break;
            }
            case 3: {
                if (dataType.isArray()) {
                    Object[] vals = value;
                    Short[] retValArray = new Short[vals.length];
                    for (int x = 0; x < vals.length; ++x) {
                        retValArray[x] = new Short(vals[x].toString());
                    }
                    retVal = retValArray;
                    break;
                }
                retVal = new Short(value.toString());
                break;
            }
            case 5: {
                if (dataType.isArray()) {
                    Object[] vals = value;
                    Integer[] retValArray = new Integer[vals.length];
                    for (int x = 0; x < vals.length; ++x) {
                        retValArray[x] = new Integer(vals[x].toString());
                    }
                    retVal = retValArray;
                    break;
                }
                retVal = new Integer(value.toString());
                break;
            }
            case 7: {
                if (dataType.isArray()) {
                    Object[] vals = value;
                    Long[] retValArray = new Long[vals.length];
                    for (int x = 0; x < vals.length; ++x) {
                        retValArray[x] = new Long(vals[x].toString());
                    }
                    retVal = retValArray;
                    break;
                }
                retVal = new Long(value.toString());
                break;
            }
            case 0: {
                if (dataType.isArray()) {
                    Object[] vals = value;
                    UnsignedInteger8[] retValArray = new UnsignedInteger8[vals.length];
                    for (int x = 0; x < vals.length; ++x) {
                        retValArray[x] = new UnsignedInteger8(vals[x].toString());
                    }
                    retVal = retValArray;
                    break;
                }
                retVal = new UnsignedInteger8(value.toString());
                break;
            }
            case 2: {
                if (dataType.isArray()) {
                    Object[] vals = value;
                    UnsignedInteger16[] retValArray = new UnsignedInteger16[vals.length];
                    for (int x = 0; x < vals.length; ++x) {
                        retValArray[x] = new UnsignedInteger16(vals[x].toString());
                    }
                    retVal = retValArray;
                    break;
                }
                retVal = new UnsignedInteger16(value.toString());
                break;
            }
            case 4: {
                if (dataType.isArray()) {
                    Object[] vals = value;
                    UnsignedInteger32[] retValArray = new UnsignedInteger32[vals.length];
                    for (int x = 0; x < vals.length; ++x) {
                        retValArray[x] = new UnsignedInteger32(vals[x].toString());
                    }
                    retVal = retValArray;
                    break;
                }
                retVal = new UnsignedInteger32(value.toString());
                break;
            }
            case 6: {
                if (dataType.isArray()) {
                    Object[] vals = value;
                    UnsignedInteger64[] retValArray = new UnsignedInteger64[vals.length];
                    for (int x = 0; x < vals.length; ++x) {
                        retValArray[x] = new UnsignedInteger64(vals[x].toString());
                    }
                    retVal = retValArray;
                    break;
                }
                retVal = new UnsignedInteger64(value.toString());
                break;
            }
            case 8: {
                if (dataType.isArray()) {
                    Object[] vals = value;
                    String[] retValArray = new String[vals.length];
                    for (int x = 0; x < vals.length; ++x) {
                        retValArray[x] = new String(vals[x].toString());
                    }
                    retVal = retValArray;
                    break;
                }
                retVal = value.toString();
                break;
            }
            case 15: {
                if (dataType.isArray()) {
                    Object[] vals = value;
                    CIMInstance[] retValArray = new CIMInstance[vals.length];
                    for (int x = 0; x < vals.length; ++x) {
                        retValArray[x] = (CIMInstance)vals[x];
                    }
                    retVal = retValArray;
                    break;
                }
                retVal = value;
                break;
            }
            case 17: {
                if (dataType.isArray()) {
                    Object[] vals = value;
                    CIMClass[] retValArray = new CIMClass[vals.length];
                    for (int x = 0; x < vals.length; ++x) {
                        retValArray[x] = (CIMClass)vals[x];
                    }
                    retVal = retValArray;
                    break;
                }
                retVal = value;
            }
        }
        return retVal;
    }

    private CIMDataType getDataTypeFromJSONString(String dataType, boolean isArray, String refClassName) {
        CIMDataType dt = CIMDataType.STRING_T;
        switch (dataType) {
            case "boolean": {
                dt = isArray ? CIMDataType.BOOLEAN_ARRAY_T : CIMDataType.BOOLEAN_T;
                break;
            }
            case "char16": {
                dt = isArray ? CIMDataType.CLASS_ARRAY_T : CIMDataType.CHAR16_T;
                break;
            }
            case "datetime": {
                dt = isArray ? CIMDataType.DATETIME_ARRAY_T : CIMDataType.DATETIME_T;
                break;
            }
            case "real32": {
                dt = isArray ? CIMDataType.REAL32_ARRAY_T : CIMDataType.REAL32_T;
                break;
            }
            case "real64": {
                dt = isArray ? CIMDataType.REAL64_ARRAY_T : CIMDataType.REAL64_T;
                break;
            }
            case "reference": {
                dt = isArray ? new CIMDataType(refClassName, 0) : new CIMDataType(refClassName);
                break;
            }
            case "sint8": {
                dt = isArray ? CIMDataType.SINT8_ARRAY_T : CIMDataType.SINT8_T;
                break;
            }
            case "sint16": {
                dt = isArray ? CIMDataType.SINT16_ARRAY_T : CIMDataType.SINT16_T;
                break;
            }
            case "sint32": {
                dt = isArray ? CIMDataType.SINT32_ARRAY_T : CIMDataType.SINT32_T;
                break;
            }
            case "sint64": {
                dt = isArray ? CIMDataType.SINT64_ARRAY_T : CIMDataType.SINT64_T;
                break;
            }
            case "uint8": {
                dt = isArray ? CIMDataType.UINT8_ARRAY_T : CIMDataType.UINT8_T;
                break;
            }
            case "uint16": {
                dt = isArray ? CIMDataType.UINT16_ARRAY_T : CIMDataType.UINT16_T;
                break;
            }
            case "uint32": {
                dt = isArray ? CIMDataType.UINT32_ARRAY_T : CIMDataType.UINT32_T;
                break;
            }
            case "uint64": {
                dt = isArray ? CIMDataType.UINT64_ARRAY_T : CIMDataType.UINT64_T;
                break;
            }
            case "string": {
                dt = isArray ? CIMDataType.STRING_ARRAY_T : CIMDataType.STRING_T;
                break;
            }
            case "instance": {
                dt = isArray ? CIMDataType.OBJECT_ARRAY_T : CIMDataType.OBJECT_T;
                break;
            }
            case "class": {
                dt = dt.isArray() ? CIMDataType.CLASS_ARRAY_T : CIMDataType.CLASS_T;
            }
            default: {
                dt = CIMDataType.STRING_T;
            }
        }
        return dt;
    }

    public CIMClass parseClass(InputStream stream, CIMObjectPath target) {
        JsonParser parser = this.mFactory.createParser(stream);
        CIMClass clazz = this.parseClass(stream, target, parser);
        return clazz;
    }

    private CIMClass parseClass(InputStream stream, CIMObjectPath target, JsonParser parser) {
        if (null == parser) {
            parser = this.mFactory.createParser(stream);
        }
        String namespace = null;
        String name = null;
        String superClassName = null;
        ArrayList<Object> props = new ArrayList();
        ArrayList<Object> quals = new ArrayList();
        ArrayList<Object> methods = new ArrayList();
        boolean isKeyed = false;
        boolean isAssociation = false;
        String key = null;
        boolean end = false;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_OBJECT: {
                    if (!"classes".equals(key)) break;
                    break;
                }
                case END_OBJECT: {
                    end = true;
                    break;
                }
                case START_ARRAY: {
                    break;
                }
                case END_ARRAY: {
                    break;
                }
                case VALUE_NUMBER: {
                    break;
                }
                case VALUE_STRING: {
                    String value = parser.getString();
                    if (null == key) break;
                    if ("kind".equals(key) && !"class".equals(value)) {
                        throw new IllegalArgumentException("Kind was not equal to class!");
                    }
                    if ("self".equals(key)) break;
                    if ("namespace".equals(key)) {
                        namespace = value;
                        break;
                    }
                    if ("name".equals(key)) {
                        name = value;
                        break;
                    }
                    if (!"superclassname".equals(key)) break;
                    superClassName = value;
                    break;
                }
                case VALUE_TRUE: {
                    break;
                }
                case VALUE_FALSE: {
                    break;
                }
                case VALUE_NULL: {
                    break;
                }
                case KEY_NAME: {
                    key = parser.getString();
                    if ("properties".equals(key)) {
                        props = this.parseClassProperties(parser, target);
                        break;
                    }
                    if ("qualifiers".equals(key)) {
                        quals = this.parseQualifiers(parser, target);
                        break;
                    }
                    if (!"methods".equals(key)) break;
                    methods = this.parseMethods(parser, target);
                    break;
                }
            }
            if (!end) continue;
            break;
        }
        return new CIMClass(new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), namespace, name, null), superClassName, quals.toArray(new CIMQualifier[quals.size()]), props.toArray(new CIMClassProperty[props.size()]), methods.toArray(new CIMMethod[methods.size()]), isAssociation, isKeyed);
    }

    private ArrayList<CIMMethod<?>> parseMethods(JsonParser parser, CIMObjectPath target) {
        ArrayList retVal = new ArrayList();
        ArrayList<Object> params = new ArrayList();
        ArrayList<CIMQualifier<?>> quals = null;
        String key = null;
        String name = null;
        String type = null;
        boolean array = false;
        String refClassName = null;
        boolean end = false;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_OBJECT: {
                    if (null != name) break;
                    name = key;
                    break;
                }
                case END_OBJECT: {
                    if (null != name) {
                        CIMDataType cdtType = this.getDataTypeFromJSONString(type, array, refClassName);
                        retVal.add(new CIMMethod(name, cdtType, quals != null ? quals.toArray(new CIMQualifier[quals.size()]) : null, params != null ? params.toArray(new CIMParameter[params.size()]) : null, false));
                        name = null;
                        key = null;
                        type = null;
                        array = false;
                        refClassName = null;
                        quals = null;
                        params = null;
                        break;
                    }
                    end = true;
                    break;
                }
                case START_ARRAY: {
                    array = true;
                    break;
                }
                case END_ARRAY: {
                    break;
                }
                case VALUE_NUMBER: {
                    break;
                }
                case VALUE_STRING: {
                    String val = parser.getString();
                    if (null == key) break;
                    if ("type".equals(key)) {
                        type = val;
                        break;
                    }
                    if (!"classname".equals(key)) break;
                    refClassName = val;
                    break;
                }
                case VALUE_TRUE: {
                    if (!"array".equals(key)) break;
                    array = true;
                    break;
                }
                case VALUE_FALSE: {
                    break;
                }
                case VALUE_NULL: {
                    break;
                }
                case KEY_NAME: {
                    key = parser.getString();
                    if ("qualifiers".equals(key)) {
                        quals = this.parseQualifiers(parser, target);
                        break;
                    }
                    if (!"parameters".equals(key)) break;
                    params = this.parseParameters(parser, target);
                    break;
                }
            }
            if (!end) continue;
            break;
        }
        return retVal;
    }

    public CloseableIterator<CIMClass> parseClassCollection(InputStream stream, CIMObjectPath target) {
        JsonParser parser = this.mFactory.createParser(stream);
        CloseableAddableIterator caIterator = new CloseableAddableIterator(5L, Integer.MAX_VALUE);
        String key = null;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_OBJECT: {
                    if (!"classes".equals(key)) break;
                    caIterator.add((Object)this.parseClass(stream, target, parser));
                    break;
                }
                case END_OBJECT: {
                    break;
                }
                case START_ARRAY: {
                    break;
                }
                case END_ARRAY: {
                    break;
                }
                case VALUE_NUMBER: {
                    break;
                }
                case VALUE_STRING: {
                    String value = parser.getString();
                    if (null == key) break;
                    if ("kind".equals(key) && !"classcollection".equals(value)) {
                        throw new IllegalArgumentException("Kind was not equal to classcollection!" + value);
                    }
                    if (!"self".equals(key)) break;
                    break;
                }
                case VALUE_TRUE: {
                    break;
                }
                case VALUE_FALSE: {
                    break;
                }
                case VALUE_NULL: {
                    break;
                }
                case KEY_NAME: {
                    key = parser.getString();
                    break;
                }
            }
        }
        caIterator.done();
        return caIterator;
    }

    public WBEMException parseError(InputStream stream, CIMObjectPath target) throws IOException {
        JsonParser parser = this.mFactory.createParser(stream);
        ArrayList<CIMInstance> list = new ArrayList<CIMInstance>();
        String key = null;
        int statusCode = 0;
        String statusDescription = null;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_OBJECT: {
                    if (!"errors".equals(key)) break;
                    list.add(this.parseInstance(stream, target, parser));
                    break;
                }
                case END_OBJECT: {
                    break;
                }
                case START_ARRAY: {
                    break;
                }
                case END_ARRAY: {
                    break;
                }
                case VALUE_NUMBER: {
                    int iValue = parser.getInt();
                    if (!"statuscode".equals(key)) break;
                    statusCode = iValue;
                    break;
                }
                case VALUE_STRING: {
                    String value = parser.getString();
                    if (null == key) break;
                    if ("kind".equals(key) && !"errorresponse".equals(value)) {
                        throw new IllegalArgumentException("Kind was not equal to errorresponse!");
                    }
                    if ("self".equals(key) || "httpmethod".equals(key) || !"statusdescription".equals(key)) break;
                    statusDescription = value;
                    break;
                }
                case VALUE_TRUE: {
                    break;
                }
                case VALUE_FALSE: {
                    break;
                }
                case VALUE_NULL: {
                    break;
                }
                case KEY_NAME: {
                    key = parser.getString();
                    break;
                }
            }
        }
        return new WBEMException(statusCode, statusDescription, list.toArray(new CIMInstance[list.size()]));
    }

    private CIMInstance parseInstance(InputStream stream, CIMObjectPath target, JsonParser parser) {
        boolean bClose = false;
        if (null == parser) {
            bClose = true;
            parser = this.mFactory.createParser(stream);
        }
        ArrayList<Object> properties = new ArrayList();
        String namespace = null;
        String classname = null;
        String self = null;
        String key = null;
        boolean end = false;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_OBJECT: {
                    break;
                }
                case END_OBJECT: {
                    end = true;
                    break;
                }
                case START_ARRAY: {
                    break;
                }
                case END_ARRAY: {
                    break;
                }
                case VALUE_NUMBER: {
                    break;
                }
                case VALUE_STRING: {
                    String value = parser.getString();
                    if (null == key) break;
                    if ("kind".equals(key) && !"instance".equals(value)) {
                        throw new IllegalArgumentException("Kind was not equal to instance!");
                    }
                    if ("self".equals(key)) {
                        self = value;
                    }
                    if ("namespace".equals(key)) {
                        namespace = value;
                    }
                    if (!"classname".equals(key)) break;
                    classname = value;
                    break;
                }
                case VALUE_TRUE: {
                    break;
                }
                case VALUE_FALSE: {
                    break;
                }
                case VALUE_NULL: {
                    break;
                }
                case KEY_NAME: {
                    key = parser.getString();
                    if (!"properties".equals(key)) break;
                    properties = this.parseProperties(parser, target);
                    break;
                }
            }
            if (!end) continue;
            break;
        }
        CIMObjectPath path = null;
        path = null == self ? new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), namespace, classname, null) : this.generateInstanceObjectPath(target, self, namespace, classname);
        if (bClose) {
            // empty if block
        }
        return new CIMInstance(path, properties.toArray(new CIMProperty[properties.size()]));
    }

    public CIMInstance parseInstance(InputStream stream, CIMObjectPath target) {
        JsonParser parser = this.mFactory.createParser(stream);
        CIMInstance instance = this.parseInstance(stream, target, parser);
        return instance;
    }

    public CIMQualifierType<?> parseQualifierType(InputStream stream, CIMObjectPath target) {
        return this.parseQualifierType(stream, target, null);
    }

    public String parseMethodRequest(InputStream stream, CIMObjectPath target, ArrayList<CIMArgument<?>> inArgs) {
        JsonParser parser = this.mFactory.createParser(stream);
        String methodName = null;
        String key = null;
        block12: while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_OBJECT: {
                    CIMArgument<?>[] iArgs;
                    if (!"parameters".equals(key)) break;
                    for (CIMArgument<?> a : iArgs = this.parseArguments(stream, parser, target)) {
                        inArgs.add(a);
                    }
                    continue block12;
                }
                case END_OBJECT: {
                    break;
                }
                case START_ARRAY: {
                    break;
                }
                case END_ARRAY: {
                    break;
                }
                case VALUE_NUMBER: {
                    break;
                }
                case VALUE_STRING: {
                    String value = parser.getString();
                    if (null == key) break;
                    if ("kind".equals(key) && !"methodrequest".equals(value)) {
                        throw new IllegalArgumentException("Kind was not equal to methodrequest!");
                    }
                    if ("self".equals(key) || !"methodname".equals(key)) break;
                    methodName = value;
                    break;
                }
                case VALUE_TRUE: {
                    break;
                }
                case VALUE_FALSE: {
                    break;
                }
                case VALUE_NULL: {
                    break;
                }
                case KEY_NAME: {
                    key = parser.getString();
                    break;
                }
            }
        }
        return methodName;
    }

    public Object parseMethodResponse(InputStream stream, CIMArgument<?>[] outArgs, CIMObjectPath target) {
        JsonParser parser = this.mFactory.createParser(stream);
        Object retVal = null;
        String key = null;
        block12: while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_OBJECT: {
                    if ("returnvalue".equals(key)) {
                        retVal = this.parseReturnValue(stream, parser);
                        break;
                    }
                    if (!"parameters".equals(key)) break;
                    CIMArgument<?>[] oArgs = this.parseArguments(stream, parser, target);
                    if (null == oArgs || null == outArgs) continue block12;
                    System.arraycopy(oArgs, 0, outArgs, 0, outArgs.length);
                    break;
                }
                case END_OBJECT: {
                    break;
                }
                case START_ARRAY: {
                    break;
                }
                case END_ARRAY: {
                    break;
                }
                case VALUE_NUMBER: {
                    break;
                }
                case VALUE_STRING: {
                    String value = parser.getString();
                    if (null == key) break;
                    if ("kind".equals(key) && !"methodresponse".equals(value)) {
                        throw new IllegalArgumentException("Kind was not equal to methodresponse!");
                    }
                    if ("self".equals(key) || !"methodname".equals(key)) break;
                    break;
                }
                case VALUE_TRUE: {
                    break;
                }
                case VALUE_FALSE: {
                    break;
                }
                case VALUE_NULL: {
                    break;
                }
                case KEY_NAME: {
                    key = parser.getString();
                    break;
                }
            }
        }
        return retVal;
    }

    private CIMArgument<?>[] parseArguments(InputStream stream, JsonParser parser, CIMObjectPath target) {
        ArrayList<CIMArgument> retVal = new ArrayList<CIMArgument>();
        String key = null;
        String name = null;
        String type = null;
        Object value = null;
        ArrayList<Object> valueArray = new ArrayList<Object>();
        boolean array = false;
        String refClassName = null;
        boolean end = false;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_OBJECT: {
                    if (null == name) {
                        name = key;
                    } else if ("instance".equals(type)) {
                        CIMInstance i = this.parseInstance(null, target, parser);
                        if (array) {
                            valueArray.add(i);
                        } else {
                            value = i;
                        }
                    }
                    key = null;
                    break;
                }
                case END_OBJECT: {
                    if (null != name) {
                        CIMDataType cdtType = null;
                        cdtType = null == type ? CIMDataType.STRING_T : this.getDataTypeFromJSONString(type, array, refClassName);
                        value = array ? valueArray.toArray(new Object[valueArray.size()]) : value;
                        retVal.add(new CIMArgument(name, cdtType, this.getCIMValue(value, cdtType)));
                        name = null;
                        type = null;
                        key = null;
                        value = null;
                        array = false;
                        refClassName = null;
                        valueArray = new ArrayList();
                        break;
                    }
                    end = true;
                    break;
                }
                case START_ARRAY: {
                    array = true;
                    break;
                }
                case END_ARRAY: {
                    break;
                }
                case VALUE_NUMBER: {
                    if (array) {
                        valueArray.add(parser.getBigDecimal());
                        break;
                    }
                    value = parser.getBigDecimal();
                    break;
                }
                case VALUE_STRING: {
                    String val = parser.getString();
                    if (null == key) break;
                    if ("type".equals(key)) {
                        type = val;
                        key = null;
                        break;
                    }
                    if ("classname".equals(key)) {
                        refClassName = val;
                        key = null;
                        break;
                    }
                    if ("value".equals(key)) {
                        if (array) {
                            valueArray.add(val);
                        } else {
                            value = val;
                        }
                        key = null;
                        break;
                    }
                    if (array) {
                        valueArray.add(val);
                        break;
                    }
                    value = val;
                    break;
                }
                case VALUE_TRUE: {
                    if ("array".equals(key)) {
                        array = true;
                        key = null;
                        break;
                    }
                    if (array) {
                        valueArray.add(true);
                        break;
                    }
                    value = true;
                    break;
                }
                case VALUE_FALSE: {
                    if (array) {
                        valueArray.add(false);
                        break;
                    }
                    value = false;
                    break;
                }
                case VALUE_NULL: {
                    if (array) {
                        valueArray.add(null);
                        break;
                    }
                    value = null;
                    break;
                }
                case KEY_NAME: {
                    key = parser.getString();
                    break;
                }
            }
            if (!end) continue;
            break;
        }
        return retVal.toArray(new CIMArgument[retVal.size()]);
    }

    private Object parseReturnValue(InputStream stream, JsonParser parser) {
        String key = null;
        String type = null;
        Object value = null;
        ArrayList<Object> valueArray = new ArrayList<Object>();
        boolean array = false;
        String refClassName = null;
        boolean end = false;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_OBJECT: {
                    break;
                }
                case END_OBJECT: {
                    end = true;
                    break;
                }
                case START_ARRAY: {
                    array = true;
                    break;
                }
                case END_ARRAY: {
                    break;
                }
                case VALUE_NUMBER: {
                    if (array) {
                        valueArray.add(parser.getBigDecimal());
                        break;
                    }
                    value = parser.getBigDecimal();
                    break;
                }
                case VALUE_STRING: {
                    String val = parser.getString();
                    if (null == key) break;
                    if ("type".equals(key)) {
                        type = val;
                        key = null;
                        break;
                    }
                    if ("classname".equals(key)) {
                        refClassName = val;
                        key = null;
                        break;
                    }
                    if ("value".equals(key)) {
                        if (array) {
                            valueArray.add(val);
                        } else {
                            value = val;
                        }
                        key = null;
                        break;
                    }
                    if (array) {
                        valueArray.add(val);
                        break;
                    }
                    value = val;
                    break;
                }
                case VALUE_TRUE: {
                    if ("array".equals(key)) {
                        array = true;
                        key = null;
                        break;
                    }
                    if (array) {
                        valueArray.add(true);
                        break;
                    }
                    value = true;
                    break;
                }
                case VALUE_FALSE: {
                    if (array) {
                        valueArray.add(false);
                        break;
                    }
                    value = false;
                    break;
                }
                case VALUE_NULL: {
                    if (array) {
                        valueArray.add(null);
                        break;
                    }
                    value = null;
                    break;
                }
                case KEY_NAME: {
                    key = parser.getString();
                    break;
                }
            }
            if (!end) continue;
            break;
        }
        CIMDataType cdtType = null;
        cdtType = null == type ? CIMDataType.STRING_T : this.getDataTypeFromJSONString(type, array, refClassName);
        value = array ? valueArray.toArray(new Object[valueArray.size()]) : value;
        return this.getCIMValue(value, cdtType);
    }

    public CIMQualifierType<?> parseQualifierType(InputStream stream, CIMObjectPath target, JsonParser parser) {
        if (null == parser) {
            parser = this.mFactory.createParser(stream);
        }
        String namespace = null;
        String qname = null;
        String type = null;
        boolean array = false;
        int scopes = 0;
        int flavors = 0;
        boolean override = false;
        boolean propagated = false;
        Object defaultValue = null;
        String key = null;
        boolean end = false;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            block0 : switch (event) {
                case START_OBJECT: {
                    break;
                }
                case END_OBJECT: {
                    end = true;
                    break;
                }
                case START_ARRAY: {
                    if (!"scopes".equals(key)) break;
                    break;
                }
                case END_ARRAY: {
                    break;
                }
                case VALUE_NUMBER: {
                    if (!"defaultvalue".equals(key)) break;
                    defaultValue = parser.getInt();
                    break;
                }
                case VALUE_STRING: {
                    String value = parser.getString();
                    if (null == key) break;
                    if ("kind".equals(key) && !"qualifiertype".equals(value)) {
                        throw new IllegalArgumentException("Kind was not equal to qualifiertype!");
                    }
                    if ("self".equals(key)) break;
                    if ("namespace".equals(key)) {
                        namespace = value;
                        break;
                    }
                    if ("name".equals(key)) {
                        qname = value;
                        break;
                    }
                    if ("type".equals(key)) {
                        type = value;
                        break;
                    }
                    if ("defaultvalue".equals(key)) {
                        defaultValue = value;
                        break;
                    }
                    if (!"scopes".equals(key)) break;
                    switch (value) {
                        case "any": {
                            scopes |= 0x7F;
                        }
                        case "class": {
                            scopes |= 1;
                            break block0;
                        }
                        case "association": {
                            scopes |= 2;
                            break block0;
                        }
                        case "indication": {
                            scopes |= 4;
                            break block0;
                        }
                        case "property": {
                            scopes |= 8;
                            break block0;
                        }
                        case "method": {
                            scopes |= 0x20;
                            break block0;
                        }
                        case "parameter": {
                            scopes |= 0x40;
                            break block0;
                        }
                        case "reference": {
                            scopes |= 0x10;
                            break block0;
                        }
                    }
                    break;
                }
                case VALUE_TRUE: {
                    if ("array".equals(key)) {
                        array = true;
                        break;
                    }
                    if ("override".equals(key)) {
                        override = true;
                        break;
                    }
                    if ("propagation".equals(key)) {
                        propagated = true;
                        break;
                    }
                    if ("translatable".equals(key)) {
                        flavors |= 4;
                        break;
                    }
                    if (!"defaultvalue".equals(key)) break;
                    defaultValue = true;
                    break;
                }
                case VALUE_FALSE: {
                    if (!"defaultvalue".equals(key)) break;
                    defaultValue = false;
                    break;
                }
                case VALUE_NULL: {
                    break;
                }
                case KEY_NAME: {
                    key = parser.getString();
                    break;
                }
            }
            if (!end) continue;
            break;
        }
        if (propagated) {
            if (!override) {
                flavors |= 1;
            }
        } else {
            flavors |= 2;
        }
        CIMObjectPath qPath = new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), namespace, qname, null);
        CIMDataType cdt = this.getDataTypeFromJSONString(type, array, null);
        return new CIMQualifierType(qPath, cdt, this.getCIMValue(defaultValue, cdt), scopes, flavors);
    }

    public CloseableIterator<CIMQualifierType<?>> parseQualifierTypeCollection(InputStream stream, CIMObjectPath target) {
        JsonParser parser = this.mFactory.createParser(stream);
        CloseableAddableIterator caIterator = new CloseableAddableIterator(5L, Integer.MAX_VALUE);
        String key = null;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_OBJECT: {
                    if (!"qualifiertypes".equals(key)) break;
                    caIterator.add(this.parseQualifierType(stream, target, parser));
                    break;
                }
                case END_OBJECT: {
                    break;
                }
                case START_ARRAY: {
                    break;
                }
                case END_ARRAY: {
                    break;
                }
                case VALUE_NUMBER: {
                    break;
                }
                case VALUE_STRING: {
                    String value = parser.getString();
                    if (null == key) break;
                    if ("kind".equals(key) && !"qualifiertypecollection".equals(value)) {
                        throw new IllegalArgumentException("Kind was not equal to qualifiertypecollection!");
                    }
                    if (!"self".equals(key)) break;
                    break;
                }
                case VALUE_TRUE: {
                    break;
                }
                case VALUE_FALSE: {
                    break;
                }
                case VALUE_NULL: {
                    break;
                }
                case KEY_NAME: {
                    key = parser.getString();
                    break;
                }
            }
        }
        caIterator.done();
        return caIterator;
    }

    public EnumerateResponse<CIMInstance> parseInstanceCollection(InputStream stream, CIMObjectPath target) {
        JsonParser parser = this.mFactory.createParser(stream, StandardCharsets.UTF_8);
        CloseableAddableIterator caIterator = new CloseableAddableIterator(5L, Integer.MAX_VALUE);
        String next = null;
        String key = null;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_OBJECT: {
                    if (!"instances".equals(key)) break;
                    caIterator.add((Object)this.parseInstance(stream, target, parser));
                    break;
                }
                case END_OBJECT: {
                    break;
                }
                case START_ARRAY: {
                    break;
                }
                case END_ARRAY: {
                    break;
                }
                case VALUE_NUMBER: {
                    break;
                }
                case VALUE_STRING: {
                    String value = parser.getString();
                    if (null == key) break;
                    if ("kind".equals(key) && !"instancecollection".equals(value)) {
                        throw new IllegalArgumentException("Kind was not equal to instancecollection!");
                    }
                    if ("self".equals(key)) {
                        // empty if block
                    }
                    if (!"next".equals(key)) break;
                    next = value;
                    break;
                }
                case VALUE_TRUE: {
                    break;
                }
                case VALUE_FALSE: {
                    break;
                }
                case VALUE_NULL: {
                    break;
                }
                case KEY_NAME: {
                    key = parser.getString();
                    break;
                }
            }
        }
        caIterator.done();
        return new EnumerateResponse(next, (CloseableIterator)caIterator, next == null);
    }

    private ArrayList<CIMProperty<?>> parseProperties(JsonParser parser, CIMObjectPath target) {
        ArrayList retVal = new ArrayList();
        String key = null;
        String name = null;
        String type = null;
        Object value = null;
        ArrayList<Object> valueArray = new ArrayList<Object>();
        boolean array = false;
        String refClassName = null;
        boolean end = false;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_OBJECT: {
                    if (null == name) {
                        name = key;
                    } else if ("instance".equals(type)) {
                        CIMInstance i = this.parseInstance(null, target, parser);
                        if (array) {
                            valueArray.add(i);
                        } else {
                            value = i;
                        }
                    }
                    key = null;
                    break;
                }
                case END_OBJECT: {
                    if (null != name) {
                        CIMDataType cdtType = null;
                        cdtType = null == type ? CIMDataType.STRING_T : this.getDataTypeFromJSONString(type, array, refClassName);
                        value = array ? valueArray.toArray(new Object[valueArray.size()]) : value;
                        retVal.add(new CIMProperty(name, cdtType, this.getCIMValue(value, cdtType)));
                        name = null;
                        type = null;
                        key = null;
                        value = null;
                        array = false;
                        refClassName = null;
                        valueArray = new ArrayList();
                        break;
                    }
                    end = true;
                    break;
                }
                case START_ARRAY: {
                    array = true;
                    break;
                }
                case END_ARRAY: {
                    break;
                }
                case VALUE_NUMBER: {
                    if (array) {
                        valueArray.add(parser.getBigDecimal());
                        break;
                    }
                    value = parser.getBigDecimal();
                    break;
                }
                case VALUE_STRING: {
                    String val = parser.getString();
                    if (null == key) break;
                    if ("type".equals(key)) {
                        type = val;
                        key = null;
                        break;
                    }
                    if ("classname".equals(key)) {
                        refClassName = val;
                        key = null;
                        break;
                    }
                    if ("value".equals(key)) {
                        if (array) {
                            valueArray.add(val);
                        } else {
                            value = val;
                        }
                        key = null;
                        break;
                    }
                    if (array) {
                        valueArray.add(val);
                        break;
                    }
                    value = val;
                    break;
                }
                case VALUE_TRUE: {
                    if ("array".equals(key)) {
                        array = true;
                        key = null;
                        break;
                    }
                    if (array) {
                        valueArray.add(true);
                        break;
                    }
                    value = true;
                    break;
                }
                case VALUE_FALSE: {
                    if (array) {
                        valueArray.add(false);
                        break;
                    }
                    value = false;
                    break;
                }
                case VALUE_NULL: {
                    if (array) {
                        valueArray.add(null);
                        break;
                    }
                    value = null;
                    break;
                }
                case KEY_NAME: {
                    key = parser.getString();
                    break;
                }
            }
            if (!end) continue;
            break;
        }
        return retVal;
    }

    private ArrayList<CIMParameter<?>> parseParameters(JsonParser parser, CIMObjectPath target) {
        ArrayList retVal = new ArrayList();
        ArrayList<CIMQualifier<?>> quals = null;
        String key = null;
        String name = null;
        String type = null;
        boolean array = false;
        String refClassName = null;
        boolean end = false;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_OBJECT: {
                    if (null != name) break;
                    name = key;
                    break;
                }
                case END_OBJECT: {
                    if (null != name) {
                        CIMDataType cdtType = this.getDataTypeFromJSONString(type, array, refClassName);
                        retVal.add(new CIMParameter(name, cdtType, quals != null ? quals.toArray(new CIMQualifier[quals.size()]) : null));
                        name = null;
                        key = null;
                        type = null;
                        array = false;
                        refClassName = null;
                        quals = null;
                        break;
                    }
                    end = true;
                    break;
                }
                case START_ARRAY: {
                    array = true;
                    break;
                }
                case END_ARRAY: {
                    break;
                }
                case VALUE_NUMBER: {
                    break;
                }
                case VALUE_STRING: {
                    String val = parser.getString();
                    if (null == key) break;
                    if ("type".equals(key)) {
                        type = val;
                        break;
                    }
                    if (!"classname".equals(key)) break;
                    refClassName = val;
                    break;
                }
                case VALUE_TRUE: {
                    if (!"array".equals(key)) break;
                    array = true;
                    break;
                }
                case VALUE_FALSE: {
                    break;
                }
                case VALUE_NULL: {
                    break;
                }
                case KEY_NAME: {
                    key = parser.getString();
                    if (!"qualifiers".equals(key)) break;
                    quals = this.parseQualifiers(parser, target);
                    break;
                }
            }
            if (!end) continue;
            break;
        }
        return retVal;
    }

    private ArrayList<CIMClassProperty<?>> parseClassProperties(JsonParser parser, CIMObjectPath target) {
        ArrayList retVal = new ArrayList();
        ArrayList<CIMQualifier<?>> quals = null;
        String key = null;
        String name = null;
        String type = null;
        Object value = null;
        ArrayList<Object> valueArray = new ArrayList<Object>();
        boolean array = false;
        String refClassName = null;
        boolean end = false;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_OBJECT: {
                    if (null == name) {
                        name = key;
                        break;
                    }
                    if (!"instance".equals(type)) break;
                    CIMInstance i = this.parseInstance(null, target, parser);
                    if (array) {
                        valueArray.add(i);
                        break;
                    }
                    value = i;
                    break;
                }
                case END_OBJECT: {
                    if (null != name) {
                        CIMDataType cdtType = this.getDataTypeFromJSONString(type, array, refClassName);
                        value = array ? valueArray.toArray(new Object[valueArray.size()]) : value;
                        retVal.add(new CIMClassProperty(name, cdtType, this.getCIMValue(value, cdtType), quals != null ? quals.toArray(new CIMQualifier[quals.size()]) : null, false, false));
                        name = null;
                        key = null;
                        type = null;
                        value = null;
                        array = false;
                        refClassName = null;
                        quals = null;
                        valueArray = new ArrayList();
                        break;
                    }
                    end = true;
                    break;
                }
                case START_ARRAY: {
                    array = true;
                    break;
                }
                case END_ARRAY: {
                    break;
                }
                case VALUE_NUMBER: {
                    if (array) {
                        valueArray.add(parser.getBigDecimal());
                        break;
                    }
                    value = parser.getBigDecimal();
                    break;
                }
                case VALUE_STRING: {
                    String val = parser.getString();
                    if (null == key) break;
                    if ("type".equals(key)) {
                        type = val;
                        break;
                    }
                    if ("classname".equals(key)) {
                        refClassName = val;
                        break;
                    }
                    if (!"value".equals(key)) break;
                    if (array) {
                        valueArray.add(val);
                        break;
                    }
                    value = val;
                    break;
                }
                case VALUE_TRUE: {
                    if (!"array".equals(key)) break;
                    array = true;
                    break;
                }
                case VALUE_FALSE: {
                    if (array) {
                        valueArray.add(false);
                        break;
                    }
                    value = false;
                    break;
                }
                case VALUE_NULL: {
                    if (array) {
                        valueArray.add(true);
                        break;
                    }
                    value = true;
                    break;
                }
                case KEY_NAME: {
                    key = parser.getString();
                    if (!"qualifiers".equals(key)) break;
                    quals = this.parseQualifiers(parser, target);
                    break;
                }
            }
            if (!end) continue;
            break;
        }
        return retVal;
    }

    private ArrayList<CIMQualifier<?>> parseQualifiers(JsonParser parser, CIMObjectPath target) {
        ArrayList retVal = new ArrayList();
        String key = null;
        String name = null;
        String type = null;
        Object value = null;
        ArrayList<Object> valueArray = new ArrayList<Object>();
        boolean array = false;
        String refClassName = null;
        boolean end = false;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_OBJECT: {
                    if (null == name) {
                        name = key;
                        break;
                    }
                    if (!"instance".equals(type)) break;
                    CIMInstance i = this.parseInstance(null, target, parser);
                    if (array) {
                        valueArray.add(i);
                        break;
                    }
                    value = i;
                    break;
                }
                case END_OBJECT: {
                    if (null != name) {
                        CIMDataType cdtType = this.getDataTypeFromJSONString(type, array, refClassName);
                        value = array ? valueArray.toArray(new Object[valueArray.size()]) : value;
                        retVal.add(new CIMQualifier(name, cdtType, this.getCIMValue(value, cdtType), 0));
                        name = null;
                        key = null;
                        type = null;
                        value = null;
                        array = false;
                        refClassName = null;
                        valueArray = new ArrayList();
                        break;
                    }
                    end = true;
                    break;
                }
                case START_ARRAY: {
                    array = true;
                    break;
                }
                case END_ARRAY: {
                    break;
                }
                case VALUE_NUMBER: {
                    if (array) {
                        valueArray.add(parser.getBigDecimal());
                        break;
                    }
                    value = parser.getBigDecimal();
                    break;
                }
                case VALUE_STRING: {
                    String val = parser.getString();
                    if (null == key) break;
                    if ("type".equals(key)) {
                        type = val;
                        break;
                    }
                    if ("classname".equals(key)) {
                        refClassName = val;
                        break;
                    }
                    if (!"value".equals(key)) break;
                    if (array) {
                        valueArray.add(val);
                        break;
                    }
                    value = val;
                    break;
                }
                case VALUE_TRUE: {
                    if (!"array".equals(key)) break;
                    array = true;
                    break;
                }
                case VALUE_FALSE: {
                    if (array) {
                        valueArray.add(false);
                        break;
                    }
                    value = false;
                    break;
                }
                case VALUE_NULL: {
                    if (array) {
                        valueArray.add(true);
                        break;
                    }
                    value = true;
                    break;
                }
                case KEY_NAME: {
                    key = parser.getString();
                    break;
                }
            }
            if (!end) continue;
            break;
        }
        return retVal;
    }

    public static enum HTTPRequestMethods {
        DELETE,
        GET,
        HEAD,
        OPTIONS,
        POST,
        PUT,
        TRACE;

    }
}

