/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.xmi.metaclass;

import com.ws.cim.xmi.metaclass.XMIPackage;
import com.ws.utilities.Resources;
import java.text.MessageFormat;
import java.util.ArrayList;

public class XMIModel {
    private static final String BUNDLE = "com.ws.cim.xmi.XMIGenerator";
    private final String mName;
    private final ArrayList<XMIPackage> mXMIPackageList;
    private final Resources mResourceHandle;

    public XMIModel(String pName) {
        this.mName = pName;
        this.mResourceHandle = new Resources(BUNDLE);
        this.mXMIPackageList = new ArrayList();
    }

    public String getName() {
        return this.mName;
    }

    public ArrayList<XMIPackage> getPackages() {
        return this.mXMIPackageList;
    }

    public XMIPackage getPackage(String pName) {
        for (XMIPackage p : this.mXMIPackageList) {
            if (!p.getName().equalsIgnoreCase(pName)) continue;
            return p;
        }
        return null;
    }

    public void addPackage(XMIPackage pPackage) {
        this.mXMIPackageList.add(pPackage);
    }

    public boolean isPackageExist(String pPackageName) {
        for (XMIPackage p : this.mXMIPackageList) {
            if (!p.getName().equalsIgnoreCase(pPackageName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return MessageFormat.format(this.mResourceHandle.loadString("UML_PACKAGE"), this.mName, this.getPackagesStr());
    }

    private String getPackagesStr() {
        StringBuilder strPackages = new StringBuilder();
        for (XMIPackage p : this.mXMIPackageList) {
            strPackages.append(p.toString("\n\t\t"));
        }
        return strPackages.toString();
    }
}

