/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints;

import flex.management.ManageableComponent;
import flex.management.runtime.messaging.MessageBrokerControl;
import flex.management.runtime.messaging.endpoints.EndpointControl;
import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.MessageBroker;
import flex.messaging.MessageException;
import flex.messaging.Server;
import flex.messaging.client.FlexClient;
import flex.messaging.client.FlexClientOutboundQueueProcessor;
import flex.messaging.client.FlushResult;
import flex.messaging.client.PollFlushResult;
import flex.messaging.config.ChannelSettings;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationConstants;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.SecurityConstraint;
import flex.messaging.endpoints.Endpoint2;
import flex.messaging.io.ClassAliasRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.TypeMarshaller;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.io.amf.translator.ASTranslator;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.AcknowledgeMessageExt;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.AsyncMessageExt;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.CommandMessageExt;
import flex.messaging.messages.Message;
import flex.messaging.messages.SmallMessage;
import flex.messaging.security.SecurityException;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.StringUtils;
import flex.messaging.validators.DeserializationValidator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractEndpoint
extends ManageableComponent
implements Endpoint2,
ConfigurationConstants {
    public static final String LOG_CATEGORY = "Endpoint.General";
    public static final String HEADER_NAME_CACHE_CONTROL = "Cache-Control";
    public static final String HEADER_NAME_EXPIRES = "Expires";
    public static final String HEADER_NAME_PRAGMA = "Pragma";
    private static final int NONSECURE_PROTOCOL = 10066;
    private static final int REQUIRES_FLEXCLIENT_SUPPORT = 10030;
    private static final int ERR_MSG_INVALID_URL_SCHEME = 11100;
    private static final String SERIALIZATION = "serialization";
    private static final String CREATE_ASOBJECT_FOR_MISSING_TYPE = "create-asobject-for-missing-type";
    private static final String CUSTOM_DESERIALIZER = "custom-deserializer";
    private static final String CUSTOM_SERIALIZER = "custom-serializer";
    private static final String ENABLE_SMALL_MESSAGES = "enable-small-messages";
    private static final String TYPE_MARSHALLER = "type-marshaller";
    private static final String RESTORE_REFERENCES = "restore-references";
    private static final String INSTANTIATE_TYPES = "instantiate-types";
    private static final String SUPPORT_REMOTE_CLASS = "support-remote-class";
    private static final String LEGACY_COLLECTION = "legacy-collection";
    private static final String LEGACY_DICTIONARY = "legacy-dictionary";
    private static final String LEGACY_MAP = "legacy-map";
    private static final String LEGACY_XML = "legacy-xml";
    private static final String LEGACY_XML_NAMESPACES = "legacy-xml-namespaces";
    private static final String LEGACY_THROWABLE = "legacy-throwable";
    private static final String LEGACY_BIG_NUMBERS = "legacy-big-numbers";
    private static final String LEGACY_EXTERNALIZABLE = "legacy-externalizable";
    private static final String ALLOW_XML = "allow-xml";
    private static final String ALLOW_XML_DOCTYPE_DECLARATION = "allow-xml-doctype-declaration";
    private static final String ALLOW_XML_EXTERNAL_ENTITY_EXPANSION = "allow-xml-external-entity-expansion";
    private static final String LOG_PROPERTY_ERRORS = "log-property-errors";
    private static final String IGNORE_PROPERTY_ERRORS = "ignore-property-errors";
    private static final String INCLUDE_READ_ONLY = "include-read-only";
    private static final String GLOBAL_INCLUDE_READ_ONLY = "global-include-read-only";
    private static final String FLEX_CLIENT_OUTBOUND_QUEUE_PROCESSOR = "flex-client-outbound-queue-processor";
    private static final String SHOW_STACKTRACES = "show-stacktraces";
    private static final String MAX_OBJECT_NEST_LEVEL = "max-object-nest-level";
    private static final String MAX_COLLECTION_NEST_LEVEL = "max-collection-nest-level";
    private static final String PREFER_VECTORS = "prefer-vectors";
    protected Set<String> clientLoadBalancingUrls;
    protected String clientType;
    protected int connectTimeoutSeconds;
    protected int requestTimeoutSeconds;
    protected FlexClientOutboundQueueProcessor flexClientOutboundQueueProcessor;
    protected SerializationContext serializationContext;
    protected Class<?> deserializerClass;
    protected Class<?> serializerClass;
    protected TypeMarshaller typeMarshaller;
    protected int port;
    private SecurityConstraint securityConstraint;
    protected String url;
    protected boolean recordMessageSizes;
    protected boolean recordMessageTimes;
    protected boolean remote;
    protected Server server;
    protected boolean serverOnly;
    protected String parsedUrl;
    protected String parsedForContext;
    protected boolean clientContextParsed;
    protected String parsedClientUrl;
    protected Logger log = Log.getLogger((String)this.getLogCategory());
    protected Class<?> flexClientOutboundQueueProcessClass;
    protected ConfigMap flexClientOutboundQueueProcessorConfig;
    protected double messagingVersion = 1.0;

    public AbstractEndpoint() {
        this(false);
    }

    public AbstractEndpoint(boolean enableManagement) {
        super(enableManagement);
        this.serializationContext = new SerializationContext();
    }

    @Override
    public void initialize(String id, ConfigMap properties) {
        ConfigMap serialization;
        block13: {
            super.initialize(id, properties);
            if (properties == null || properties.size() == 0) {
                return;
            }
            this.initializeClientLoadBalancing(id, properties);
            this.connectTimeoutSeconds = properties.getPropertyAsInt("connect-timeout-seconds", 0);
            this.requestTimeoutSeconds = properties.getPropertyAsInt("request-timeout-seconds", 0);
            ConfigMap outboundQueueConfig = properties.getPropertyAsMap(FLEX_CLIENT_OUTBOUND_QUEUE_PROCESSOR, null);
            if (outboundQueueConfig != null) {
                this.flexClientOutboundQueueProcessorConfig = outboundQueueConfig.getPropertyAsMap("properties", null);
                String pClassName = outboundQueueConfig.getPropertyAsString("class", null);
                if (pClassName != null) {
                    try {
                        this.flexClientOutboundQueueProcessClass = this.createClass(pClassName);
                        this.setFlexClientOutboundQueueProcessorConfig(this.flexClientOutboundQueueProcessorConfig);
                    }
                    catch (Throwable t) {
                        if (!Log.isWarn()) break block13;
                        this.log.warn("Cannot register custom FlexClient outbound queue processor class {0}", new Object[]{pClassName}, t);
                    }
                }
            }
        }
        if ((serialization = properties.getPropertyAsMap(SERIALIZATION, null)) != null) {
            block14: {
                String typeMarshallerClassName;
                List serializers;
                List deserializers = serialization.getPropertyAsList(CUSTOM_DESERIALIZER, null);
                if (deserializers != null && Log.isWarn()) {
                    this.log.warn("Endpoint <custom-deserializer> functionality is no longer available. Please remove this entry from your configuration.");
                }
                if ((serializers = serialization.getPropertyAsList(CUSTOM_SERIALIZER, null)) != null && Log.isWarn()) {
                    this.log.warn("Endpoint <custom-serializer> functionality is no longer available. Please remove this entry from your configuration.");
                }
                if ((typeMarshallerClassName = serialization.getPropertyAsString(TYPE_MARSHALLER, null)) != null && typeMarshallerClassName.length() > 0) {
                    try {
                        Class<?> tmc = this.createClass(typeMarshallerClassName);
                        this.typeMarshaller = (TypeMarshaller)ClassUtil.createDefaultInstance(tmc, TypeMarshaller.class);
                    }
                    catch (Throwable t) {
                        if (!Log.isWarn()) break block14;
                        this.log.warn("Cannot register custom type marshaller for type {0}", new Object[]{typeMarshallerClassName}, t);
                    }
                }
            }
            this.serializationContext.createASObjectForMissingType = serialization.getPropertyAsBoolean(CREATE_ASOBJECT_FOR_MISSING_TYPE, false);
            this.serializationContext.enableSmallMessages = serialization.getPropertyAsBoolean(ENABLE_SMALL_MESSAGES, true);
            this.serializationContext.instantiateTypes = serialization.getPropertyAsBoolean(INSTANTIATE_TYPES, true);
            this.serializationContext.supportRemoteClass = serialization.getPropertyAsBoolean(SUPPORT_REMOTE_CLASS, false);
            this.serializationContext.legacyCollection = serialization.getPropertyAsBoolean(LEGACY_COLLECTION, false);
            this.serializationContext.legacyDictionary = serialization.getPropertyAsBoolean(LEGACY_DICTIONARY, false);
            this.serializationContext.legacyMap = serialization.getPropertyAsBoolean(LEGACY_MAP, false);
            this.serializationContext.legacyXMLDocument = serialization.getPropertyAsBoolean(LEGACY_XML, false);
            this.serializationContext.legacyXMLNamespaces = serialization.getPropertyAsBoolean(LEGACY_XML_NAMESPACES, false);
            this.serializationContext.legacyThrowable = serialization.getPropertyAsBoolean(LEGACY_THROWABLE, false);
            this.serializationContext.legacyBigNumbers = serialization.getPropertyAsBoolean(LEGACY_BIG_NUMBERS, false);
            this.serializationContext.legacyExternalizable = serialization.getPropertyAsBoolean(LEGACY_EXTERNALIZABLE, false);
            this.serializationContext.allowXml = serialization.getPropertyAsBoolean(ALLOW_XML, false);
            this.serializationContext.allowXmlDoctypeDeclaration = serialization.getPropertyAsBoolean(ALLOW_XML_DOCTYPE_DECLARATION, false);
            this.serializationContext.allowXmlExternalEntityExpansion = serialization.getPropertyAsBoolean(ALLOW_XML_EXTERNAL_ENTITY_EXPANSION, false);
            this.serializationContext.maxObjectNestLevel = (int)serialization.getPropertyAsLong(MAX_OBJECT_NEST_LEVEL, 512L);
            this.serializationContext.maxCollectionNestLevel = (int)serialization.getPropertyAsLong(MAX_COLLECTION_NEST_LEVEL, 15L);
            this.serializationContext.preferVectors = serialization.getPropertyAsBoolean(PREFER_VECTORS, false);
            boolean showStacktraces = serialization.getPropertyAsBoolean(SHOW_STACKTRACES, false);
            if (showStacktraces && Log.isWarn()) {
                this.log.warn("The show-stacktraces configuration option is deprecated and non-functional. Please remove this from your configuration file.");
            }
            this.serializationContext.restoreReferences = serialization.getPropertyAsBoolean(RESTORE_REFERENCES, false);
            this.serializationContext.logPropertyErrors = serialization.getPropertyAsBoolean(LOG_PROPERTY_ERRORS, false);
            this.serializationContext.ignorePropertyErrors = serialization.getPropertyAsBoolean(IGNORE_PROPERTY_ERRORS, true);
            this.serializationContext.includeReadOnly = serialization.getPropertyAsBoolean(INCLUDE_READ_ONLY, false);
        }
        this.recordMessageSizes = properties.getPropertyAsBoolean("record-message-sizes", false);
        if (this.recordMessageSizes && Log.isWarn()) {
            this.log.warn("Setting <record-message-sizes> to true affects application performance and should only be used for debugging");
        }
        this.recordMessageTimes = properties.getPropertyAsBoolean("record-message-times", false);
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        MessageBroker broker = this.getMessageBroker();
        if (!broker.isStarted()) {
            if (Log.isWarn()) {
                Log.getLogger((String)this.getLogCategory()).warn("Endpoint with id '{0}' cannot be started when the MessageBroker is not started.", new Object[]{this.getId()});
            }
            return;
        }
        if (this.isManaged() && broker.isManaged()) {
            this.setupEndpointControl(broker);
            MessageBrokerControl controller = (MessageBrokerControl)broker.getControl();
            if (this.getControl() != null) {
                controller.addEndpoint(this);
            }
        }
        if (this.deserializerClass == null) {
            this.deserializerClass = this.createClass(this.getDeserializerClassName());
        }
        if (this.serializerClass == null) {
            this.serializerClass = this.createClass(this.getSerializerClassName());
        }
        this.serializationContext.setDeserializerClass(this.deserializerClass);
        this.serializationContext.setSerializerClass(this.serializerClass);
        ClassAliasRegistry registry = ClassAliasRegistry.getRegistry();
        registry.registerAlias("DSA", AsyncMessageExt.class.getName());
        registry.registerAlias("DSK", AcknowledgeMessageExt.class.getName());
        registry.registerAlias("DSC", CommandMessageExt.class.getName());
        super.start();
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        if (this.isManaged() && this.getMessageBroker().isManaged()) {
            if (this.getControl() != null) {
                this.getControl().unregister();
                this.setControl(null);
            }
            this.setManaged(false);
        }
    }

    public boolean addClientLoadBalancingUrl(String url) {
        if (this.clientLoadBalancingUrls == null) {
            this.clientLoadBalancingUrls = new HashSet<String>();
        }
        if (url == null || url.length() == 0) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(11142, new Object[]{"client-load-balancing", this.getId()});
            throw ce;
        }
        return this.clientLoadBalancingUrls.add(url);
    }

    public boolean removeClientLoadBalancingUrl(String url) {
        if (this.clientLoadBalancingUrls != null) {
            return this.clientLoadBalancingUrls.remove(url);
        }
        return false;
    }

    public Set<String> getClientLoadBalancingUrls() {
        return this.clientLoadBalancingUrls == null ? null : new HashSet<String>(this.clientLoadBalancingUrls);
    }

    @Override
    public String getClientType() {
        return this.clientType;
    }

    @Override
    public void setClientType(String type) {
        this.clientType = type;
    }

    public Class<?> getFlexClientOutboundQueueProcessorClass() {
        return this.flexClientOutboundQueueProcessClass;
    }

    public void setFlexClientOutboundQueueProcessorClass(Class<?> flexClientOutboundQueueProcessorClass) {
        this.flexClientOutboundQueueProcessClass = flexClientOutboundQueueProcessorClass;
        if (this.flexClientOutboundQueueProcessClass != null && this.flexClientOutboundQueueProcessorConfig != null) {
            FlexClientOutboundQueueProcessor processor = (FlexClientOutboundQueueProcessor)ClassUtil.createDefaultInstance(this.flexClientOutboundQueueProcessClass, null);
            processor.initialize(this.flexClientOutboundQueueProcessorConfig);
        }
    }

    public ConfigMap getFlexClientOutboundQueueProcessorConfig() {
        return this.flexClientOutboundQueueProcessorConfig;
    }

    public void setFlexClientOutboundQueueProcessorConfig(ConfigMap flexClientOutboundQueueProcessorConfig) {
        this.flexClientOutboundQueueProcessorConfig = flexClientOutboundQueueProcessorConfig;
        if (flexClientOutboundQueueProcessorConfig != null && this.flexClientOutboundQueueProcessClass != null) {
            FlexClientOutboundQueueProcessor processor = (FlexClientOutboundQueueProcessor)ClassUtil.createDefaultInstance(this.flexClientOutboundQueueProcessClass, null);
            processor.initialize(flexClientOutboundQueueProcessorConfig);
        }
    }

    @Override
    public void setId(String id) {
        String oldId = this.getId();
        if (oldId != null && oldId.equals(id)) {
            return;
        }
        super.setId(id);
        MessageBroker broker = this.getMessageBroker();
        if (broker != null) {
            broker.removeEndpoint(oldId);
            broker.addEndpoint(this);
        }
    }

    @Override
    public MessageBroker getMessageBroker() {
        return (MessageBroker)this.getParent();
    }

    @Override
    public void setMessageBroker(MessageBroker broker) {
        MessageBroker oldBroker = this.getMessageBroker();
        this.setParent(broker);
        if (oldBroker != null) {
            oldBroker.removeEndpoint(this.getId());
        }
        if (broker.getEndpoint(this.getId()) != this) {
            broker.addEndpoint(this);
        }
    }

    @Override
    public double getMessagingVersion() {
        return this.messagingVersion;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean value) {
        this.remote = value;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
    }

    public boolean getServerOnly() {
        return this.serverOnly;
    }

    public void setServerOnly(boolean serverOnly) {
        this.serverOnly = serverOnly;
    }

    @Override
    public SecurityConstraint getSecurityConstraint() {
        return this.securityConstraint;
    }

    @Override
    public void setSecurityConstraint(SecurityConstraint securityConstraint) {
        this.securityConstraint = securityConstraint;
    }

    public SerializationContext getSerializationContext() {
        return this.serializationContext;
    }

    public void setSerializationContext(SerializationContext serializationContext) {
        this.serializationContext = serializationContext;
    }

    public TypeMarshaller getTypeMarshaller() {
        if (this.typeMarshaller == null) {
            this.typeMarshaller = new ASTranslator();
        }
        return this.typeMarshaller;
    }

    public void setTypeMarshaller(TypeMarshaller typeMarshaller) {
        this.typeMarshaller = typeMarshaller;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
        this.port = this.internalParsePort(url);
        this.parsedForContext = null;
        this.clientContextParsed = false;
    }

    @Override
    public String getUrlForClient() {
        if (!this.clientContextParsed) {
            HttpServletRequest req = FlexContext.getHttpRequest();
            if (req != null) {
                String contextPath = req.getContextPath();
                this.parseClientUrl(contextPath);
            } else {
                return this.url;
            }
        }
        return this.parsedClientUrl;
    }

    public long getThroughput() {
        EndpointControl control = (EndpointControl)this.getControl();
        return control.getBytesDeserialized() + control.getBytesSerialized();
    }

    public static void addNoCacheHeaders(HttpServletRequest req, HttpServletResponse res) {
        String userAgent = req.getHeader("User-Agent");
        if (req.isSecure() && userAgent != null && userAgent.indexOf("MSIE") != -1) {
            res.addHeader(HEADER_NAME_CACHE_CONTROL, "no-store, no-cache, must-revalidate, post-check=0, pre-check=0, no-transform, private");
        } else {
            res.addHeader(HEADER_NAME_CACHE_CONTROL, "no-cache");
        }
        res.setDateHeader(HEADER_NAME_EXPIRES, 946080000000L);
        if (!req.isSecure() || userAgent == null || userAgent.indexOf("MSIE") == -1) {
            res.setHeader(HEADER_NAME_PRAGMA, "no-cache");
        }
    }

    public Message convertToSmallMessage(Message message) {
        Message smallMessage;
        if (message instanceof SmallMessage && (smallMessage = ((SmallMessage)message).getSmallMessage()) != null) {
            message = smallMessage;
        }
        return message;
    }

    @Override
    public ConfigMap describeEndpoint() {
        boolean containsClientLoadBalancing;
        ConfigMap channelConfig = new ConfigMap();
        if (this.serverOnly) {
            return channelConfig;
        }
        channelConfig.addProperty("id", this.getId());
        channelConfig.addProperty("type", this.getClientType());
        ConfigMap properties = new ConfigMap();
        boolean bl = containsClientLoadBalancing = this.clientLoadBalancingUrls != null && !this.clientLoadBalancingUrls.isEmpty();
        if (containsClientLoadBalancing) {
            ConfigMap clientLoadBalancing = new ConfigMap();
            Iterator<String> iterator = this.clientLoadBalancingUrls.iterator();
            while (iterator.hasNext()) {
                ConfigMap url = new ConfigMap();
                url.addProperty("", iterator.next());
                clientLoadBalancing.addProperty("url", url);
            }
            properties.addProperty("client-load-balancing", clientLoadBalancing);
        }
        if (!containsClientLoadBalancing) {
            ConfigMap endpointConfig = new ConfigMap();
            endpointConfig.addProperty("uri", this.getUrlForClient());
            channelConfig.addProperty("endpoint", endpointConfig);
        }
        if (this.connectTimeoutSeconds > 0) {
            ConfigMap connectTimeoutConfig = new ConfigMap();
            connectTimeoutConfig.addProperty("", String.valueOf(this.connectTimeoutSeconds));
            properties.addProperty("connect-timeout-seconds", connectTimeoutConfig);
        }
        if (this.requestTimeoutSeconds > 0) {
            ConfigMap requestTimeoutSeconds = new ConfigMap();
            requestTimeoutSeconds.addProperty("", String.valueOf(requestTimeoutSeconds));
            properties.addProperty("request-timeout-seconds", requestTimeoutSeconds);
        }
        if (this.recordMessageTimes) {
            ConfigMap recordMessageTimesMap = new ConfigMap();
            recordMessageTimesMap.addProperty("", "true");
            properties.addProperty("record-message-times", recordMessageTimesMap);
        }
        if (this.recordMessageSizes) {
            ConfigMap recordMessageSizesMap = new ConfigMap();
            recordMessageSizesMap.addProperty("", "true");
            properties.addProperty("record-message-sizes", recordMessageSizesMap);
        }
        ConfigMap serialization = new ConfigMap();
        serialization.addProperty(ENABLE_SMALL_MESSAGES, Boolean.toString(this.serializationContext.enableSmallMessages));
        properties.addProperty(SERIALIZATION, serialization);
        if (properties.size() > 0) {
            channelConfig.addProperty("properties", properties);
        }
        return channelConfig;
    }

    @Override
    public String getParsedUrl(String contextPath) {
        this.parseUrl(contextPath);
        return this.parsedUrl;
    }

    public void handleClientMessagingVersion(Number version) {
        if (version != null) {
            FlexSession session;
            boolean clientSupportsSmallMessages;
            boolean bl = clientSupportsSmallMessages = version.doubleValue() >= this.messagingVersion;
            if (clientSupportsSmallMessages && this.getSerializationContext().enableSmallMessages && (session = FlexContext.getFlexSession()) != null) {
                session.setUseSmallMessages(true);
            }
        }
    }

    @Override
    public void service(HttpServletRequest req, HttpServletResponse res) {
        this.validateRequestProtocol(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message serviceMessage(Message message) {
        if (this.isManaged()) {
            ((EndpointControl)this.getControl()).incrementServiceMessageCount();
        }
        try {
            FlexContext.setThreadLocalEndpoint(this);
            Message ack = null;
            if (message.getTimestamp() == 0L) {
                message.setTimestamp(System.currentTimeMillis());
            }
            if (message.getHeader("DSEndpoint") != null) {
                message.setHeader("DSValidateEndpoint", Boolean.TRUE);
            }
            message.setHeader("DSEndpoint", this.getId());
            if (message instanceof CommandMessage) {
                CommandMessage command = (CommandMessage)message;
                int operation = command.getOperation();
                if (operation != 8) {
                    this.checkSecurityConstraint(message);
                }
                if (operation == 2 && message.getClientId() == null) {
                    this.verifyFlexClientSupport(command);
                    FlexClient flexClient = FlexContext.getFlexClient();
                    ack = this.handleFlexClientPollCommand(flexClient, command);
                } else if (operation == 12) {
                    ack = this.handleChannelDisconnect(command);
                } else if (operation == 13) {
                    ConfigMap serverConfig;
                    ack = new AcknowledgeMessage();
                    ((AsyncMessage)ack).setCorrelationId(message.getMessageId());
                    boolean needsConfig = false;
                    if (command.getHeader("DSNeedsConfig") != null) {
                        needsConfig = (Boolean)command.getHeader("DSNeedsConfig");
                    }
                    if (needsConfig && (serverConfig = this.getMessageBroker().describeServices(this)).size() > 0) {
                        ack.setBody(serverConfig);
                    }
                } else {
                    if (operation == 0 || operation == 2) {
                        this.verifyFlexClientSupport(command);
                    }
                    ack = this.getMessageBroker().routeCommandToService((CommandMessage)message, this);
                    if (operation == 5 || operation == 8) {
                        Number clientVersion = (Number)command.getHeader("DSMessagingVersion");
                        this.handleClientMessagingVersion(clientVersion);
                        ack.setHeader("DSMessagingVersion", new Double(this.messagingVersion));
                    }
                }
            } else {
                if (message instanceof AsyncMessage) {
                    this.verifyFlexClientSupport(message);
                }
                this.checkSecurityConstraint(message);
                ack = this.getMessageBroker().routeMessageToService(message, this);
            }
            AcknowledgeMessage acknowledgeMessage = ack;
            return acknowledgeMessage;
        }
        finally {
            FlexContext.setThreadLocalEndpoint(null);
        }
    }

    public FlexClient setupFlexClient(Message message) {
        FlexClient flexClient = null;
        if (message.getHeaders().containsKey("DSId")) {
            String id = (String)message.getHeaders().get("DSId");
            if (id == null) {
                id = "nil";
            }
            flexClient = this.setupFlexClient(id);
        }
        return flexClient;
    }

    public FlexClient setupFlexClient(String id) {
        FlexClient flexClient = null;
        if (id != null) {
            if (id.equals("nil")) {
                id = null;
            }
            flexClient = this.getMessageBroker().getFlexClientManager().getFlexClient(id);
            FlexSession session = FlexContext.getFlexSession();
            flexClient.registerFlexSession(session);
            FlexContext.setThreadLocalFlexClient(flexClient);
        }
        return flexClient;
    }

    public boolean isRecordMessageSizes() {
        return this.recordMessageSizes;
    }

    public boolean isRecordMessageTimes() {
        return this.recordMessageTimes;
    }

    public void setThreadLocals() {
        if (this.serializationContext != null) {
            SerializationContext context = (SerializationContext)this.serializationContext.clone();
            MessageBroker broker = this.getMessageBroker();
            DeserializationValidator validator = broker == null ? null : broker.getDeserializationValidator();
            context.setDeserializationValidator(validator);
            SerializationContext.setSerializationContext(context);
        }
        TypeMarshallingContext.setTypeMarshaller(this.getTypeMarshaller());
    }

    public void clearThreadLocals() {
        SerializationContext.clearThreadLocalObjects();
        TypeMarshallingContext.clearThreadLocalObjects();
    }

    @Override
    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected Message handleChannelDisconnect(CommandMessage disconnectCommand) {
        return new AcknowledgeMessage();
    }

    protected FlushResult handleFlexClientPoll(FlexClient flexClient, CommandMessage pollCommand) {
        return flexClient.poll(this.getId());
    }

    protected Message handleFlexClientPollCommand(FlexClient flexClient, CommandMessage pollCommand) {
        int nextFlushWaitTime;
        if (Log.isDebug()) {
            Log.getLogger((String)this.getMessageBroker().getLogCategory(pollCommand)).debug("Before handling general client poll request. " + StringUtils.NEWLINE + "  incomingMessage: " + pollCommand + StringUtils.NEWLINE);
        }
        FlushResult flushResult = this.handleFlexClientPoll(flexClient, pollCommand);
        AsyncMessage pollResponse = null;
        if (flushResult instanceof PollFlushResult && ((PollFlushResult)flushResult).isClientProcessingSuppressed()) {
            pollResponse = new CommandMessage(4);
            pollResponse.setHeader("DSNoOpPoll", Boolean.TRUE);
        }
        if (pollResponse == null) {
            List<Message> messagesToReturn;
            List<Message> list = messagesToReturn = flushResult != null ? flushResult.getMessages() : null;
            if (messagesToReturn != null && !messagesToReturn.isEmpty()) {
                pollResponse = new CommandMessage(4);
                pollResponse.setBody(messagesToReturn.toArray());
            } else {
                pollResponse = new AcknowledgeMessage();
            }
        }
        if (flushResult != null && (nextFlushWaitTime = flushResult.getNextFlushWaitTimeMillis()) > 0) {
            pollResponse.setHeader("DSPollWait", new Integer(nextFlushWaitTime));
        }
        if (Log.isDebug()) {
            String debugPollResult = Log.getPrettyPrinter().prettify((Object)pollResponse);
            Log.getLogger((String)this.getMessageBroker().getLogCategory(pollCommand)).debug("After handling general client poll request. " + StringUtils.NEWLINE + "  reply: " + debugPollResult + StringUtils.NEWLINE);
        }
        return pollResponse;
    }

    protected void initializeClientLoadBalancing(String id, ConfigMap properties) {
        if (!properties.containsKey((Object)"client-load-balancing")) {
            return;
        }
        ConfigMap clientLoadBalancing = properties.getPropertyAsMap("client-load-balancing", null);
        if (clientLoadBalancing == null) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(11141, new Object[]{"client-load-balancing", this.getId()});
            throw ce;
        }
        List urls = clientLoadBalancing.getPropertyAsList("url", null);
        if (urls == null || urls.isEmpty()) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(11141, new Object[]{"client-load-balancing", this.getId()});
            throw ce;
        }
        for (String url : urls) {
            if (this.addClientLoadBalancingUrl(url) || !Log.isWarn()) continue;
            this.log.warn("Endpoint '{0}' is ignoring the url '{1}' as it's already in the set of client-load-balancing urls.", new Object[]{id, url});
        }
    }

    protected void checkSecurityConstraint(Message message) {
        if (this.securityConstraint != null) {
            this.getMessageBroker().getLoginManager().checkConstraint(this.securityConstraint);
        }
    }

    protected abstract String getDeserializerClassName();

    protected abstract String getSerializerClassName();

    protected abstract String getSecureProtocolScheme();

    protected abstract String getInsecureProtocolScheme();

    protected abstract void setupEndpointControl(MessageBroker var1);

    protected void validateEndpointProtocol() {
        String scheme;
        String string = scheme = this.isSecure() ? this.getSecureProtocolScheme() : this.getInsecureProtocolScheme();
        if (!this.url.startsWith(scheme)) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(11100, new Object[]{this.url, scheme});
            throw ce;
        }
    }

    protected void validateRequestProtocol(HttpServletRequest req) {
        boolean secure = req.isSecure();
        if (!secure && this.isSecure()) {
            String endpointPath = req.getServletPath() + req.getPathInfo();
            SecurityException se = new SecurityException();
            se.setMessage(10066, new Object[]{endpointPath});
            throw se;
        }
    }

    protected void verifyFlexClientSupport(Message message) {
        if (FlexContext.getFlexClient() == null) {
            MessageException me = new MessageException();
            me.setMessage(10030, new Object[]{message.getDestination()});
            throw me;
        }
    }

    protected Class<?> createClass(String className) {
        return ClassUtil.createClass(className, FlexContext.getMessageBroker() == null ? null : FlexContext.getMessageBroker().getClassLoader());
    }

    private void parseClientUrl(String contextPath) {
        if (!this.clientContextParsed) {
            String channelEndpoint = this.url.trim();
            channelEndpoint = StringUtils.substitute((String)channelEndpoint, (String)"{context-root}", (String)"{context.root}");
            if (contextPath == null && channelEndpoint.indexOf("{context.root}") != -1) {
                ConfigurationException e = new ConfigurationException();
                e.setMessage(11120, new Object[]{this.getId()});
                throw e;
            }
            if (contextPath != null && !contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            if (channelEndpoint.indexOf("/{context.root}") != -1) {
                if ("/".equals(contextPath) && !"/{context.root}".equals(channelEndpoint)) {
                    contextPath = "";
                }
                channelEndpoint = StringUtils.substitute((String)channelEndpoint, (String)"/{context.root}", (String)contextPath);
            } else {
                if ("/".equals(contextPath) && !"{context.root}".equals(channelEndpoint)) {
                    contextPath = "";
                }
                channelEndpoint = StringUtils.substitute((String)channelEndpoint, (String)"{context.root}", (String)contextPath);
            }
            this.parsedClientUrl = channelEndpoint;
            this.clientContextParsed = true;
        }
    }

    private int internalParsePort(String url) {
        int port = ChannelSettings.parsePort((String)url);
        if (port == 0 && Log.isInfo()) {
            this.log.info("No port specified in channel URL:  {0}", new Object[]{url});
        }
        return port == -1 ? 0 : port;
    }

    private void parseUrl(String contextPath) {
        if (this.parsedForContext == null || !this.parsedForContext.equals(contextPath)) {
            int nextSlash;
            String channelEndpoint = this.url.toLowerCase().trim();
            String insecureProtocol = this.getInsecureProtocolScheme() + "://";
            String secureProtocol = this.getSecureProtocolScheme() + "://";
            if ((channelEndpoint.startsWith(secureProtocol) || channelEndpoint.startsWith(insecureProtocol)) && (nextSlash = channelEndpoint.indexOf(47, 8)) > 0) {
                channelEndpoint = channelEndpoint.substring(nextSlash);
            }
            if ((channelEndpoint = StringUtils.substitute((String)channelEndpoint, (String)"{context-root}", (String)"{context.root}")).startsWith("{context.root}")) {
                channelEndpoint = channelEndpoint.substring("{context.root}".length());
            } else if (channelEndpoint.startsWith("/{context.root}")) {
                channelEndpoint = channelEndpoint.substring("/{context.root}".length());
            } else if (contextPath.length() > 0 && channelEndpoint.startsWith(contextPath.toLowerCase())) {
                channelEndpoint = channelEndpoint.substring(contextPath.length());
            }
            if (channelEndpoint.endsWith("/")) {
                channelEndpoint = channelEndpoint.substring(0, channelEndpoint.length() - 1);
            }
            this.parsedUrl = channelEndpoint;
            this.parsedForContext = contextPath;
        }
    }
}

