/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.mof;

import com.ws.cim.mof.MOFComments;
import com.ws.cim.mof.MOFCommentsClass;
import com.ws.cim.mof.MOFCommentsMethod;
import com.ws.cim.mof.MOFStyleQualifiers;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMInstance;
import javax.cim.CIMMethod;
import javax.cim.CIMObjectPath;
import javax.cim.CIMParameter;
import javax.cim.CIMProperty;
import javax.cim.CIMQualifier;
import javax.cim.CIMQualifierType;
import javax.cim.CIMScope;

abstract class MOFStyleBase {
    protected static final char CLOSEBRACE = '}';
    protected static final char COLON = ':';
    protected static final char DELIMITER = ',';
    protected static final String INDENT = "   ";
    protected static final char NEWLINE = '\n';
    protected static final char OPENBRACE = '{';
    protected static final char QUOTE = '\"';
    protected static final char SEMICOLON = ';';
    protected static final char SINGLEQUOTE = '\'';
    protected static final char SPACE = ' ';

    MOFStyleBase() {
    }

    protected static String escape(String str) throws IllegalArgumentException {
        int size = str.length();
        StringBuilder sb = new StringBuilder(size);
        block11: for (int i = 0; i < size; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\u0000': {
                    continue block11;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block11;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block11;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block11;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block11;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block11;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block11;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block11;
                }
                default: {
                    ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = Integer.toString(ch, 16);
                        sb.append("\\x" + "0000".substring(s.length() - 4) + s);
                        continue block11;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    protected String generateArgumentMOF(CIMArgument<?> argument) {
        StringBuilder buffer = new StringBuilder(argument.getName());
        buffer.append('\n');
        buffer.append('{');
        buffer.append('\n');
        buffer.append('\n');
        Object value = argument.getValue();
        if (value != null) {
            if (argument.getDataType().isArray()) {
                buffer.append('{');
            }
            buffer.append(this.generateValueMOF(value, argument.getDataType()));
            if (argument.getDataType().isArray()) {
                buffer.append('}');
            }
        }
        buffer.append('\n');
        buffer.append('}');
        return buffer.toString();
    }

    protected String generateArrayMOFString(Object[] objArray, String indent, boolean bracketed, boolean delimited, boolean lf) {
        StringBuilder retString = new StringBuilder();
        if (objArray != null && objArray.length > 0) {
            if (bracketed) {
                retString.append(indent);
                retString.append('[');
            }
            for (int i = 0; i < objArray.length; ++i) {
                Object obj;
                if (i > 0) {
                    if (delimited) {
                        retString.append(',');
                        retString.append(' ');
                    }
                    if (lf) {
                        retString.append('\n');
                        retString.append(indent);
                    }
                }
                if ((obj = objArray[i]) instanceof String || obj instanceof CIMObjectPath) {
                    retString.append('\"');
                    retString.append(MOFStyleBase.escape(obj.toString()));
                    retString.append('\"');
                    continue;
                }
                if (obj instanceof Character) {
                    retString.append('\'');
                    retString.append(MOFStyleBase.escape(obj.toString()));
                    retString.append('\'');
                    continue;
                }
                retString.append(this.generateMOF(obj));
            }
            if (bracketed) {
                retString.append("]");
                if (lf) {
                    retString.append('\n');
                }
            }
        }
        return retString.toString();
    }

    protected String generateClassMOF(CIMClass cc, MOFCommentsClass comments) {
        CIMMethod<?>[] methods;
        CIMClassProperty<?>[] properties;
        StringBuilder buffer = new StringBuilder();
        if (null != comments && null != comments.getPreComment()) {
            buffer.append(comments.getPreComment());
        }
        buffer.append(this.formatQualifiers(cc.getQualifiers(), INDENT, comments));
        buffer.append("class");
        buffer.append(' ');
        buffer.append(cc.getName());
        buffer.append(' ');
        if (cc.getSuperClassName() != null && cc.getSuperClassName().length() > 0) {
            buffer.append(':');
            buffer.append(' ');
            buffer.append(cc.getSuperClassName());
            buffer.append(' ');
        }
        buffer.append("{");
        buffer.append('\n');
        buffer.append('\n');
        for (CIMClassProperty<?> p : properties = cc.getProperties()) {
            buffer.append(this.generateClassPropertyMOF(p, null == comments ? null : comments.getMethodComments(p.getName())));
            buffer.append('\n');
        }
        buffer.append('\n');
        for (CIMMethod<?> m : methods = cc.getMethods()) {
            buffer.append(this.generateMethodMOF(m, null == comments ? null : comments.getMethodComments(m.getName())));
            buffer.append('\n');
        }
        buffer.append("};");
        return buffer.toString();
    }

    protected String generateClassPropertyMOF(CIMClassProperty<?> cp, MOFComments comments) {
        String name = cp.getName();
        if (name == null || name.length() == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        CIMDataType cdt = cp.getDataType();
        buffer.append(this.formatQualifiers(cp.getQualifiers(), "      ", comments));
        buffer.append(INDENT);
        buffer.append(this.generateDataTypeMOF(cdt));
        buffer.append(' ');
        buffer.append(name);
        if (cdt != null && cdt.isArray()) {
            buffer.append("[]");
        }
        if (cp.getValue() != null && cp.getDataType().getType() != 14) {
            if (cp.getDataType().isArray()) {
                Object value = cp.getValue();
                Object[] valArray = (Object[])value;
                if (valArray.length > 0) {
                    buffer.append(" = ");
                    buffer.append('{');
                    buffer.append(this.generateValueMOF(value, cp.getDataType()));
                    buffer.append('}');
                }
            } else {
                buffer.append(" = ");
                Object value = cp.getValue();
                if (value == null) {
                    buffer.append("null");
                } else {
                    buffer.append(this.generateValueMOF(value, cp.getDataType()));
                }
            }
        }
        buffer.append(";");
        buffer.append('\n');
        return buffer.toString();
    }

    protected String generatePropertyMOF(CIMProperty<?> cp, MOFComments comments) {
        String precomments;
        String name = cp.getName();
        if (name == null || name.length() == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        if (null != comments && null != (precomments = comments.getPreComment()) && !precomments.equals("")) {
            buffer.append(comments);
        }
        buffer.append(INDENT);
        buffer.append(name);
        buffer.append(" = ");
        Object value = cp.getValue();
        if (value == null) {
            buffer.append("null");
        } else if (cp.getDataType().isArray()) {
            Object[] valArray = (Object[])value;
            if (valArray.length > 0) {
                buffer.append('{');
                buffer.append(this.generateValueMOF(value, cp.getDataType()));
                buffer.append('}');
            } else {
                buffer.append("null");
            }
        } else {
            buffer.append(this.generateValueMOF(value, cp.getDataType()));
        }
        buffer.append(";");
        buffer.append('\n');
        return buffer.toString();
    }

    protected String generateDataTypeMOF(CIMDataType cdt) {
        if (null == cdt) {
            throw new IllegalArgumentException();
        }
        switch (cdt.getType()) {
            case 0: {
                return "uint8";
            }
            case 1: {
                return "sint8";
            }
            case 2: {
                return "uint16";
            }
            case 3: {
                return "sint16";
            }
            case 4: {
                return "uint32";
            }
            case 5: {
                return "sint32";
            }
            case 6: {
                return "uint64";
            }
            case 7: {
                return "sint64";
            }
            case 10: {
                return "real32";
            }
            case 11: {
                return "real64";
            }
            case 8: 
            case 15: {
                return "string";
            }
            case 13: {
                return "char16";
            }
            case 12: {
                return "datetime";
            }
            case 9: {
                return "boolean";
            }
            case 16: {
                return "null";
            }
            case 14: {
                return cdt.getRefClassName() + ' ' + "REF";
            }
        }
        throw new IllegalArgumentException();
    }

    protected String generateDateTimeMOF(CIMDateTime cdt) {
        if (null == cdt) {
            throw new IllegalArgumentException();
        }
        StringBuilder b = new StringBuilder();
        b.append('\"');
        b.append(cdt.getDateTimeString());
        b.append('\"');
        return b.toString();
    }

    protected String generateInstanceMOF(CIMInstance ci) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("instance");
        buffer.append(' ');
        buffer.append("of");
        buffer.append(' ');
        buffer.append(ci.getClassName());
        buffer.append(' ');
        buffer.append('{');
        buffer.append('\n');
        Object[] properties = ci.getProperties();
        if (properties.length > 0) {
            buffer.append(this.generateArrayMOFString(properties, "", false, false, false));
        }
        buffer.append('}');
        buffer.append(';');
        return buffer.toString();
    }

    protected String generateMethodMOF(CIMMethod<?> cm, MOFCommentsMethod comments) {
        String preComment;
        String name = cm.getName();
        if (name == null || name.length() == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        if (null != comments && null != (preComment = comments.getPreComment()) && !preComment.equals("")) {
            buffer.append(comments);
        }
        buffer.append(this.formatQualifiers(cm.getQualifiers(), "      ", comments));
        buffer.append(INDENT);
        buffer.append(cm.getDataType());
        buffer.append(' ');
        buffer.append(name);
        buffer.append('(');
        buffer.append('\n');
        buffer.append(this.generateArrayMOFString(cm.getParameters(), "", false, true, true));
        buffer.append(")");
        buffer.append(';');
        buffer.append('\n');
        return buffer.toString();
    }

    public abstract String generateMOF(Object var1);

    protected String generateParameterMOF(CIMParameter<?> cp, MOFComments comment) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.formatQualifiers(cp.getQualifiers(), "         ", comment));
        buffer.append("      ");
        buffer.append(cp.getDataType());
        buffer.append(' ');
        buffer.append(cp.getName());
        if (cp.getDataType() != null && cp.getDataType().isArray()) {
            buffer.append("[]");
        }
        return buffer.toString();
    }

    protected String generateQualifierTypeMOF(CIMQualifierType<?> cqt, MOFComments comments) {
        StringBuilder buffer = new StringBuilder();
        if (null != comments && !"".equals(comments.getPreComment())) {
            buffer.append(comments.getPreComment());
            buffer.append('\n');
        }
        buffer.append("Qualifier");
        buffer.append(' ');
        buffer.append(cqt.getName());
        buffer.append(" : ");
        buffer.append(cqt.getDataType());
        if (cqt.getDataType().isArray()) {
            buffer.append("[]");
        } else {
            buffer.append(" = ");
            buffer.append(this.generateValueMOF(cqt.getValue(), cqt.getDataType()));
        }
        buffer.append(", ");
        buffer.append('\n');
        if (cqt.getScope() != 0) {
            buffer.append("    ");
            buffer.append("Scope");
            buffer.append('(');
            int scope = cqt.getScope();
            if (scope == 127) {
                buffer.append("any");
            } else {
                int i;
                int[] scopes = CIMScope.getScopes();
                ArrayList<String> list = new ArrayList<String>();
                for (i = 0; i < scopes.length; ++i) {
                    if ((scope & scopes[i]) != scopes[i]) continue;
                    list.add(this.generateScopeMOF(scopes[i]));
                }
                for (i = 0; i < list.size(); ++i) {
                    buffer.append((String)list.get(i));
                    if (i + 1 == list.size()) continue;
                    buffer.append(", ");
                }
            }
            buffer.append(')');
        }
        if (cqt.getFlavor() != 0) {
            buffer.append(", ");
            buffer.append('\n');
            buffer.append("    ");
            buffer.append("Flavor");
            buffer.append('(');
            int flavor = cqt.getFlavor();
            ArrayList<String> list = new ArrayList<String>();
            if ((flavor & 1) == 1) {
                list.add("DisableOverride");
            } else {
                list.add("EnableOverride");
            }
            if ((flavor & 2) == 2) {
                list.add("Restricted");
            } else {
                list.add("ToSubclass");
            }
            if ((flavor & 4) == 4) {
                list.add("Translatable");
            }
            for (int i = 0; i < list.size(); ++i) {
                buffer.append((String)list.get(i));
                if (i + 1 == list.size()) continue;
                buffer.append(", ");
            }
            buffer.append(')');
        }
        buffer.append(';');
        return buffer.toString();
    }

    protected String generateScopeMOF(int scope) {
        switch (scope) {
            case 1: {
                return "class";
            }
            case 2: {
                return "association";
            }
            case 4: {
                return "indication";
            }
            case 8: {
                return "property";
            }
            case 16: {
                return "reference";
            }
            case 32: {
                return "method";
            }
            case 64: {
                return "parameter";
            }
            case 127: {
                return "any";
            }
        }
        throw new IllegalArgumentException();
    }

    protected String generateQualifierMOF(CIMQualifier<?> cq) {
        StringBuilder buffer = new StringBuilder(cq.getName());
        Object value = cq.getValue();
        if (value != null) {
            if (cq.getDataType().isArray()) {
                Object[] valueArray = (Object[])value;
                buffer.append(" { ");
                for (int i = 0; i < valueArray.length; ++i) {
                    buffer.append('\"');
                    buffer.append(valueArray[i]);
                    buffer.append('\"');
                    if (i == valueArray.length - 1) continue;
                    buffer.append(", ");
                }
                buffer.append(" }");
            } else if (!(value instanceof Boolean)) {
                buffer.append(" ( ");
                if (value instanceof String) {
                    buffer.append('\"');
                    buffer.append(MOFStyleBase.escape(value.toString()));
                    buffer.append('\"');
                } else {
                    buffer.append(MOFStyleBase.escape(value.toString()));
                }
                buffer.append(" )");
            }
        }
        return buffer.toString();
    }

    private String generateValueMOF(Object pValue, CIMDataType pType) {
        StringBuilder buffer = new StringBuilder();
        if (pValue != null) {
            if (pType != null && pType.isArray()) {
                buffer.append(this.generateArrayMOFString((Object[])pValue, "", false, true, false));
            } else if (pValue instanceof String || pValue instanceof CIMObjectPath) {
                buffer.append('\"');
                buffer.append(MOFStyleBase.escape(pValue.toString()));
                buffer.append('\"');
            } else if (pValue instanceof Character) {
                buffer.append('\'');
                buffer.append(MOFStyleBase.escape(pValue.toString()));
                buffer.append('\'');
            } else {
                buffer.append(pValue);
            }
        } else {
            buffer.append("null");
        }
        return buffer.toString();
    }

    private String formatQualifiers(CIMQualifier<?>[] qualifierList, String indent, MOFComments comments) {
        CIMQualifier<?>[] qualifiers = MOFStyleQualifiers.sortQualifiers(qualifierList);
        return this.qualifiersToMOFString(qualifiers, indent, comments);
    }

    private String qualifiersToMOFString(CIMQualifier<?>[] objArray, String indent, MOFComments comments) {
        if (objArray == null || objArray.length < 1) {
            return "";
        }
        int iLineLength = 75 - indent.length();
        String secondIndent = "    ";
        StringBuilder returnString = new StringBuilder();
        StringBuilder currentLine = new StringBuilder();
        if (objArray.length > 0) {
            currentLine.append(indent);
            currentLine.append('[');
        }
        int ctr = 0;
        if (objArray != null) {
            for (CIMQualifier<?> cq : objArray) {
                ++ctr;
                if (null == cq) {
                    if (objArray.length != ctr) continue;
                    break;
                }
                String name = cq.getName();
                if (currentLine.length() + name.length() + 2 > iLineLength) {
                    String comment;
                    returnString.append(currentLine.toString());
                    returnString.append('\n');
                    currentLine = new StringBuilder();
                    if (null != comments && null != (comment = comments.getQualifierComment(name)) && !"".equals(comment)) {
                        currentLine.append(comment);
                    }
                    currentLine.append(indent);
                    currentLine.append(' ');
                } else if (null != comments && !"".equals(comments.getQualifierComment(name))) {
                    currentLine = new StringBuilder();
                    currentLine.append(comments.getQualifierComment(name));
                    currentLine.append(indent);
                    currentLine.append(' ');
                }
                currentLine.append(name);
                if (cq.getValue() == null) continue;
                if (cq.getValue() instanceof Object[]) {
                    Object[] valueArray = (Object[])cq.getValue();
                    currentLine.append(" { ");
                    for (int i = 0; i < valueArray.length; ++i) {
                        StringBuilder buffer = new StringBuilder();
                        buffer.append('\"');
                        if (valueArray[i] instanceof String) {
                            String v = (String)valueArray[i];
                            v = v.trim();
                            buffer.append(MOFStyleBase.escape(v));
                        } else {
                            buffer.append(valueArray[i]);
                        }
                        buffer.append('\"');
                        if (i != valueArray.length - 1) {
                            buffer.append(", ");
                        }
                        if (currentLine.length() + buffer.length() > iLineLength) {
                            returnString.append(currentLine.toString());
                            returnString.append('\n');
                            currentLine = new StringBuilder();
                            currentLine.append(indent);
                            currentLine.append(secondIndent);
                        }
                        currentLine.append((CharSequence)buffer);
                    }
                    currentLine.append(" }");
                    if (ctr >= objArray.length) continue;
                    currentLine.append(", ");
                    returnString.append(currentLine.toString());
                    returnString.append('\n');
                    currentLine = new StringBuilder();
                    currentLine.append(indent);
                    currentLine.append(' ');
                    continue;
                }
                Object value = cq.getValue();
                if (!(value instanceof Boolean)) {
                    currentLine.append(" ( ");
                    StringBuilder buffer = new StringBuilder();
                    if (value instanceof String) {
                        int iLength = ((String)(value = ((String)value).trim())).length();
                        if (iLength + currentLine.length() + 3 > iLineLength) {
                            returnString.append(currentLine.toString());
                            returnString.append('\n');
                            currentLine = new StringBuilder();
                            currentLine.append(indent);
                            currentLine.append(secondIndent);
                            if (iLength + 3 > iLineLength) {
                                String source = (String)value;
                                currentLine.append('\"');
                                StringTokenizer st = new StringTokenizer(source, " ");
                                while (st.hasMoreTokens()) {
                                    String next = st.nextToken();
                                    if (next.contains("\n")) {
                                        String[] a = next.split("\n");
                                        int iCtr = 0;
                                        for (String b : a) {
                                            currentLine.append(MOFStyleBase.escape(b));
                                            if (++iCtr != a.length) {
                                                currentLine.append("\\n");
                                                currentLine.append('\"');
                                                returnString.append((CharSequence)currentLine);
                                                returnString.append('\n');
                                                currentLine = new StringBuilder();
                                                currentLine.append(indent);
                                                currentLine.append(secondIndent);
                                                currentLine.append('\"');
                                                continue;
                                            }
                                            currentLine.append(' ');
                                        }
                                        continue;
                                    }
                                    if (currentLine.length() + next.length() + 2 > iLineLength) {
                                        currentLine.append('\"');
                                        returnString.append((CharSequence)currentLine);
                                        returnString.append('\n');
                                        currentLine = new StringBuilder();
                                        currentLine.append(indent);
                                        currentLine.append(secondIndent);
                                        currentLine.append('\"');
                                    }
                                    currentLine.append(MOFStyleBase.escape(next));
                                    if (!st.hasMoreTokens()) continue;
                                    currentLine.append(' ');
                                }
                                currentLine.append('\"');
                            } else {
                                currentLine.append('\"');
                                currentLine.append(MOFStyleBase.escape(value.toString()));
                                currentLine.append('\"');
                            }
                        } else {
                            currentLine.append('\"');
                            currentLine.append(MOFStyleBase.escape(value.toString()));
                            currentLine.append('\"');
                        }
                    } else if (value != null) {
                        buffer.append(value.toString());
                    } else {
                        buffer.append("null");
                    }
                    if (currentLine.length() + buffer.length() > iLineLength) {
                        returnString.append(currentLine.toString());
                        returnString.append('\n');
                        currentLine = new StringBuilder();
                        currentLine.append(indent);
                        currentLine.append(secondIndent);
                    }
                    currentLine.append((CharSequence)buffer);
                    currentLine.append(" )");
                    if (ctr >= objArray.length) continue;
                    currentLine.append(", ");
                    returnString.append(currentLine.toString());
                    returnString.append('\n');
                    currentLine = new StringBuilder();
                    currentLine.append(indent);
                    currentLine.append(' ');
                    continue;
                }
                Boolean v = (Boolean)value;
                if (v.equals(Boolean.FALSE)) {
                    currentLine.append(" ( false )");
                }
                if (ctr >= objArray.length) continue;
                currentLine.append(", ");
            }
        }
        currentLine.append("]");
        currentLine.append('\n');
        returnString.append((CharSequence)currentLine);
        return returnString.toString();
    }
}

