/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

import com.ws.cim.mof.MOFStyle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.cim.CIMClassProperty;
import javax.cim.CIMElement;
import javax.cim.CIMInstance;
import javax.cim.CIMMethod;
import javax.cim.CIMNamedElementInterface;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.CIMQualifiedElementInterface;
import javax.cim.CIMQualifier;
import javax.cim.CIMTypedElement;
import javax.cim.CIMValuedElement;
import javax.cim.SharedMethods;

public class CIMClass
extends CIMElement
implements CIMQualifiedElementInterface,
CIMNamedElementInterface,
Comparable<CIMElement>,
Serializable {
    private static final String ASSOCIATION = "Association";
    private static final String KEY = "Key";
    private static final long serialVersionUID = -5634561913210025100L;
    private final boolean mIsAssociation;
    private final boolean mIsKeyed;
    private final CIMMethod<?>[] mMethods;
    private final CIMObjectPath mObjectPath;
    private final CIMClassProperty<?>[] mProperties;
    private final CIMQualifier<?>[] mQualifiers;
    private final String mSuperClass;

    private static String getPath(CIMObjectPath path) {
        if (null != path) {
            return path.getObjectName();
        }
        throw new IllegalArgumentException("path shall not be null.");
    }

    public CIMClass(CIMObjectPath path, String superclass, CIMQualifier<?>[] qualifiers, CIMClassProperty<?>[] properties, CIMMethod<?>[] methods, boolean isAssociation, boolean isKeyed) {
        super(CIMClass.getPath(path));
        this.mObjectPath = path;
        this.mSuperClass = superclass;
        this.mMethods = methods != null ? methods : new CIMMethod[]{};
        this.mQualifiers = qualifiers != null ? qualifiers : new CIMQualifier[]{};
        this.mProperties = properties != null ? properties : new CIMClassProperty[]{};
        this.mIsKeyed = isKeyed;
        this.mIsAssociation = isAssociation;
    }

    public CIMClass(String name, String superclass, CIMQualifier<?>[] qualifiers, CIMClassProperty<?>[] properties, CIMMethod<?>[] methods) {
        super(name);
        this.mObjectPath = new CIMObjectPath(name);
        this.mSuperClass = superclass;
        this.mMethods = methods != null ? methods : new CIMMethod[]{};
        this.mQualifiers = qualifiers != null ? qualifiers : new CIMQualifier[]{};
        this.mProperties = properties != null ? properties : new CIMClassProperty[]{};
        boolean b = false;
        if (null != qualifiers) {
            for (CIMValuedElement cIMValuedElement : qualifiers) {
                if (!ASSOCIATION.equalsIgnoreCase(cIMValuedElement.getName())) continue;
                b = true;
            }
        }
        this.mIsAssociation = b;
        b = false;
        if (null != properties) {
            for (CIMValuedElement cIMValuedElement : properties) {
                try {
                    Object val = ((CIMClassProperty)cIMValuedElement).getQualifierValue(KEY);
                    if (null == val || !val.equals(Boolean.TRUE)) continue;
                    b = true;
                    break;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        this.mIsKeyed = b;
    }

    @Override
    public int compareTo(CIMElement o) {
        CIMClass c = (CIMClass)o;
        return this.mObjectPath.compareTo(c.mObjectPath);
    }

    @Override
    public boolean equals(Object obj) {
        CIMClass clazz;
        if (obj instanceof CIMClass && super.equals(obj) && this.mObjectPath.equals((clazz = (CIMClass)obj).getObjectPath()) && (this.mSuperClass == null ? clazz.mSuperClass == null : this.mSuperClass.equalsIgnoreCase(clazz.mSuperClass)) && this.mIsAssociation == clazz.mIsAssociation) {
            Object[] methods = (CIMMethod[])this.mMethods.clone();
            Object[] clazzmethods = (CIMMethod[])clazz.mMethods.clone();
            Arrays.sort(methods);
            Arrays.sort(clazzmethods);
            if (Arrays.equals(methods, clazzmethods)) {
                Object[] props = (CIMProperty[])this.mProperties.clone();
                Object[] clazzprops = (CIMProperty[])clazz.mProperties.clone();
                Arrays.sort(props);
                Arrays.sort(clazzprops);
                if (Arrays.equals(props, clazzprops)) {
                    Object[] quals = (CIMQualifier[])this.mQualifiers.clone();
                    Object[] clazzquals = (CIMQualifier[])clazz.mQualifiers.clone();
                    Arrays.sort(quals);
                    Arrays.sort(clazzquals);
                    if (Arrays.equals(quals, clazzquals)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public CIMClass filterProperties(boolean localOnly, boolean includeQualifiers) {
        if (!localOnly && includeQualifiers) {
            return this;
        }
        CIMQualifier<?>[] qualList = includeQualifiers ? SharedMethods.getFilteredQualifiers(localOnly, this.mQualifiers) : null;
        CIMClassProperty<?>[] propList = this.getFilteredProperties(localOnly, includeQualifiers);
        CIMMethod<?>[] methodList = this.getFilteredMethods(localOnly, includeQualifiers);
        CIMClass cc = new CIMClass(this.getObjectPath(), this.mSuperClass, qualList, propList, methodList, this.mIsAssociation, this.mIsKeyed);
        return cc;
    }

    private CIMMethod<?>[] getFilteredMethods(boolean localOnly, boolean includeQualifier) {
        ArrayList methodList = new ArrayList();
        if (this.mMethods != null && this.mMethods.length > 0) {
            for (CIMMethod<?> m : this.mMethods) {
                if ((!localOnly || m.isPropagated()) && localOnly) continue;
                methodList.add(m.filter(includeQualifier));
            }
        }
        if (!methodList.isEmpty()) {
            return methodList.toArray(new CIMMethod[methodList.size()]);
        }
        return null;
    }

    private CIMClassProperty<?>[] getFilteredProperties(boolean localOnly, boolean includeQualifier) {
        ArrayList propList = new ArrayList();
        if (this.mProperties != null && this.mProperties.length > 0) {
            CIMClassProperty<?>[] arr$ = this.mProperties;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                CIMClassProperty<?> mPropertie;
                CIMClassProperty<?> cp = mPropertie = arr$[i$];
                if ((!localOnly || cp.isPropagated()) && localOnly) continue;
                propList.add(cp.filter(includeQualifier, localOnly));
            }
        }
        if (!propList.isEmpty()) {
            return propList.toArray(new CIMClassProperty[propList.size()]);
        }
        return null;
    }

    public CIMClassProperty<?>[] getKeys() {
        ArrayList l = new ArrayList();
        for (CIMClassProperty<?> mPropertie : this.mProperties) {
            if (!mPropertie.isKey()) continue;
            l.add(mPropertie);
        }
        return l.toArray(new CIMClassProperty[l.size()]);
    }

    public CIMMethod<?> getMethod(int index) throws ArrayIndexOutOfBoundsException {
        return this.mMethods[index];
    }

    public CIMMethod<?> getMethod(String name) {
        if (this.mMethods == null || name == null) {
            return null;
        }
        for (CIMMethod<?> mMethod : this.mMethods) {
            if (!mMethod.getName().equalsIgnoreCase(name)) continue;
            return mMethod;
        }
        return null;
    }

    public int getMethodCount() {
        return this.mMethods.length;
    }

    public CIMMethod<?>[] getMethods() {
        return this.mMethods;
    }

    @Override
    public CIMObjectPath getObjectPath() {
        return this.mObjectPath;
    }

    public CIMClassProperty<?>[] getProperties() {
        return this.mProperties;
    }

    public CIMClassProperty<?> getProperty(int index) throws ArrayIndexOutOfBoundsException {
        return this.mProperties[index];
    }

    public CIMClassProperty<?> getProperty(String name) {
        if (this.mProperties == null || name == null) {
            return null;
        }
        for (CIMClassProperty<?> mPropertie : this.mProperties) {
            if (!mPropertie.getName().equalsIgnoreCase(name)) continue;
            return mPropertie;
        }
        return null;
    }

    public int getPropertyCount() {
        return this.mProperties.length;
    }

    @Override
    public CIMQualifier<?> getQualifier(int index) throws ArrayIndexOutOfBoundsException {
        return this.mQualifiers[index];
    }

    @Override
    public CIMQualifier<?> getQualifier(String name) {
        if (name != null) {
            for (CIMQualifier<?> mQualifier : this.mQualifiers) {
                if (!mQualifier.getName().equalsIgnoreCase(name)) continue;
                return mQualifier;
            }
        }
        return null;
    }

    @Override
    public int getQualifierCount() {
        return this.mQualifiers.length;
    }

    @Override
    public CIMQualifier<?>[] getQualifiers() {
        return this.mQualifiers;
    }

    @Override
    public Object getQualifierValue(String name) {
        CIMQualifier<?> q = this.getQualifier(name);
        if (q != null) {
            return q.getValue();
        }
        return null;
    }

    public String getSuperClassName() {
        return this.mSuperClass;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        if (null != this.mSuperClass) {
            hash ^= this.mSuperClass.hashCode();
        }
        hash ^= this.mIsAssociation ? 0 : 1;
        hash ^= this.mIsKeyed ? 0 : 1;
        if (null != this.mObjectPath) {
            hash ^= this.mObjectPath.hashCode();
        }
        if (null != this.mMethods) {
            for (CIMTypedElement cIMTypedElement : this.mMethods) {
                hash ^= ((CIMMethod)cIMTypedElement).hashCode();
            }
        }
        if (null != this.mProperties) {
            for (CIMTypedElement cIMTypedElement : this.mProperties) {
                hash ^= ((CIMProperty)cIMTypedElement).hashCode();
            }
        }
        if (null != this.mQualifiers) {
            for (CIMTypedElement cIMTypedElement : this.mQualifiers) {
                hash ^= ((CIMQualifier)cIMTypedElement).hashCode();
            }
        }
        return hash;
    }

    @Override
    public boolean hasQualifier(String name) {
        return this.getQualifier(name) != null;
    }

    @Override
    public boolean hasQualifierValue(String name, Object value) {
        CIMQualifier<?> q = this.getQualifier(name);
        return q != null && q.getValue() != null && q.getValue().equals(value);
    }

    public boolean isAssociation() {
        return this.mIsAssociation;
    }

    public boolean isKeyed() {
        return this.mIsKeyed;
    }

    public CIMInstance newInstance() {
        CIMProperty[] cpArray = new CIMProperty[this.mProperties.length];
        for (int i = 0; i < this.mProperties.length; ++i) {
            CIMClassProperty<?> ccp = this.mProperties[i];
            cpArray[i] = new CIMProperty(ccp.getName(), ccp.getDataType(), ccp.getValue(), ccp.isKey());
        }
        return new CIMInstance(this.getObjectPath(), cpArray);
    }

    @Override
    public String toString() {
        MOFStyle mf = new MOFStyle();
        return mf.generateMOF(this);
    }
}

