/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

import java.io.Serializable;
import java.util.Arrays;
import javax.cim.CIMDataType;
import javax.cim.CIMProperty;
import javax.cim.CIMQualifiedElementInterface;
import javax.cim.CIMQualifier;
import javax.cim.SharedMethods;

public class CIMClassProperty<E>
extends CIMProperty<E>
implements CIMQualifiedElementInterface,
Serializable {
    static final long serialVersionUID = -1455588144409014311L;
    private final boolean mPropagated;
    private final CIMQualifier<?>[] mQualifiers;

    public CIMClassProperty(String name, CIMDataType type, E value, CIMQualifier<?>[] qualifiers, boolean key, boolean propagated) {
        super(name, type, value, key);
        this.mQualifiers = qualifiers != null ? qualifiers : new CIMQualifier[]{};
        this.mPropagated = propagated;
    }

    @Override
    public boolean equals(Object obj) {
        try {
            if (obj instanceof CIMClassProperty && super.equals(obj)) {
                CIMClassProperty p = (CIMClassProperty)obj;
                Object[] qual1 = (CIMQualifier[])this.mQualifiers.clone();
                Object[] qual2 = (CIMQualifier[])p.mQualifiers.clone();
                Arrays.sort(qual1);
                Arrays.sort(qual2);
                if (Arrays.equals(qual1, qual2)) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public CIMClassProperty<E> filter(boolean includeQualifiers) {
        return this.filter(includeQualifiers, false);
    }

    public CIMClassProperty<E> filter(boolean includeQualifiers, boolean localOnly) {
        return new CIMClassProperty(this.getName(), this.getDataType(), this.getValue(), includeQualifiers ? SharedMethods.getFilteredQualifiers(localOnly, this.mQualifiers) : null, this.isKey(), this.isPropagated());
    }

    @Override
    public CIMQualifier<?> getQualifier(int index) throws ArrayIndexOutOfBoundsException {
        return this.mQualifiers[index];
    }

    @Override
    public CIMQualifier<?> getQualifier(String name) {
        if (name != null) {
            for (CIMQualifier<?> mQualifier : this.mQualifiers) {
                if (!mQualifier.getName().equalsIgnoreCase(name)) continue;
                return mQualifier;
            }
        }
        return null;
    }

    @Override
    public int getQualifierCount() {
        return this.mQualifiers.length;
    }

    @Override
    public CIMQualifier<?>[] getQualifiers() {
        return this.mQualifiers;
    }

    @Override
    public Object getQualifierValue(String name) {
        CIMQualifier<?> q = this.getQualifier(name);
        if (q != null) {
            return q.getValue();
        }
        return null;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash ^= this.mPropagated ? 0 : 1;
        for (CIMQualifier<?> q : this.mQualifiers) {
            hash ^= q.hashCode();
        }
        return hash;
    }

    @Override
    public boolean hasQualifier(String name) {
        return this.getQualifier(name) != null;
    }

    @Override
    public boolean hasQualifierValue(String name, Object value) {
        CIMQualifier<?> q = this.getQualifier(name);
        return q != null && q.getValue() != null && q.getValue().equals(value);
    }

    public boolean isPropagated() {
        return this.mPropagated;
    }
}

