/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

import java.io.Serializable;
import javax.cim.UnsignedInteger;

public class UnsignedInteger32
extends UnsignedInteger
implements Serializable,
Comparable<UnsignedInteger32> {
    private static final long serialVersionUID = -8861436527534071393L;
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    public static final long MIN_VALUE = 0L;

    public UnsignedInteger32(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new NumberFormatException();
        }
        this.mValue = new Long(value);
    }

    public UnsignedInteger32(String value) throws NumberFormatException, IllegalArgumentException {
        if (null == value) {
            throw new IllegalArgumentException("value shall not be null");
        }
        Long temp = new Long(value);
        long longValue = temp;
        if (longValue < 0L || longValue > 0xFFFFFFFFL) {
            throw new NumberFormatException();
        }
        this.mValue = temp;
    }

    @Override
    public int compareTo(UnsignedInteger32 value) throws ClassCastException, IllegalArgumentException {
        if (null == value) {
            throw new IllegalArgumentException("value shall not be null");
        }
        return ((Long)this.mValue).compareTo((Long)value.mValue);
    }

    public boolean equals(Object o) {
        if (!(o instanceof UnsignedInteger32)) {
            return false;
        }
        return ((UnsignedInteger32)o).mValue.equals(this.mValue);
    }
}

