/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.wbem.WBEMException;
import javax.wbem.client.WBEMClient;

public class WBEMClientFactory {
    private static final String ERROR_PROTOCOL_CLASS_LOAD_FAILED = "protocol class could not be loaded.";
    private static final String ERROR_PROTOCOL_NOT_SUPPORTED = "invalid protocol name";
    private static final String ERROR_PROTOCOL_NAME_NULL = "Protocol name can not be null";
    private static final String FILE_NAME = "javax.wbem.client.WBEMClientFactory";
    private static final String NAME_KEY = "transport.protocol.name";
    private static final String PROP_TRANSPORT = "transport";
    private static final String PROP_CLASS = "client.class";

    public static WBEMClient getClient(String protocol) throws WBEMException {
        String propName;
        if (protocol == null || protocol.trim().length() == 0) {
            throw new IllegalArgumentException(ERROR_PROTOCOL_NAME_NULL);
        }
        Properties properties = WBEMClientFactory.loadProperties(FILE_NAME);
        String propValue = properties.getProperty(propName = "transport.protocol.name." + protocol.toLowerCase());
        if (propValue == null || !propValue.equalsIgnoreCase(protocol)) {
            throw new IllegalArgumentException(ERROR_PROTOCOL_NOT_SUPPORTED);
        }
        propName = "transport." + propValue + "." + PROP_CLASS;
        String classname = properties.getProperty(propName);
        Class<?> cl = null;
        try {
            cl = Class.forName(classname);
        }
        catch (Exception ex) {
            throw new WBEMException(1, ERROR_PROTOCOL_CLASS_LOAD_FAILED);
        }
        WBEMClient wc = null;
        try {
            Class[] paramTypes = new Class[]{};
            Object[] paramList = new Object[]{};
            Constructor<?> ctr = cl.getConstructor(paramTypes);
            wc = (WBEMClient)ctr.newInstance(paramList);
        }
        catch (InvocationTargetException ex) {
            Throwable ax = ex.getTargetException();
            if (ax instanceof WBEMException) {
                WBEMException cex = (WBEMException)ax;
                throw cex;
            }
            throw new WBEMException(1, ERROR_PROTOCOL_CLASS_LOAD_FAILED, null, ax);
        }
        catch (Exception ex) {
            throw new WBEMException(1, ERROR_PROTOCOL_CLASS_LOAD_FAILED, null, ex);
        }
        return wc;
    }

    public static String[] getSupportedProtocols() {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            Properties properties = WBEMClientFactory.loadProperties(FILE_NAME);
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                if (!k.startsWith(NAME_KEY)) continue;
                String value = properties.getProperty(k);
                ret.add(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret.toArray(new String[ret.size()]);
    }

    private static Properties loadProperties(String bundle) {
        Properties props = new Properties();
        PropertyResourceBundle prb = (PropertyResourceBundle)ResourceBundle.getBundle(bundle, new Locale("", ""));
        if (prb != null) {
            Enumeration<String> en = prb.getKeys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                if (key == null) continue;
                try {
                    String val = prb.getString(key);
                    props.setProperty(key, val);
                }
                catch (Exception ex) {}
            }
        }
        return props;
    }
}

