/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.EditableChartDataModel;
import com.klg.jclass.chart.HoleValueChartDataModel;
import com.klg.jclass.chart.LabelledChartDataModel;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class DataHandler {
    private ChartDataView view;

    public DataHandler(ChartDataView chartDataView) {
        this.view = chartDataView;
    }

    public void addSeries() {
        int n;
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null) {
            return;
        }
        int n2 = n = this.view.getNumSeries();
        double[] dArray = chartDataModel.getXSeries(n2);
        double[] dArray2 = chartDataModel.getYSeries(n2);
        boolean bl = this.view.isBatched();
        this.view.setBatched(true);
        ChartDataViewSeries chartDataViewSeries = new ChartDataViewSeries(dArray, dArray2, this.view);
        this.view.addSeries(chartDataViewSeries);
        this.reloadSeriesLabel(n2);
        this.view.setChanged(true);
        this.view.setBatched(bl);
    }

    public void appendData() {
        this.refreshData(this.view.getDataSource());
    }

    public void changeChartType(int n) {
        this.view.setChartType(n);
    }

    public boolean editPoint(int n, int n2, double d) {
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof EditableChartDataModel)) {
            return false;
        }
        EditableChartDataModel editableChartDataModel = (EditableChartDataModel)chartDataModel;
        return editableChartDataModel.setDataItem(n, n2, d);
    }

    public void insertSeries(int n) {
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null) {
            return;
        }
        int n2 = this.view.getNumSeries();
        if (n >= n2) {
            return;
        }
        double[] dArray = chartDataModel.getXSeries(n);
        double[] dArray2 = chartDataModel.getYSeries(n);
        boolean bl = this.view.isBatched();
        this.view.setBatched(true);
        ChartDataViewSeries chartDataViewSeries = this.view.addSeries(n);
        chartDataViewSeries.setX(dArray);
        chartDataViewSeries.setY(dArray2);
        this.reloadSeriesLabel(n);
        this.view.setChanged(true);
        this.view.setBatched(bl);
    }

    public void loadData(ChartDataModel chartDataModel) {
        int n = chartDataModel == null ? 0 : chartDataModel.getNumSeries();
        Vector<ChartDataViewSeries> vector = chartDataModel != null ? new Vector<ChartDataViewSeries>(n) : null;
        List list = this.view.getSeries();
        boolean bl = this.view.isBatched();
        this.view.setBatched(true);
        if (chartDataModel != null && n != 0) {
            int n2 = 0;
            this.view.setX(chartDataModel.getXSeries(0));
            int n3 = 0;
            while (n3 < n) {
                ChartDataViewSeries chartDataViewSeries;
                double[] dArray = chartDataModel.getXSeries(n3);
                double[] dArray2 = chartDataModel.getYSeries(n3);
                if (dArray2 != null && n2 < dArray2.length) {
                    n2 = dArray2.length;
                }
                if (dArray != this.view.getX()) {
                    this.view.setX(null);
                }
                if (n3 < list.size()) {
                    chartDataViewSeries = (ChartDataViewSeries)list.get(n3);
                    chartDataViewSeries.setX(dArray);
                    chartDataViewSeries.setY(dArray2);
                } else {
                    chartDataViewSeries = new ChartDataViewSeries(dArray, dArray2, this.view);
                    chartDataViewSeries.setDrawingOrder(n3);
                }
                vector.add(chartDataViewSeries);
                ++n3;
            }
        } else {
            this.view.setX(null);
        }
        this.view.setSeries(vector);
        this.view.setChanged(true);
        this.view.setBatched(bl);
    }

    public void refreshData(ChartDataModel chartDataModel) {
        int n;
        int n2 = n = this.view == null ? 0 : this.view.getNumSeries();
        if (chartDataModel != null && n != 0) {
            this.view.setX(chartDataModel.getXSeries(0));
            int n3 = 0;
            while (n3 < n) {
                double[] dArray = chartDataModel.getXSeries(n3);
                double[] dArray2 = chartDataModel.getYSeries(n3);
                if (dArray != this.view.getX()) {
                    this.view.setX(null);
                }
                ChartDataViewSeries chartDataViewSeries = this.view.getSeries(n3);
                chartDataViewSeries.setX(dArray);
                chartDataViewSeries.setY(dArray2);
                ++n3;
            }
        } else {
            this.view.setX(null);
        }
    }

    public void reload() {
        this.refreshData(this.view.getDataSource());
        this.reloadHoleValue();
        this.reloadAllSeriesLabels();
    }

    public void reloadAllPointLabels() {
        if (this.view == null) {
            return;
        }
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof LabelledChartDataModel)) {
            this.view.setPointLabels(new Vector());
            return;
        }
        LabelledChartDataModel labelledChartDataModel = (LabelledChartDataModel)((Object)chartDataModel);
        String[] stringArray = labelledChartDataModel.getPointLabels();
        Vector<Object> vector = stringArray == null ? new Vector() : new Vector<String>(Arrays.asList(stringArray));
        this.view.setPointLabels(vector);
    }

    public void reloadAllSeriesLabels() {
        if (this.view == null) {
            return;
        }
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof LabelledChartDataModel)) {
            return;
        }
        LabelledChartDataModel labelledChartDataModel = (LabelledChartDataModel)((Object)chartDataModel);
        String[] stringArray = labelledChartDataModel.getSeriesLabels();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < this.view.getNumSeries() && n < stringArray.length) {
            ChartDataViewSeries chartDataViewSeries = this.view.getSeries(n);
            chartDataViewSeries.setLabel(stringArray[n]);
            ++n;
        }
    }

    public void reloadDataSourceName() {
        if (this.view == null) {
            return;
        }
        if (this.view.getDataSource() instanceof LabelledChartDataModel) {
            LabelledChartDataModel labelledChartDataModel = (LabelledChartDataModel)((Object)this.view.getDataSource());
            this.view.setName(labelledChartDataModel.getDataSourceName());
        }
    }

    public void reloadHoleValue() {
        if (this.view == null) {
            return;
        }
        if (this.view.getDataSource() instanceof HoleValueChartDataModel) {
            HoleValueChartDataModel holeValueChartDataModel = (HoleValueChartDataModel)((Object)this.view.getDataSource());
            this.view.setHoleValue(holeValueChartDataModel.getHoleValue());
        }
    }

    public void reloadPoint(int n, int n2) {
        int n3;
        ChartDataModel chartDataModel = this.view.getDataSource();
        int n4 = n3 = chartDataModel == null ? 0 : chartDataModel.getNumSeries();
        if (chartDataModel != null && n >= 0 && n < n3) {
            this.view.setChanged(true);
        }
    }

    public void reloadPointLabel(int n) {
        if (this.view == null) {
            return;
        }
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof LabelledChartDataModel)) {
            return;
        }
        LabelledChartDataModel labelledChartDataModel = (LabelledChartDataModel)((Object)chartDataModel);
        String[] stringArray = labelledChartDataModel.getPointLabels();
        if (stringArray != null && n < stringArray.length) {
            this.view.setPointLabel(n, stringArray[n]);
        }
    }

    public void reloadSeries(int n) {
        int n2;
        ChartDataModel chartDataModel = this.view.getDataSource();
        int n3 = n2 = chartDataModel == null ? 0 : chartDataModel.getNumSeries();
        if (chartDataModel != null && n >= 0 && n < n2) {
            ChartDataViewSeries chartDataViewSeries = this.view.getSeries(n);
            double[] dArray = chartDataModel.getYSeries(n);
            chartDataViewSeries.setY(dArray);
            if (this.view.getX() == null) {
                double[] dArray2 = chartDataModel.getXSeries(n);
                chartDataViewSeries.setX(dArray2);
            }
            this.view.setChanged(true);
        }
    }

    public void reloadSeriesLabel(int n) {
        if (this.view == null) {
            return;
        }
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof LabelledChartDataModel)) {
            return;
        }
        LabelledChartDataModel labelledChartDataModel = (LabelledChartDataModel)((Object)chartDataModel);
        String[] stringArray = labelledChartDataModel.getSeriesLabels();
        if (stringArray != null && n < stringArray.length && n < this.view.getNumSeries()) {
            this.view.getSeries(n).setLabel(stringArray[n]);
        }
    }

    public void removeSeries(int n) {
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null) {
            return;
        }
        int n2 = this.view.getNumSeries();
        if (n >= n2) {
            return;
        }
        this.view.removeSeries(n);
    }

    public void reset() {
        this.loadData(this.view.getDataSource());
        this.reloadHoleValue();
        this.reloadAllPointLabels();
        this.reloadAllSeriesLabels();
        this.reloadDataSourceName();
    }
}

