/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.data;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import sanproject.serverux.data.GetRmiException;
import sanproject.serverux.data.RmiConObjErr;

public class RmiConObjInFile {
    private BufferedReader in;
    private String fileName;
    private boolean errLogFlag = true;

    private void init() throws GetRmiException {
        try {
            this.in = new BufferedReader(new FileReader(this.fileName));
        }
        catch (FileNotFoundException fileNotFoundException) {
            RmiConObjErr.putFileErrLog(4000, "RmiConObjInFile: Could not open " + this.fileName, this.errLogFlag);
            throw RmiConObjErr.makeException(this.fileName, 4000);
        }
    }

    public RmiConObjInFile(BufferedReader bufferedReader) {
        this.in = bufferedReader;
    }

    public RmiConObjInFile(String string) throws GetRmiException {
        this.fileName = string;
        this.init();
    }

    public RmiConObjInFile(String string, boolean bl) throws GetRmiException {
        this.fileName = string;
        this.errLogFlag = bl;
        this.init();
    }

    public ArrayList getArrayList() throws GetRmiException {
        String string = null;
        boolean bl = false;
        try {
            string = this.in.readLine();
            bl = true;
        }
        catch (IOException iOException) {
            RmiConObjErr.putFileErrLog(4001, "RmiConObjInFile: File Access Failed : " + this.fileName, this.errLogFlag);
            throw RmiConObjErr.makeException(4001);
        }
        finally {
            if (!bl) {
                this.clearAfterErr();
            }
        }
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
        LinkedList<String> linkedList = new LinkedList<String>();
        String string2 = new String("");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string2.equals(",") && string3.equals(",")) {
                linkedList.add(new String(""));
            } else if (!string3.equals(",")) {
                linkedList.add(string3);
            }
            string2 = string3;
        }
        if (string2.equals(",")) {
            linkedList.add(new String(""));
        }
        return new ArrayList(linkedList);
    }

    public String getLine() throws GetRmiException {
        String string = null;
        boolean bl = false;
        try {
            string = this.in.readLine();
            bl = true;
        }
        catch (IOException iOException) {
            RmiConObjErr.putFileErrLog(4001, "RmiConObjInFile: File Access Failed : " + this.fileName, this.errLogFlag);
            throw RmiConObjErr.makeException(4001);
        }
        finally {
            if (!bl) {
                this.clearAfterErr();
            }
        }
        return string;
    }

    public void clearAfterErr() {
        try {
            this.clear();
        }
        catch (Exception exception) {
            RmiConObjErr.putErrLog("-", "RmiConObjInFile: " + exception.getMessage());
        }
    }

    public void clear() throws GetRmiException {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            RmiConObjErr.putFileErrLog(4001, "RmiConObjInFile: close unsuccessuful: " + this.fileName, this.errLogFlag);
            throw RmiConObjErr.makeException(4001);
        }
    }

    private static final int readConfigFile() throws GetRmiException {
        int n = 0;
        try {
            String string = "";
            String string2 = "";
            String string3 = "";
            RmiConObjInFile rmiConObjInFile = new RmiConObjInFile("..\\..\\san\\htdocs\\san\\datachgtbl\\pcmtype.csv");
            ArrayList arrayList = rmiConObjInFile.getArrayList();
            string2 = (String)arrayList.get(0);
            string = (String)arrayList.get(2);
            string3 = arrayList.size() >= 4 ? RmiConObjInFile.paddingZero(Integer.parseInt((String)arrayList.get(3)), 2) : "03";
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2);
            stringBuffer.append(string);
            stringBuffer.append(string3);
            System.out.println("OEM Type       : " + stringBuffer.toString());
            n = Integer.parseInt(stringBuffer.toString(), 16);
        }
        catch (Exception exception) {
            RmiConObjErr.putFileErrLog(4001, "RmiConObjInFile: File Access Failed ", true);
            System.out.println("Error   : " + exception.getMessage());
            exception.printStackTrace();
            throw RmiConObjErr.makeException(4013);
        }
        return n;
    }

    static int getOEMType() throws GetRmiException {
        int n = RmiConObjInFile.readConfigFile();
        return n;
    }

    static String paddingZero(int n, int n2) {
        String string = "" + n;
        int n3 = n2 - string.length();
        if (n3 <= 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n3).append('0');
        for (int i = 1; i < n3; ++i) {
            stringBuffer.append('0');
        }
        return stringBuffer + string;
    }
}

