/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import sanproject.serverux.data.RmiErrorChange;

public class RmiException
extends Exception {
    public static final String OBJECT_FILE_PATH = "..\\..\\san\\htdocs\\san\\datachgtbl\\objECC.obj";
    public int nErrCode = 0;
    public int nErrData = 0;
    public String occuredTime = null;
    public Date occuredTimeDate = null;
    public RmiErrorChange errorChange = null;

    public RmiException() {
        this.init();
    }

    public RmiException(Throwable throwable) {
        super(throwable);
    }

    public RmiException(int n, int n2) {
        this.init();
        this.setErr(n, n2);
    }

    public RmiException(String string, int n, int n2) {
        super(string);
        this.init();
        this.setErr(n, n2);
    }

    public RmiException(String string, int n, int n2, String string2) {
        super(string);
        this.init();
        this.setErr(n, n2);
        this.setOccuredTime(string2);
    }

    public RmiException(String string, int n, int n2, String string2, Date date) {
        super(string);
        this.init();
        this.setErr(n, n2);
        this.setOccuredTime(string2, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.nErrCode = 0;
        this.nErrData = 0;
        this.occuredTime = new String("");
        this.occuredTimeDate = null;
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            File file = new File(OBJECT_FILE_PATH);
            if (file.exists()) {
                fileInputStream = new FileInputStream(OBJECT_FILE_PATH);
                objectInputStream = new ObjectInputStream(fileInputStream);
                this.errorChange = (RmiErrorChange)objectInputStream.readObject();
            } else {
                this.errorChange = new RmiErrorChange();
                fileOutputStream = new FileOutputStream(OBJECT_FILE_PATH);
                objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this.errorChange);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.nErrCode = 10;
            this.nErrData = 6027;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.nErrCode = 10;
            this.nErrData = 6027;
        }
        catch (IOException iOException) {
            this.nErrCode = 10;
            this.nErrData = 6027;
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                this.nErrCode = 10;
                this.nErrData = 6027;
            }
        }
    }

    public void setErr(int n, int n2) {
        this.nErrCode = n;
        this.nErrData = n2;
    }

    public void setOccuredTime(String string) {
        this.occuredTime = string;
        this.occuredTimeDate = new Date();
    }

    public void setOccuredTime(String string, Date date) {
        this.occuredTime = string;
        this.occuredTimeDate = date;
    }

    public int getErrCode() {
        return this.nErrCode;
    }

    public int getErrData() {
        return this.nErrData;
    }

    public String getOccuredTime() {
        return this.occuredTime;
    }

    public Date getOccuredTimeDate() {
        return this.occuredTimeDate;
    }

    public String getErrMsgEn() {
        String string = this.errorChange.getErrorMsgEn(this.nErrCode, this.nErrData);
        return string;
    }

    public String getErrMsgJa() {
        String string = this.errorChange.getErrorMsgJa(this.nErrCode, this.nErrData);
        return string;
    }

    public String toString() {
        String string = super.toString();
        return string + " , " + this.nErrCode + " - " + this.nErrData + " , " + this.getMessage();
    }

    public String getMessage() {
        return super.getMessage() == null ? this.nErrCode + " - " + this.nErrData : super.getMessage();
    }
}

