/*
 * Decompiled with CFR 0.152.
 */
import sanproject.server.data.DGDgetVtocArea;
import sanproject.server.data.DGDsetVtocArea;

public class RJDGDVtocArea
implements Comparable {
    private RJDGDGuardPatternCom _owner;
    private boolean _modify = false;
    private int _cu;
    private int _ldev;
    private int _start;
    private int _end;
    private static int _MASK_CYL = -256;
    private static int _MASK_HEAD = 255;
    private static int _TPC = 15;

    private RJDGDVtocArea() {
        this._owner = null;
        this._cu = -1;
        this._ldev = -1;
        this._start = -1;
        this._end = -1;
    }

    public RJDGDVtocArea(RJDGDGuardPatternCom rJDGDGuardPatternCom, DGDgetVtocArea dGDgetVtocArea) {
        this._owner = rJDGDGuardPatternCom;
        this._cu = dGDgetVtocArea.cu;
        this._ldev = dGDgetVtocArea.ldev;
        this._start = dGDgetVtocArea.start;
        this._end = dGDgetVtocArea.end;
    }

    public boolean isModify() {
        return this._modify;
    }

    public int size() {
        return RJDGDVtocArea.toTrack(this._end) - RJDGDVtocArea.toTrack(this._start) + 1;
    }

    public int getStartCC() {
        return RJDGDVtocArea.cyl(this._start);
    }

    public int getStartHH() {
        return RJDGDVtocArea.head(this._start);
    }

    public int getEndCC() {
        return RJDGDVtocArea.cyl(this._end);
    }

    public int getEndHH() {
        return RJDGDVtocArea.head(this._end);
    }

    public String getStart() {
        return RJDGDVtocArea.toString(this._start);
    }

    public String getEnd() {
        return RJDGDVtocArea.toString(this._end);
    }

    public String toString() {
        return this.getStart() + " - " + this.getEnd() + " (" + this.size() + "Trk)";
    }

    public void setStart(int n, int n2) {
        int n3;
        if (this._owner != null && this._modify | this._start != (n3 = RJDGDVtocArea.toPosition(n, n2))) {
            this._start = n3;
            this._modify = true;
            this._owner.setVtocArea(this);
        }
    }

    public void setEnd(int n, int n2) {
        int n3;
        if (this._owner != null && this._modify | this._end != (n3 = RJDGDVtocArea.toPosition(n, n2))) {
            this._end = n3;
            this._modify = true;
            this._owner.setVtocArea(this);
        }
    }

    public DGDsetVtocArea getDGDsetVtocArea() {
        DGDsetVtocArea dGDsetVtocArea = new DGDsetVtocArea();
        dGDsetVtocArea.cu = this._cu;
        dGDsetVtocArea.ldev = this._ldev;
        dGDsetVtocArea.start = this._start;
        dGDsetVtocArea.end = this._end;
        dGDsetVtocArea.error = -1;
        return dGDsetVtocArea;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof RJDGDVtocArea) {
            bl = this.compareTo(object) == 0;
        }
        return bl;
    }

    public int compareTo(Object object) throws ClassCastException {
        RJDGDVtocArea rJDGDVtocArea = (RJDGDVtocArea)object;
        int n = -1;
        if (this._cu > rJDGDVtocArea._cu) {
            n = 1;
        } else if (this._cu == rJDGDVtocArea._cu) {
            if (this._ldev > rJDGDVtocArea._ldev) {
                n = 1;
            } else if (this._ldev == rJDGDVtocArea._ldev) {
                n = 0;
            }
        }
        return n;
    }

    private static int toPosition(int n, int n2) {
        return n << 8 | n2 % _TPC;
    }

    private static int cyl(int n) {
        return (n & _MASK_CYL) >> 8;
    }

    private static int head(int n) {
        return n & _MASK_HEAD;
    }

    private static int toTrack(int n) {
        return RJDGDVtocArea.cyl(n) * _TPC + RJDGDVtocArea.head(n);
    }

    private static String toString(int n) {
        return Integer.toString(RJDGDVtocArea.cyl(n)) + ":" + Integer.toString(RJDGDVtocArea.head(n));
    }

    public static RJDGDVtocArea newNull() {
        return NullVtocArea.getInstance();
    }

    private static class NullVtocArea
    extends RJDGDVtocArea {
        private static NullVtocArea singleton = new NullVtocArea();
        private static String NO_DATA = RJDGDGuidanceManager.getString("STRING_DAT_NODATA");

        private static NullVtocArea getInstance() {
            return singleton;
        }

        private NullVtocArea() {
        }

        public int size() {
            return -1;
        }

        public String toString() {
            return NO_DATA;
        }

        private String toString(int n) {
            return NO_DATA;
        }

        public void setStart(int n, int n2) {
        }

        public void setEnd(int n, int n2) {
        }
    }
}

