/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.provider.jobservice;

import com.ws.wbem.IndicationManager;
import com.ws.wbem.IndicationType;
import com.ws.wbem.provider.jobservice.JobImplementation;
import com.ws.wbem.provider.jobservice.JobServiceIndicationFilters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import javax.cim.CIMInstance;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;

public class JobService {
    private static IndicationManager mIndicationManager = null;
    private static final String CPN_INSTANCEID = "InstanceID";
    public static Hashtable<String, Hashtable<String, CIMInstance>> mJobInstances = new Hashtable();
    private static Hashtable<String, ArrayList<JobImplementation>> mJobCollection = new Hashtable();

    protected static synchronized void activateFilter(ProviderHandle pHandle, CIMInstance instFilter, CIMInstance instSubscription) throws WBEMException {
        if (null == mIndicationManager) {
            mIndicationManager = new IndicationManager(pHandle, "CIM_ConcreteJob");
            mIndicationManager.registerSupportedFilterQueries(JobServiceIndicationFilters.SUPPORTED_INDICATIONS);
        }
        mIndicationManager.activateFilter(instFilter, instSubscription);
    }

    protected static synchronized void authorizeFilter(ProviderHandle pHandle, CIMInstance instFilter) throws WBEMException {
        if (null == mIndicationManager) {
            mIndicationManager = new IndicationManager(pHandle, "CIM_ConcreteJob");
            mIndicationManager.registerSupportedFilterQueries(JobServiceIndicationFilters.SUPPORTED_INDICATIONS);
        }
        mIndicationManager.authorizeFilter(instFilter);
    }

    protected static synchronized void deActivateFilter(ProviderHandle pHandle, CIMInstance instFilter, CIMInstance instSubscription) throws WBEMException {
        if (null == mIndicationManager) {
            mIndicationManager = new IndicationManager(pHandle, "CIM_ConcreteJob");
            mIndicationManager.registerSupportedFilterQueries(JobServiceIndicationFilters.SUPPORTED_INDICATIONS);
        }
        mIndicationManager.deactivateFilter(instFilter, instSubscription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ArrayList<JobImplementation> getRegisteredImplementations(String className) {
        ArrayList<JobImplementation> temp;
        Hashtable<String, ArrayList<JobImplementation>> hashtable = mJobCollection;
        synchronized (hashtable) {
            temp = mJobCollection.get(className.toLowerCase());
            temp = new ArrayList<JobImplementation>(null != temp ? temp : Collections.emptyList());
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeJob(CIMInstance instConcreteJob) throws WBEMException {
        if (null != instConcreteJob) {
            Hashtable<String, Hashtable<String, CIMInstance>> hashtable = mJobInstances;
            synchronized (hashtable) {
                Hashtable<String, CIMInstance> classInstTable = mJobInstances.get(instConcreteJob.getClassName().toLowerCase());
                if (null == classInstTable) {
                    throw new WBEMException(1, "Cannot mark the specified ConcreteJob as completed because it doesn't exists");
                }
                String instID = (String)instConcreteJob.getPropertyValue(CPN_INSTANCEID);
                if (null == instID) {
                    throw new WBEMException(4, "The ConcreteJob instance doesn't have a valid InstanceID property value: " + instConcreteJob);
                }
                CIMInstance instPrevJob = classInstTable.get(instID);
                if (null == instPrevJob) {
                    throw new WBEMException(1, "Cannot mark the specified ConcreteJob as completed because it doesn't exists");
                }
                classInstTable.remove(instID);
                if (classInstTable.isEmpty()) {
                    mJobInstances.remove(instConcreteJob.getClassName().toLowerCase());
                }
                if (null != mIndicationManager) {
                    mIndicationManager.deliverInstanceIndication(IndicationType.InstanceDeletion, instPrevJob, null);
                }
            }
        } else {
            throw new WBEMException(4, "Cannot complete a null ConcreteJob!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJob(CIMInstance instConcreteJob) throws WBEMException {
        if (null != instConcreteJob) {
            Hashtable<String, Hashtable<String, CIMInstance>> hashtable = mJobInstances;
            synchronized (hashtable) {
                String instID;
                Hashtable<String, Object> classInstTable = mJobInstances.get(instConcreteJob.getClassName().toLowerCase());
                if (null == classInstTable) {
                    classInstTable = new Hashtable();
                }
                if (null == (instID = (String)instConcreteJob.getPropertyValue(CPN_INSTANCEID))) {
                    throw new WBEMException(4, "The ConcreteJob instance doesn't have a valid InstanceID property value: " + instConcreteJob);
                }
                CIMInstance instOldJob = (CIMInstance)classInstTable.get(instID);
                if (null != instOldJob) {
                    throw new WBEMException(4, "Trying to create a ConcreteJob with an instanceID of \"" + instID + "\" but a ConcreteJob with that InstanceID " + "already exists");
                }
                classInstTable.put(instID, instConcreteJob);
                mJobInstances.put(instConcreteJob.getClassName().toLowerCase(), classInstTable);
            }
            if (null != mIndicationManager) {
                mIndicationManager.deliverInstanceIndication(IndicationType.InstanceCreation, instConcreteJob, null);
            }
        } else {
            throw new WBEMException(4, "Cannot create a null ConcreteJob!");
        }
    }

    public void registerImplementation(String ccnConcreteJob, String ccnMethodResult, JobImplementation impl) {
        if (null == ccnConcreteJob || null == impl.getOwningJobElementClassName()) {
            throw new IllegalArgumentException("The ConcreteJob and OwningJobElement class names are required");
        }
        this.registerImplForClass(ccnConcreteJob, impl);
        this.registerImplForClass(impl.getOwningJobElementClassName(), impl);
        String[] clzName = impl.getAffectedJobElementClassName();
        if (null != clzName) {
            for (String name : clzName) {
                this.registerImplForClass(name, impl);
            }
        }
        if (null != impl.getAssociatedJobMethodResultClassName()) {
            this.registerImplForClass(impl.getAssociatedJobMethodResultClassName(), impl);
        }
        if (null != ccnMethodResult) {
            this.registerImplForClass(ccnMethodResult, impl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerImplForClass(String className, JobImplementation impl) {
        if (null != className) {
            Hashtable<String, ArrayList<JobImplementation>> hashtable = mJobCollection;
            synchronized (hashtable) {
                className = className.toLowerCase();
                ArrayList<JobImplementation> impls = mJobCollection.get(className);
                if (null != impls) {
                    impls.add(impl);
                } else {
                    impls = new ArrayList();
                    impls.add(impl);
                }
                mJobCollection.put(className, impls);
            }
        }
    }

    public void unregisterImplementation(String ccnConcreteJob, String ccnMethodResult, JobImplementation impl) {
        this.unregisterImplForClass(ccnConcreteJob, impl);
        this.unregisterImplForClass(impl.getOwningJobElementClassName(), impl);
        String[] clzName = impl.getAffectedJobElementClassName();
        if (null != clzName) {
            for (String name : clzName) {
                this.unregisterImplForClass(name, impl);
            }
        }
        this.unregisterImplForClass(impl.getAssociatedJobMethodResultClassName(), impl);
        this.unregisterImplForClass(ccnMethodResult, impl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterImplForClass(String className, JobImplementation impl) {
        if (null != className) {
            Hashtable<String, ArrayList<JobImplementation>> hashtable = mJobCollection;
            synchronized (hashtable) {
                className = className.toLowerCase();
                ArrayList<JobImplementation> impls = mJobCollection.get(className);
                if (null != impls) {
                    Iterator<JobImplementation> implsIter = impls.iterator();
                    while (implsIter.hasNext()) {
                        JobImplementation tmpImpl = implsIter.next();
                        if (!impl.equals(tmpImpl)) continue;
                        implsIter.remove();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJob(CIMInstance instConcreteJob) throws WBEMException {
        if (null != instConcreteJob) {
            Hashtable<String, Hashtable<String, CIMInstance>> hashtable = mJobInstances;
            synchronized (hashtable) {
                Hashtable<String, CIMInstance> classInstTable = mJobInstances.get(instConcreteJob.getClassName().toLowerCase());
                if (null == classInstTable) {
                    throw new WBEMException(1, "Cannot update the specified ConcreteJob because it doesn't exists");
                }
                String instID = (String)instConcreteJob.getPropertyValue(CPN_INSTANCEID);
                if (null == instID) {
                    throw new WBEMException(4, "The ConcreteJob instance doesn't have a valid InstanceID property value: " + instConcreteJob);
                }
                CIMInstance instPrevJob = classInstTable.get(instID);
                if (null == instPrevJob) {
                    throw new WBEMException(1, "Cannot update the specified ConcreteJob because it doesn't exists");
                }
                classInstTable.put(instID, instConcreteJob);
                if (null != mIndicationManager) {
                    mIndicationManager.deliverInstanceIndication(IndicationType.InstanceModification, instConcreteJob, instPrevJob);
                }
            }
        } else {
            throw new WBEMException(4, "Cannot update a null ConcreteJob!");
        }
    }
}

