/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.xmlcim;

import com.ws.cim.xmlcim.CIMXMLElementsWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.cim.CIMClass;
import javax.cim.CIMElement;
import javax.cim.CIMInstance;
import javax.cim.CIMQualifierType;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class CIMXMLWriter {
    private static final String CIM_VERSION = "2.7";
    private static final String DTD_VERSION = "2.4";
    private boolean record = false;
    private String mOutdir = ".";
    private boolean individual = true;
    private boolean mLocalOnly = false;
    private final XMLOutputFactory mFactory = XMLOutputFactory.newInstance();
    private XMLStreamWriter mIndexStream;
    private XMLStreamWriter mAllStream;

    public CIMXMLWriter() {
    }

    public CIMXMLWriter(String outdir) {
        this();
        if (outdir != null) {
            this.mOutdir = outdir;
        }
    }

    public void setLocalOnly(boolean localOnly) {
        this.mLocalOnly = localOnly;
    }

    public void recordAll(boolean individualFiles) throws IOException, XMLStreamException {
        this.record = true;
        this.individual = individualFiles;
        this.initializeIndexFile();
        this.initializeAllFile();
    }

    public void recordAll() throws IOException, XMLStreamException {
        this.recordAll(true);
    }

    public void closeAll() throws IOException, XMLStreamException {
        this.closeIndexFile();
        this.closeAllFile();
    }

    private void initializeIndexFile() throws IOException, XMLStreamException {
        File dir = new File(this.mOutdir);
        if (!(dir.exists() && dir.isDirectory() || dir.mkdir())) {
            throw new IOException("could not create directory: " + this.mOutdir);
        }
        String fileName = this.mOutdir + File.separator + "class_index.xml";
        File xmlFile = new File(fileName);
        if (xmlFile.exists()) {
            xmlFile.delete();
        }
        this.mIndexStream = this.mFactory.createXMLStreamWriter(new FileWriter(fileName));
        this.mIndexStream.writeStartDocument();
        this.mIndexStream.writeStartElement("CLASSES");
    }

    private void initializeAllFile() throws IOException, XMLStreamException {
        String fileName = this.mOutdir + File.separator + "all_classes.xml";
        File bigxmlFile = new File(fileName);
        if (bigxmlFile.exists()) {
            bigxmlFile.delete();
        }
        this.mAllStream = this.mFactory.createXMLStreamWriter(new FileWriter(fileName));
        this.mAllStream.writeStartDocument();
        this.mAllStream.writeStartElement("CIM");
        this.mAllStream.writeAttribute("CIMVERSION", CIM_VERSION);
        this.mAllStream.writeAttribute("DTDVERSION", DTD_VERSION);
        this.mAllStream.writeStartElement("DECLARATION");
        this.mAllStream.writeStartElement("DECLGROUP");
    }

    private void closeIndexFile() throws IOException, XMLStreamException {
        this.mIndexStream.writeEndElement();
        this.mIndexStream.writeEndDocument();
        this.mIndexStream.close();
    }

    private void closeAllFile() throws IOException, XMLStreamException {
        this.mAllStream.writeEndElement();
        this.mAllStream.writeEndElement();
        this.mAllStream.writeEndElement();
        this.mAllStream.writeEndDocument();
        this.mAllStream.close();
    }

    private void writeAllClasses(CIMClass curClassEl) throws IOException, XMLStreamException {
        this.mIndexStream.writeStartElement("CLASS");
        this.mIndexStream.writeAttribute("NAME", curClassEl.getName());
        if (curClassEl.getSuperClassName() != null && curClassEl.getSuperClassName().length() != 0) {
            this.mIndexStream.writeAttribute("SUPERCLASS", curClassEl.getSuperClassName());
        }
        if (curClassEl.isAssociation()) {
            this.mIndexStream.writeAttribute("ASSOCIATION", "true");
        }
        this.mIndexStream.writeEndElement();
    }

    private void writeToAll(Object ce) throws IOException, XMLStreamException {
        if (ce instanceof CIMQualifierType) {
            CIMXMLElementsWriter.writeQualifierType(this.mAllStream, (CIMQualifierType)ce);
        } else {
            this.mAllStream.writeStartElement("VALUE.OBJECT");
            if (ce instanceof CIMClass) {
                CIMClass c = (CIMClass)ce;
                if (this.mLocalOnly) {
                    c = c.filterProperties(true, true);
                }
                CIMXMLElementsWriter.writeClass(this.mAllStream, c);
            } else if (ce instanceof CIMInstance) {
                CIMXMLElementsWriter.writeInstance(this.mAllStream, (CIMInstance)ce);
            }
            this.mAllStream.writeEndElement();
        }
    }

    public void writeElement(Object ce) throws IOException, XMLStreamException {
        if (this.record) {
            this.writeToAll(ce);
            if (ce instanceof CIMClass) {
                CIMClass c = (CIMClass)ce;
                if (this.mLocalOnly) {
                    c = c.filterProperties(true, true);
                }
                this.writeAllClasses(c);
            }
        }
        if (ce instanceof CIMQualifierType || !this.individual) {
            return;
        }
        StringBuilder className = new StringBuilder();
        if (ce instanceof CIMElement) {
            className.append(((CIMElement)ce).getName());
        }
        if (ce instanceof CIMInstance) {
            className.append(((CIMInstance)ce).getClassName() + "Instance");
        }
        className.append(".xml");
        XMLStreamWriter fileStream = this.mFactory.createXMLStreamWriter(new FileWriter(this.mOutdir + File.separator + className.toString()));
        fileStream.writeStartDocument();
        fileStream.writeStartElement("CIM");
        fileStream.writeAttribute("CIMVERSION", CIM_VERSION);
        fileStream.writeAttribute("DTDVERSION", DTD_VERSION);
        fileStream.writeStartElement("DECLARATION");
        fileStream.writeStartElement("DECLGROUP");
        fileStream.writeStartElement("VALUE.OBJECT");
        if (ce instanceof CIMClass) {
            CIMClass c = (CIMClass)ce;
            if (this.mLocalOnly) {
                c = c.filterProperties(true, true);
            }
            CIMXMLElementsWriter.writeClass(fileStream, c);
        } else if (ce instanceof CIMInstance) {
            CIMXMLElementsWriter.writeInstance(fileStream, (CIMInstance)ce);
        }
        fileStream.writeEndElement();
        fileStream.writeEndElement();
        fileStream.writeEndElement();
        fileStream.writeEndElement();
        fileStream.close();
    }
}

