/*
 * Decompiled with CFR 0.152.
 */
package com.ws.utilities;

import com.ws.utilities.WSIStandardMessages;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.crypto.Cipher;

public class FileDecrypt {
    final int DECRYPT_BUFFER_LENGTH = 256;
    public static final int AES_Key_Size = 128;
    private static final String TRANSFORMATION = "RSA";
    private static final String PRIVATE_KEY = "/private.der";
    private static final String ZIP_FILE = "c:\\del\\decryptTest\\results.zip";
    private static final String DECRYPTED_FILE = "c:\\del\\decryptTest\\index.html";
    private static final String ENCRYPTED_FILE = "results.submit";

    public void decryptFile(String encryptedFileName, String decryptedFile) throws Exception {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            try {
                fis = new FileInputStream(encryptedFileName);
            }
            catch (FileNotFoundException exc) {
                Object[] o = new Object[]{encryptedFileName};
                throw new IllegalArgumentException(WSIStandardMessages.getMessage("ERROR_FILE_NOT_FOUND", o));
            }
            try {
                fos = new FileOutputStream(decryptedFile);
            }
            catch (FileNotFoundException exc) {
                Object[] o = new Object[]{decryptedFile};
                throw new IllegalArgumentException(WSIStandardMessages.getMessage("ERROR_FILE_NOT_FOUND", o));
            }
            PrivateKey privateKey = this.getPrivateKey(PRIVATE_KEY);
            byte[] buffer = new byte[256];
            int read = 0;
            while (read >= 0) {
                read = fis.read(buffer, 0, 256);
                if (read <= 0) continue;
                byte[] newArray = Arrays.copyOf(buffer, read);
                byte[] decryptedData = FileDecrypt.decrypt(newArray, privateKey);
                fos.write(decryptedData);
                buffer = new byte[256];
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception exp) {
            Object[] o = new Object[]{exp.getMessage()};
            throw new Exception(WSIStandardMessages.getMessage("ERROR_DECRYPT_FILE", o));
        }
        finally {
            try {
                if (null != fis) {
                    fis.close();
                }
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException ioExc) {}
        }
    }

    private String unzipFile(String zipFilename) {
        FileInputStream fis = null;
        ZipInputStream zipIs = null;
        ZipEntry zEntry = null;
        String extractedFile = null;
        try {
            File file = new File(zipFilename);
            fis = new FileInputStream(zipFilename);
            zipIs = new ZipInputStream(new BufferedInputStream(fis));
            while ((zEntry = zipIs.getNextEntry()) != null) {
                try {
                    File zipEntryPath = new File(zEntry.getName());
                    String zipEntryFileName = zipEntryPath.getName();
                    if (!zipEntryFileName.equals(ENCRYPTED_FILE)) continue;
                    byte[] tmp = new byte[4096];
                    FileOutputStream fos = null;
                    extractedFile = zipEntryFileName;
                    if (null != file.getParent()) {
                        extractedFile = file.getParent() + File.separator + zipEntryFileName;
                    }
                    System.out.println("Extracting file to " + extractedFile);
                    fos = new FileOutputStream(extractedFile);
                    int size = 0;
                    while ((size = zipIs.read(tmp)) != -1) {
                        fos.write(tmp, 0, size);
                    }
                    fos.flush();
                    fos.close();
                    break;
                }
                catch (Exception ex) {
                    System.out.println("Caught exception when unzipping " + zipFilename + ": " + ex.getMessage());
                    System.exit(-1);
                }
            }
            zipIs.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find file: " + zipFilename);
            System.exit(-1);
        }
        catch (IOException e) {
            System.out.println("Caught exception opening " + zipFilename + ": " + e.getMessage());
            System.exit(-1);
        }
        return extractedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey getPrivateKey(String privateKeyName) throws Exception {
        PrivateKey ret = null;
        InputStream inputStreamPrivateKey = null;
        try {
            inputStreamPrivateKey = this.getClass().getResourceAsStream(privateKeyName);
            if (null == inputStreamPrivateKey) {
                Object[] o = new Object[]{privateKeyName};
                throw new IllegalArgumentException(WSIStandardMessages.getMessage("ERROR_FILE_NOT_FOUND", o));
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int next = inputStreamPrivateKey.read();
            while (next > -1) {
                bos.write(next);
                next = inputStreamPrivateKey.read();
            }
            bos.flush();
            byte[] encodedKey = bos.toByteArray();
            inputStreamPrivateKey.read(encodedKey);
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(encodedKey);
            KeyFactory kf = KeyFactory.getInstance(TRANSFORMATION);
            ret = kf.generatePrivate(privateKeySpec);
        }
        finally {
            if (null != inputStreamPrivateKey) {
                try {
                    inputStreamPrivateKey.close();
                }
                catch (IOException ioExp) {}
            }
        }
        return ret;
    }

    private static byte[] decrypt(byte[] inpBytes, PrivateKey key) throws Exception {
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(2, key);
        return cipher.doFinal(inpBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String unzippedFile = null;
        try {
            FileDecrypt fileDecrypt = new FileDecrypt();
            unzippedFile = fileDecrypt.unzipFile(ZIP_FILE);
            if (null == unzippedFile) {
                System.out.println("Could not find file results.submit in zip file c:\\del\\decryptTest\\results.zip");
            } else {
                fileDecrypt.decryptFile(unzippedFile, DECRYPTED_FILE);
            }
        }
        catch (Exception we) {
            System.out.println(we.getMessage());
        }
        finally {
            if (null != unzippedFile) {
                File file = new File(unzippedFile);
                file.deleteOnExit();
            }
        }
    }
}

