/*
 * Decompiled with CFR 0.152.
 */
package com.ws.utilities.commandgenerator;

import com.ws.utilities.commandgenerator.CommandGenerator;
import com.ws.utilities.commandgenerator.JavaCommandGenerator;
import com.ws.utilities.commandgenerator.TextCommandGenerator;
import com.ws.utilities.commandgenerator.WBEMMethodCommandGenerator;
import com.ws.utilities.commandgenerator.WBEMOpCommandGenerator;

public class CommandGeneratorFactory {
    public static final String TEXT = "text";
    public static final String WBEMOP = "wbemop";
    public static final String JAVA = "java";
    public static final String WBEMMETHOD = "wbemmethod";

    public static CommandGenerator getGenerator(String pFormat) {
        if (TEXT.equalsIgnoreCase(pFormat)) {
            return new TextCommandGenerator();
        }
        if (JAVA.equalsIgnoreCase(pFormat)) {
            return new JavaCommandGenerator();
        }
        if (WBEMOP.equalsIgnoreCase(pFormat)) {
            return new WBEMOpCommandGenerator();
        }
        if (WBEMMETHOD.equalsIgnoreCase(pFormat)) {
            return new WBEMMethodCommandGenerator();
        }
        return null;
    }

    public static String[] getSupportedGenerators() throws Exception {
        String[] supportGen = new String[]{TEXT, JAVA, WBEMOP, WBEMMETHOD};
        return supportGen;
    }
}

