/*
 * Decompiled with CFR 0.152.
 */
package com.ws.utilities.wbem;

import java.util.ArrayList;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMDateTimeInterval;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;

public class ValueHelper {
    public static Object typeConvert(CIMDataType dt, Object value) {
        if (value == null) {
            return value;
        }
        if (dt == null) {
            throw new IllegalArgumentException("DataType can not be null");
        }
        if (dt.getRefClassName() != null) {
            if (dt.isArray()) {
                if (value instanceof CIMObjectPath[]) {
                    return value;
                }
                if (value instanceof String[]) {
                    ArrayList<CIMObjectPath> aList = new ArrayList<CIMObjectPath>();
                    String[] stringArray = (String[])value;
                    for (int i = 0; i < stringArray.length; ++i) {
                        aList.add(new CIMObjectPath(stringArray[i]));
                    }
                    return aList.toArray(new CIMObjectPath[aList.size()]);
                }
            } else {
                if (value instanceof CIMObjectPath) {
                    return value;
                }
                if (value instanceof String) {
                    return new CIMObjectPath((String)value);
                }
            }
            throw new IllegalArgumentException("Can not convert \"" + value + "\" to a an Object Path");
        }
        CIMDataType cvt = CIMDataType.getDataType((Object)value);
        if (cvt.equals((Object)dt)) {
            return value;
        }
        if (cvt.getType() == 16) {
            return value;
        }
        if (dt.isArray() != cvt.isArray()) {
            throw new IllegalArgumentException(value.toString());
        }
        int cdt = dt.getType();
        if (cvt.isArray()) {
            Object[] o = (Object[])value;
            ArrayList<Object> l = new ArrayList<Object>();
            for (int i = 0; i < o.length; ++i) {
                l.add(ValueHelper.intTypeConvert(cdt, o[i]));
            }
            return ValueHelper.arrayConvert(cdt, l);
        }
        return ValueHelper.intTypeConvert(cdt, value);
    }

    public static Object[] arrayConvert(int type, ArrayList<Object> l) {
        switch (type) {
            case 9: {
                return l.toArray(new Boolean[l.size()]);
            }
            case 12: {
                return l.toArray(new CIMDateTime[l.size()]);
            }
            case 14: {
                return l.toArray(new CIMObjectPath[l.size()]);
            }
            case 0: {
                return l.toArray(new UnsignedInteger8[l.size()]);
            }
            case 1: {
                return l.toArray(new Byte[l.size()]);
            }
            case 2: {
                return l.toArray(new UnsignedInteger16[l.size()]);
            }
            case 3: {
                return l.toArray(new Short[l.size()]);
            }
            case 4: {
                return l.toArray(new UnsignedInteger32[l.size()]);
            }
            case 5: {
                return l.toArray(new Integer[l.size()]);
            }
            case 6: {
                return l.toArray(new UnsignedInteger64[l.size()]);
            }
            case 7: {
                return l.toArray(new Long[l.size()]);
            }
            case 10: {
                return l.toArray(new Float[l.size()]);
            }
            case 11: {
                return l.toArray(new Double[l.size()]);
            }
            case 13: {
                return l.toArray(new Character[l.size()]);
            }
            case 8: {
                return l.toArray(new String[l.size()]);
            }
            case 15: {
                return l.toArray(new CIMInstance[l.size()]);
            }
        }
        throw new IllegalArgumentException();
    }

    public static Object intTypeConvert(int type, Object value) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case 8: {
                return value;
            }
            case 13: {
                String a;
                if (value instanceof Character) {
                    return value;
                }
                if (value instanceof String && (a = (String)value).length() >= 0) {
                    return Character.valueOf(a.charAt(0));
                }
                throw new IllegalArgumentException();
            }
            case 12: {
                if (value instanceof CIMDateTime) {
                    return value;
                }
                if (value instanceof String) {
                    String svalue = (String)value;
                    CIMDateTimeAbsolute ret = null;
                    try {
                        ret = new CIMDateTimeAbsolute(svalue);
                    }
                    catch (IllegalArgumentException exp) {
                        ret = new CIMDateTimeInterval(svalue);
                    }
                    return ret;
                }
                throw new IllegalArgumentException();
            }
            case 9: {
                if (value instanceof Boolean) {
                    return value;
                }
                if (value instanceof String) {
                    return new Boolean((String)value);
                }
                throw new IllegalArgumentException();
            }
            case 14: {
                if (value instanceof CIMObjectPath) {
                    return value;
                }
                if (value instanceof String) {
                    String svalue = (String)value;
                    return new CIMObjectPath(svalue);
                }
                throw new IllegalArgumentException();
            }
            case 0: {
                if (value instanceof UnsignedInteger8) {
                    return value;
                }
                if (value instanceof Short) {
                    return new UnsignedInteger8(((Short)value).shortValue());
                }
                if (value instanceof String) {
                    String svalue = (String)value;
                    if (svalue.startsWith("0x")) {
                        return new UnsignedInteger8(Short.parseShort(svalue.substring(2), 16));
                    }
                    return new UnsignedInteger8(svalue);
                }
                throw new IllegalArgumentException();
            }
            case 1: {
                if (value instanceof Byte) {
                    return value;
                }
                if (value instanceof String) {
                    String svalue = (String)value;
                    if (svalue.startsWith("0x")) {
                        return new Byte(Byte.parseByte(svalue.substring(2), 16));
                    }
                    return new Byte(svalue);
                }
                throw new IllegalArgumentException();
            }
            case 2: {
                if (value instanceof UnsignedInteger16) {
                    return value;
                }
                if (value instanceof Integer) {
                    return new UnsignedInteger16(((Integer)value).intValue());
                }
                if (value instanceof String) {
                    String svalue = (String)value;
                    if (svalue.startsWith("0x")) {
                        return new UnsignedInteger16(Integer.parseInt(svalue.substring(2), 16));
                    }
                    return new UnsignedInteger16(svalue);
                }
                throw new IllegalArgumentException();
            }
            case 3: {
                if (value instanceof Short) {
                    return value;
                }
                if (value instanceof String) {
                    String svalue = (String)value;
                    if (svalue.startsWith("0x")) {
                        return new Short(Short.parseShort(svalue.substring(2), 16));
                    }
                    return new Short(svalue);
                }
                throw new IllegalArgumentException();
            }
            case 4: {
                if (value instanceof UnsignedInteger32) {
                    return value;
                }
                if (value instanceof Long) {
                    return new UnsignedInteger32(((Long)value).longValue());
                }
                if (value instanceof String) {
                    String svalue = (String)value;
                    if (svalue.startsWith("0x")) {
                        return new UnsignedInteger32(Long.parseLong(svalue.substring(2), 16));
                    }
                    return new UnsignedInteger32(Long.parseLong(svalue));
                }
                throw new IllegalArgumentException();
            }
            case 5: {
                if (value instanceof Integer) {
                    return value;
                }
                if (value instanceof String) {
                    String svalue = (String)value;
                    if (svalue.startsWith("0x")) {
                        return new Integer(Integer.parseInt(svalue.substring(2), 16));
                    }
                    return new Integer(svalue);
                }
                throw new IllegalArgumentException();
            }
            case 6: {
                if (value instanceof UnsignedInteger64) {
                    return value;
                }
                if (value instanceof String) {
                    String svalue = (String)value;
                    if (svalue.startsWith("0x")) {
                        svalue = String.valueOf(Integer.parseInt(svalue.substring(2), 16));
                    }
                    return new UnsignedInteger64(svalue);
                }
                throw new IllegalArgumentException();
            }
            case 7: {
                if (value instanceof Long) {
                    return value;
                }
                if (value instanceof String) {
                    String svalue = (String)value;
                    if (svalue.startsWith("0x")) {
                        return new Long(Long.parseLong(svalue.substring(2), 16));
                    }
                    return new Long(svalue);
                }
                throw new IllegalArgumentException();
            }
            case 10: {
                if (value instanceof Float) {
                    return value;
                }
                if (value instanceof String) {
                    return new Float((String)value);
                }
                throw new IllegalArgumentException();
            }
            case 11: {
                if (value instanceof Double) {
                    return value;
                }
                if (value instanceof String) {
                    return new Double((String)value);
                }
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }
}

